/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeChangeSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeChangeSetRequest.Builder, DescribeChangeSetRequest> {
    private final String changeSetName;

    private final String stackName;

    private final String nextToken;

    private DescribeChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the change set that you want to describe.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the change set that you want to describe.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you want to
     * describe.
     * </p>
     * 
     * @return If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you want
     *         to describe.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * A string (provided by the <a>DescribeChangeSet</a> response output) that identifies the next page of information
     * that you want to retrieve.
     * </p>
     * 
     * @return A string (provided by the <a>DescribeChangeSet</a> response output) that identifies the next page of
     *         information that you want to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetRequest)) {
            return false;
        }
        DescribeChangeSetRequest other = (DescribeChangeSetRequest) obj;
        return Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (changeSetName() != null) {
            sb.append("ChangeSetName: ").append(changeSetName()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetName":
            return Optional.of(clazz.cast(changeSetName()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, DescribeChangeSetRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the change set that you want to describe.
         * </p>
         * 
         * @param changeSetName
         *        The name or Amazon Resource Name (ARN) of the change set that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you want to
         * describe.
         * </p>
         * 
         * @param stackName
         *        If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you
         *        want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * A string (provided by the <a>DescribeChangeSet</a> response output) that identifies the next page of
         * information that you want to retrieve.
         * </p>
         * 
         * @param nextToken
         *        A string (provided by the <a>DescribeChangeSet</a> response output) that identifies the next page of
         *        information that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String changeSetName;

        private String stackName;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetRequest model) {
            changeSetName(model.changeSetName);
            stackName(model.stackName);
            nextToken(model.nextToken);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeChangeSetRequest build() {
            return new DescribeChangeSetRequest(this);
        }
    }
}
