/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>DescribeStackResource</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackResourceResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackResourceResponse.Builder, DescribeStackResourceResponse> {
    private final StackResourceDetail stackResourceDetail;

    private DescribeStackResourceResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceDetail = builder.stackResourceDetail;
    }

    /**
     * <p>
     * A <code>StackResourceDetail</code> structure containing the description of the specified resource in the
     * specified stack.
     * </p>
     * 
     * @return A <code>StackResourceDetail</code> structure containing the description of the specified resource in the
     *         specified stack.
     */
    public StackResourceDetail stackResourceDetail() {
        return stackResourceDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackResourceDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceResponse)) {
            return false;
        }
        DescribeStackResourceResponse other = (DescribeStackResourceResponse) obj;
        return Objects.equals(stackResourceDetail(), other.stackResourceDetail());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackResourceDetail() != null) {
            sb.append("StackResourceDetail: ").append(stackResourceDetail()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResourceDetail":
            return Optional.of(clazz.cast(stackResourceDetail()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, DescribeStackResourceResponse> {
        /**
         * <p>
         * A <code>StackResourceDetail</code> structure containing the description of the specified resource in the
         * specified stack.
         * </p>
         * 
         * @param stackResourceDetail
         *        A <code>StackResourceDetail</code> structure containing the description of the specified resource in
         *        the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDetail(StackResourceDetail stackResourceDetail);

        /**
         * <p>
         * A <code>StackResourceDetail</code> structure containing the description of the specified resource in the
         * specified stack.
         * </p>
         * This is a convenience that creates an instance of the {@link StackResourceDetail.Builder} avoiding the need
         * to create one manually via {@link StackResourceDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackResourceDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #stackResourceDetail(StackResourceDetail)}.
         * 
         * @param stackResourceDetail
         *        a consumer that will call methods on {@link StackResourceDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackResourceDetail(StackResourceDetail)
         */
        default Builder stackResourceDetail(Consumer<StackResourceDetail.Builder> stackResourceDetail) {
            return stackResourceDetail(StackResourceDetail.builder().apply(stackResourceDetail).build());
        }
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private StackResourceDetail stackResourceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourceResponse model) {
            stackResourceDetail(model.stackResourceDetail);
        }

        public final StackResourceDetail.Builder getStackResourceDetail() {
            return stackResourceDetail != null ? stackResourceDetail.toBuilder() : null;
        }

        @Override
        public final Builder stackResourceDetail(StackResourceDetail stackResourceDetail) {
            this.stackResourceDetail = stackResourceDetail;
            return this;
        }

        public final void setStackResourceDetail(StackResourceDetail.BuilderImpl stackResourceDetail) {
            this.stackResourceDetail = stackResourceDetail != null ? stackResourceDetail.build() : null;
        }

        @Override
        public DescribeStackResourceResponse build() {
            return new DescribeStackResourceResponse(this);
        }
    }
}
