/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackSetOperationResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackSetOperationResponse.Builder, DescribeStackSetOperationResponse> {
    private final StackSetOperation stackSetOperation;

    private DescribeStackSetOperationResponse(BuilderImpl builder) {
        super(builder);
        this.stackSetOperation = builder.stackSetOperation;
    }

    /**
     * <p>
     * The specified stack set operation.
     * </p>
     * 
     * @return The specified stack set operation.
     */
    public StackSetOperation stackSetOperation() {
        return stackSetOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetOperation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetOperationResponse)) {
            return false;
        }
        DescribeStackSetOperationResponse other = (DescribeStackSetOperationResponse) obj;
        return Objects.equals(stackSetOperation(), other.stackSetOperation());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackSetOperation() != null) {
            sb.append("StackSetOperation: ").append(stackSetOperation()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetOperation":
            return Optional.of(clazz.cast(stackSetOperation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, DescribeStackSetOperationResponse> {
        /**
         * <p>
         * The specified stack set operation.
         * </p>
         * 
         * @param stackSetOperation
         *        The specified stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetOperation(StackSetOperation stackSetOperation);

        /**
         * <p>
         * The specified stack set operation.
         * </p>
         * This is a convenience that creates an instance of the {@link StackSetOperation.Builder} avoiding the need to
         * create one manually via {@link StackSetOperation#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackSetOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #stackSetOperation(StackSetOperation)}.
         * 
         * @param stackSetOperation
         *        a consumer that will call methods on {@link StackSetOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackSetOperation(StackSetOperation)
         */
        default Builder stackSetOperation(Consumer<StackSetOperation.Builder> stackSetOperation) {
            return stackSetOperation(StackSetOperation.builder().apply(stackSetOperation).build());
        }
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private StackSetOperation stackSetOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetOperationResponse model) {
            stackSetOperation(model.stackSetOperation);
        }

        public final StackSetOperation.Builder getStackSetOperation() {
            return stackSetOperation != null ? stackSetOperation.toBuilder() : null;
        }

        @Override
        public final Builder stackSetOperation(StackSetOperation stackSetOperation) {
            this.stackSetOperation = stackSetOperation;
            return this;
        }

        public final void setStackSetOperation(StackSetOperation.BuilderImpl stackSetOperation) {
            this.stackSetOperation = stackSetOperation != null ? stackSetOperation.build() : null;
        }

        @Override
        public DescribeStackSetOperationResponse build() {
            return new DescribeStackSetOperationResponse(this);
        }
    }
}
