/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>EstimateTemplateCost</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EstimateTemplateCostResponse extends CloudFormationResponse implements
        ToCopyableBuilder<EstimateTemplateCostResponse.Builder, EstimateTemplateCostResponse> {
    private final String url;

    private EstimateTemplateCostResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
    }

    /**
     * <p>
     * An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the
     * template.
     * </p>
     * 
     * @return An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the
     *         template.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimateTemplateCostResponse)) {
            return false;
        }
        EstimateTemplateCostResponse other = (EstimateTemplateCostResponse) obj;
        return Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.of(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, EstimateTemplateCostResponse> {
        /**
         * <p>
         * An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run the
         * template.
         * </p>
         * 
         * @param url
         *        An AWS Simple Monthly Calculator URL with a query string that describes the resources required to run
         *        the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimateTemplateCostResponse model) {
            url(model.url);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public EstimateTemplateCostResponse build() {
            return new EstimateTemplateCostResponse(this);
        }
    }
}
