/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListExportsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListExportsResponse.Builder, ListExportsResponse> {
    private final List<Export> exports;

    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        super(builder);
        this.exports = builder.exports;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The output for the <a>ListExports</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The output for the <a>ListExports</a> action.
     */
    public List<Export> exports() {
        return exports;
    }

    /**
     * <p>
     * If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there is
     * no additional page, this value is null.
     * </p>
     * 
     * @return If the output exceeds 100 exported output values, a string that identifies the next page of exports. If
     *         there is no additional page, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exports());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse) obj;
        return Objects.equals(exports(), other.exports()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (exports() != null) {
            sb.append("Exports: ").append(exports()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Exports":
            return Optional.of(clazz.cast(exports()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, ListExportsResponse> {
        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * 
         * @param exports
         *        The output for the <a>ListExports</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Collection<Export> exports);

        /**
         * <p>
         * The output for the <a>ListExports</a> action.
         * </p>
         * 
         * @param exports
         *        The output for the <a>ListExports</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exports(Export... exports);

        /**
         * <p>
         * If the output exceeds 100 exported output values, a string that identifies the next page of exports. If there
         * is no additional page, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 100 exported output values, a string that identifies the next page of exports.
         *        If there is no additional page, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<Export> exports;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            exports(model.exports);
            nextToken(model.nextToken);
        }

        public final Collection<Export.Builder> getExports() {
            return exports != null ? exports.stream().map(Export::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exports(Collection<Export> exports) {
            this.exports = ExportsCopier.copy(exports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exports(Export... exports) {
            exports(Arrays.asList(exports));
            return this;
        }

        public final void setExports(Collection<Export.BuilderImpl> exports) {
            this.exports = ExportsCopier.copyFromBuilder(exports);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }
    }
}
