/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListImportsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListImportsRequest.Builder, ListImportsRequest> {
    private final String exportName;

    private final String nextToken;

    private ListImportsRequest(BuilderImpl builder) {
        super(builder);
        this.exportName = builder.exportName;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the exported output value. AWS CloudFormation returns the stack names that are importing this value.
     * </p>
     * 
     * @return The name of the exported output value. AWS CloudFormation returns the stack names that are importing this
     *         value.
     */
    public String exportName() {
        return exportName;
    }

    /**
     * <p>
     * A string (provided by the <a>ListImports</a> response output) that identifies the next page of stacks that are
     * importing the specified exported output value.
     * </p>
     * 
     * @return A string (provided by the <a>ListImports</a> response output) that identifies the next page of stacks
     *         that are importing the specified exported output value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsRequest)) {
            return false;
        }
        ListImportsRequest other = (ListImportsRequest) obj;
        return Objects.equals(exportName(), other.exportName()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (exportName() != null) {
            sb.append("ExportName: ").append(exportName()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportName":
            return Optional.of(clazz.cast(exportName()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, ListImportsRequest> {
        /**
         * <p>
         * The name of the exported output value. AWS CloudFormation returns the stack names that are importing this
         * value.
         * </p>
         * 
         * @param exportName
         *        The name of the exported output value. AWS CloudFormation returns the stack names that are importing
         *        this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportName(String exportName);

        /**
         * <p>
         * A string (provided by the <a>ListImports</a> response output) that identifies the next page of stacks that
         * are importing the specified exported output value.
         * </p>
         * 
         * @param nextToken
         *        A string (provided by the <a>ListImports</a> response output) that identifies the next page of stacks
         *        that are importing the specified exported output value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String exportName;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsRequest model) {
            exportName(model.exportName);
            nextToken(model.nextToken);
        }

        public final String getExportName() {
            return exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListImportsRequest build() {
            return new ListImportsRequest(this);
        }
    }
}
