/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>SetStackPolicy</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetStackPolicyRequest extends CloudFormationRequest implements
        ToCopyableBuilder<SetStackPolicyRequest.Builder, SetStackPolicyRequest> {
    private final String stackName;

    private final String stackPolicyBody;

    private final String stackPolicyURL;

    private SetStackPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
    }

    /**
     * <p>
     * The name or unique stack ID that you want to associate a policy with.
     * </p>
     * 
     * @return The name or unique stack ID that you want to associate a policy with.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Structure containing the stack policy body. For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
     * Updates to Stack Resources</a> in the AWS CloudFormation User Guide. You can specify either the
     * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Structure containing the stack policy body. For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
     *         Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide. You can specify either the
     *         <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public String stackPolicyBody() {
        return stackPolicyBody;
    }

    /**
     * <p>
     * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in
     * an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or the
     * <code>StackPolicyURL</code> parameter, but not both.
     * </p>
     * 
     * @return Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
     *         located in an S3 bucket in the same region as the stack. You can specify either the
     *         <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
     */
    public String stackPolicyURL() {
        return stackPolicyURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(stackPolicyURL());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStackPolicyRequest)) {
            return false;
        }
        SetStackPolicyRequest other = (SetStackPolicyRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(stackPolicyBody(), other.stackPolicyBody())
                && Objects.equals(stackPolicyURL(), other.stackPolicyURL());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (stackPolicyBody() != null) {
            sb.append("StackPolicyBody: ").append(stackPolicyBody()).append(",");
        }
        if (stackPolicyURL() != null) {
            sb.append("StackPolicyURL: ").append(stackPolicyURL()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "StackPolicyBody":
            return Optional.of(clazz.cast(stackPolicyBody()));
        case "StackPolicyURL":
            return Optional.of(clazz.cast(stackPolicyURL()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, SetStackPolicyRequest> {
        /**
         * <p>
         * The name or unique stack ID that you want to associate a policy with.
         * </p>
         * 
         * @param stackName
         *        The name or unique stack ID that you want to associate a policy with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Structure containing the stack policy body. For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html"> Prevent
         * Updates to Stack Resources</a> in the AWS CloudFormation User Guide. You can specify either the
         * <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyBody
         *        Structure containing the stack policy body. For more information, go to <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">
         *        Prevent Updates to Stack Resources</a> in the AWS CloudFormation User Guide. You can specify either
         *        the <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyBody(String stackPolicyBody);

        /**
         * <p>
         * Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located
         * in an S3 bucket in the same region as the stack. You can specify either the <code>StackPolicyBody</code> or
         * the <code>StackPolicyURL</code> parameter, but not both.
         * </p>
         * 
         * @param stackPolicyURL
         *        Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB)
         *        located in an S3 bucket in the same region as the stack. You can specify either the
         *        <code>StackPolicyBody</code> or the <code>StackPolicyURL</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackPolicyURL(String stackPolicyURL);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String stackPolicyBody;

        private String stackPolicyURL;

        private BuilderImpl() {
        }

        private BuilderImpl(SetStackPolicyRequest model) {
            stackName(model.stackName);
            stackPolicyBody(model.stackPolicyBody);
            stackPolicyURL(model.stackPolicyURL);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getStackPolicyBody() {
            return stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetStackPolicyRequest build() {
            return new SetStackPolicyRequest(this);
        }
    }
}
