/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The StackEvent data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackEvent implements ToCopyableBuilder<StackEvent.Builder, StackEvent> {
    private final String stackId;

    private final String eventId;

    private final String stackName;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final Instant timestamp;

    private final String resourceStatus;

    private final String resourceStatusReason;

    private final String resourceProperties;

    private final String clientRequestToken;

    private StackEvent(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.eventId = builder.eventId;
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.resourceProperties = builder.resourceProperties;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The unique ID name of the instance of the stack.
     * </p>
     * 
     * @return The unique ID name of the instance of the stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The unique ID of this event.
     * </p>
     * 
     * @return The unique ID of this event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The name associated with a stack.
     * </p>
     * 
     * @return The name associated with a stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical name of the resource specified in the template.
     * </p>
     * 
     * @return The logical name of the resource specified in the template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier associated with the physical instance of the resource.
     * </p>
     * 
     * @return The name or unique identifier associated with the physical instance of the resource.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * Type of resource. (For more information, go to <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS
     * Resource Types Reference</a> in the AWS CloudFormation User Guide.)
     * </p>
     * 
     * @return Type of resource. (For more information, go to <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
     *         AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Time the status was updated.
     * </p>
     * 
     * @return Time the status was updated.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(resourceStatus);
    }

    /**
     * <p>
     * Current status of the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceStatus}
     * will return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStatusString}.
     * </p>
     * 
     * @return Current status of the resource.
     * @see ResourceStatus
     */
    public String resourceStatusString() {
        return resourceStatus;
    }

    /**
     * <p>
     * Success/failure message associated with the resource.
     * </p>
     * 
     * @return Success/failure message associated with the resource.
     */
    public String resourceStatusReason() {
        return resourceStatusReason;
    }

    /**
     * <p>
     * BLOB of the properties used to create the resource.
     * </p>
     * 
     * @return BLOB of the properties used to create the resource.
     */
    public String resourceProperties() {
        return resourceProperties;
    }

    /**
     * <p>
     * The token passed to the operation that generated this event.
     * </p>
     * <p>
     * All events triggered by a given stack operation are assigned the same client request token, which you can use to
     * track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     * <code>ClientRequestToken</code> set as <code>token1</code>.
     * </p>
     * <p>
     * In the console, stack operations display the client request token on the Events tab. Stack operations that are
     * initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily identify
     * the stack operation . For example, if you create a stack using the console, each stack event would be assigned
     * the same token in the following format: <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     * </p>
     * 
     * @return The token passed to the operation that generated this event.</p>
     *         <p>
     *         All events triggered by a given stack operation are assigned the same client request token, which you can
     *         use to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
     *         <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
     *         <code>ClientRequestToken</code> set as <code>token1</code>.
     *         </p>
     *         <p>
     *         In the console, stack operations display the client request token on the Events tab. Stack operations
     *         that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
     *         you easily identify the stack operation . For example, if you create a stack using the console, each
     *         stack event would be assigned the same token in the following format:
     *         <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackEvent)) {
            return false;
        }
        StackEvent other = (StackEvent) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(stackName(), other.stackName())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(resourceStatusString(), other.resourceStatusString())
                && Objects.equals(resourceStatusReason(), other.resourceStatusReason())
                && Objects.equals(resourceProperties(), other.resourceProperties())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (eventId() != null) {
            sb.append("EventId: ").append(eventId()).append(",");
        }
        if (stackName() != null) {
            sb.append("StackName: ").append(stackName()).append(",");
        }
        if (logicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(logicalResourceId()).append(",");
        }
        if (physicalResourceId() != null) {
            sb.append("PhysicalResourceId: ").append(physicalResourceId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        if (resourceStatusString() != null) {
            sb.append("ResourceStatus: ").append(resourceStatusString()).append(",");
        }
        if (resourceStatusReason() != null) {
            sb.append("ResourceStatusReason: ").append(resourceStatusReason()).append(",");
        }
        if (resourceProperties() != null) {
            sb.append("ResourceProperties: ").append(resourceProperties()).append(",");
        }
        if (clientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(clientRequestToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "EventId":
            return Optional.of(clazz.cast(eventId()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "LogicalResourceId":
            return Optional.of(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.of(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.of(clazz.cast(resourceType()));
        case "Timestamp":
            return Optional.of(clazz.cast(timestamp()));
        case "ResourceStatus":
            return Optional.of(clazz.cast(resourceStatusString()));
        case "ResourceStatusReason":
            return Optional.of(clazz.cast(resourceStatusReason()));
        case "ResourceProperties":
            return Optional.of(clazz.cast(resourceProperties()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StackEvent> {
        /**
         * <p>
         * The unique ID name of the instance of the stack.
         * </p>
         * 
         * @param stackId
         *        The unique ID name of the instance of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The unique ID of this event.
         * </p>
         * 
         * @param eventId
         *        The unique ID of this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The name associated with a stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with a stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical name of the resource specified in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource specified in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier associated with the physical instance of the resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier associated with the physical instance of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * Type of resource. (For more information, go to <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html"> AWS
         * Resource Types Reference</a> in the AWS CloudFormation User Guide.)
         * </p>
         * 
         * @param resourceType
         *        Type of resource. (For more information, go to <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">
         *        AWS Resource Types Reference</a> in the AWS CloudFormation User Guide.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Time the status was updated.
         * </p>
         * 
         * @param timestamp
         *        Time the status was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(String resourceStatus);

        /**
         * <p>
         * Current status of the resource.
         * </p>
         * 
         * @param resourceStatus
         *        Current status of the resource.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Success/failure message associated with the resource.
         * </p>
         * 
         * @param resourceStatusReason
         *        Success/failure message associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatusReason(String resourceStatusReason);

        /**
         * <p>
         * BLOB of the properties used to create the resource.
         * </p>
         * 
         * @param resourceProperties
         *        BLOB of the properties used to create the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceProperties(String resourceProperties);

        /**
         * <p>
         * The token passed to the operation that generated this event.
         * </p>
         * <p>
         * All events triggered by a given stack operation are assigned the same client request token, which you can use
         * to track operations. For example, if you execute a <code>CreateStack</code> operation with the token
         * <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         * <code>ClientRequestToken</code> set as <code>token1</code>.
         * </p>
         * <p>
         * In the console, stack operations display the client request token on the Events tab. Stack operations that
         * are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps you easily
         * identify the stack operation . For example, if you create a stack using the console, each stack event would
         * be assigned the same token in the following format:
         * <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * </p>
         * 
         * @param clientRequestToken
         *        The token passed to the operation that generated this event.</p>
         *        <p>
         *        All events triggered by a given stack operation are assigned the same client request token, which you
         *        can use to track operations. For example, if you execute a <code>CreateStack</code> operation with the
         *        token <code>token1</code>, then all the <code>StackEvents</code> generated by that operation will have
         *        <code>ClientRequestToken</code> set as <code>token1</code>.
         *        </p>
         *        <p>
         *        In the console, stack operations display the client request token on the Events tab. Stack operations
         *        that are initiated from the console use the token format <i>Console-StackOperation-ID</i>, which helps
         *        you easily identify the stack operation . For example, if you create a stack using the console, each
         *        stack event would be assigned the same token in the following format:
         *        <code>Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String eventId;

        private String stackName;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private Instant timestamp;

        private String resourceStatus;

        private String resourceStatusReason;

        private String resourceProperties;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StackEvent model) {
            stackId(model.stackId);
            eventId(model.eventId);
            stackName(model.stackName);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            timestamp(model.timestamp);
            resourceStatus(model.resourceStatus);
            resourceStatusReason(model.resourceStatusReason);
            resourceProperties(model.resourceProperties);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getResourceStatus() {
            return resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final String getResourceStatusReason() {
            return resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public final String getResourceProperties() {
            return resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public StackEvent build() {
            return new StackEvent(this);
        }
    }
}
