/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains information about a specified operation's results for a given account in a given region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackSetOperationResultSummary implements
        ToCopyableBuilder<StackSetOperationResultSummary.Builder, StackSetOperationResultSummary> {
    private final String account;

    private final String region;

    private final String status;

    private final String statusReason;

    private final AccountGateResult accountGateResult;

    private StackSetOperationResultSummary(BuilderImpl builder) {
        this.account = builder.account;
        this.region = builder.region;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGateResult = builder.accountGateResult;
    }

    /**
     * <p>
     * The name of the AWS account for this operation result.
     * </p>
     * 
     * @return The name of the AWS account for this operation result.
     */
    public String account() {
        return account;
    }

    /**
     * <p>
     * The name of the AWS region for this operation result.
     * </p>
     * 
     * @return The name of the AWS region for this operation result.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The result status of the stack set operation for the given account in the given region.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is either
     * because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation
     * has been exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation in the specified account and region failed.
     * </p>
     * <p>
     * If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack set
     * operation as a whole might be exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation in the specified account and region has yet to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackSetOperationResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusString}.
     * </p>
     * 
     * @return The result status of the stack set operation for the given account in the given region.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is
     *         either because a user has stopped the stack set operation, or because the failure tolerance of the stack
     *         set operation has been exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation in the specified account and region failed.
     *         </p>
     *         <p>
     *         If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack
     *         set operation as a whole might be exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The operation in the specified account and region has yet to start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
     *         </p>
     *         </li>
     * @see StackSetOperationResultStatus
     */
    public StackSetOperationResultStatus status() {
        return StackSetOperationResultStatus.fromValue(status);
    }

    /**
     * <p>
     * The result status of the stack set operation for the given account in the given region.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is either
     * because a user has stopped the stack set operation, or because the failure tolerance of the stack set operation
     * has been exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation in the specified account and region failed.
     * </p>
     * <p>
     * If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack set
     * operation as a whole might be exceeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation in the specified account and region has yet to start.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackSetOperationResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusString}.
     * </p>
     * 
     * @return The result status of the stack set operation for the given account in the given region.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is
     *         either because a user has stopped the stack set operation, or because the failure tolerance of the stack
     *         set operation has been exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation in the specified account and region failed.
     *         </p>
     *         <p>
     *         If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack
     *         set operation as a whole might be exceeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The operation in the specified account and region has yet to start.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
     *         </p>
     *         </li>
     * @see StackSetOperationResultStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The reason for the assigned result status.
     * </p>
     * 
     * @return The reason for the assigned result status.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The results of the account gate function AWS CloudFormation invokes, if present, before proceeding with stack set
     * operations in an account
     * </p>
     * 
     * @return The results of the account gate function AWS CloudFormation invokes, if present, before proceeding with
     *         stack set operations in an account
     */
    public AccountGateResult accountGateResult() {
        return accountGateResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(accountGateResult());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationResultSummary)) {
            return false;
        }
        StackSetOperationResultSummary other = (StackSetOperationResultSummary) obj;
        return Objects.equals(account(), other.account()) && Objects.equals(region(), other.region())
                && Objects.equals(statusString(), other.statusString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(accountGateResult(), other.accountGateResult());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (account() != null) {
            sb.append("Account: ").append(account()).append(",");
        }
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusReason() != null) {
            sb.append("StatusReason: ").append(statusReason()).append(",");
        }
        if (accountGateResult() != null) {
            sb.append("AccountGateResult: ").append(accountGateResult()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.of(clazz.cast(account()));
        case "Region":
            return Optional.of(clazz.cast(region()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "StatusReason":
            return Optional.of(clazz.cast(statusReason()));
        case "AccountGateResult":
            return Optional.of(clazz.cast(accountGateResult()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StackSetOperationResultSummary> {
        /**
         * <p>
         * The name of the AWS account for this operation result.
         * </p>
         * 
         * @param account
         *        The name of the AWS account for this operation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The name of the AWS region for this operation result.
         * </p>
         * 
         * @param region
         *        The name of the AWS region for this operation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The result status of the stack set operation for the given account in the given region.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is either
         * because a user has stopped the stack set operation, or because the failure tolerance of the stack set
         * operation has been exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation in the specified account and region failed.
         * </p>
         * <p>
         * If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack set
         * operation as a whole might be exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation in the specified account and region has yet to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The result status of the stack set operation for the given account in the given region.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is
         *        either because a user has stopped the stack set operation, or because the failure tolerance of the
         *        stack set operation has been exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation in the specified account and region failed.
         *        </p>
         *        <p>
         *        If the stack set operation fails in enough accounts within a region, the failure tolerance for the
         *        stack set operation as a whole might be exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation in the specified account and region has yet to start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
         *        </p>
         *        </li>
         * @see StackSetOperationResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationResultStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The result status of the stack set operation for the given account in the given region.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is either
         * because a user has stopped the stack set operation, or because the failure tolerance of the stack set
         * operation has been exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation in the specified account and region failed.
         * </p>
         * <p>
         * If the stack set operation fails in enough accounts within a region, the failure tolerance for the stack set
         * operation as a whole might be exceeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation in the specified account and region has yet to start.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The result status of the stack set operation for the given account in the given region.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CANCELLED</code>: The operation in the specified account and region has been cancelled. This is
         *        either because a user has stopped the stack set operation, or because the failure tolerance of the
         *        stack set operation has been exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation in the specified account and region failed.
         *        </p>
         *        <p>
         *        If the stack set operation fails in enough accounts within a region, the failure tolerance for the
         *        stack set operation as a whole might be exceeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>: The operation in the specified account and region is currently in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation in the specified account and region has yet to start.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>: The operation in the specified account and region completed successfully.
         *        </p>
         *        </li>
         * @see StackSetOperationResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackSetOperationResultStatus
         */
        Builder status(StackSetOperationResultStatus status);

        /**
         * <p>
         * The reason for the assigned result status.
         * </p>
         * 
         * @param statusReason
         *        The reason for the assigned result status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The results of the account gate function AWS CloudFormation invokes, if present, before proceeding with stack
         * set operations in an account
         * </p>
         * 
         * @param accountGateResult
         *        The results of the account gate function AWS CloudFormation invokes, if present, before proceeding
         *        with stack set operations in an account
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountGateResult(AccountGateResult accountGateResult);

        /**
         * <p>
         * The results of the account gate function AWS CloudFormation invokes, if present, before proceeding with stack
         * set operations in an account
         * </p>
         * This is a convenience that creates an instance of the {@link AccountGateResult.Builder} avoiding the need to
         * create one manually via {@link AccountGateResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountGateResult.Builder#build()} is called immediately and its
         * result is passed to {@link #accountGateResult(AccountGateResult)}.
         * 
         * @param accountGateResult
         *        a consumer that will call methods on {@link AccountGateResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountGateResult(AccountGateResult)
         */
        default Builder accountGateResult(Consumer<AccountGateResult.Builder> accountGateResult) {
            return accountGateResult(AccountGateResult.builder().apply(accountGateResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String account;

        private String region;

        private String status;

        private String statusReason;

        private AccountGateResult accountGateResult;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationResultSummary model) {
            account(model.account);
            region(model.region);
            status(model.status);
            statusReason(model.statusReason);
            accountGateResult(model.accountGateResult);
        }

        public final String getAccount() {
            return account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationResultStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final AccountGateResult.Builder getAccountGateResult() {
            return accountGateResult != null ? accountGateResult.toBuilder() : null;
        }

        @Override
        public final Builder accountGateResult(AccountGateResult accountGateResult) {
            this.accountGateResult = accountGateResult;
            return this;
        }

        public final void setAccountGateResult(AccountGateResult.BuilderImpl accountGateResult) {
            this.accountGateResult = accountGateResult != null ? accountGateResult.build() : null;
        }

        @Override
        public StackSetOperationResultSummary build() {
            return new StackSetOperationResultSummary(this);
        }
    }
}
