/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StopStackSetOperationRequest extends CloudFormationRequest implements
        ToCopyableBuilder<StopStackSetOperationRequest.Builder, StopStackSetOperationRequest> {
    private final String stackSetName;

    private final String operationId;

    private StopStackSetOperationRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The name or unique ID of the stack set that you want to stop the operation for.
     * </p>
     * 
     * @return The name or unique ID of the stack set that you want to stop the operation for.
     */
    public String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * The ID of the stack operation.
     * </p>
     * 
     * @return The ID of the stack operation.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStackSetOperationRequest)) {
            return false;
        }
        StopStackSetOperationRequest other = (StopStackSetOperationRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(operationId(), other.operationId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackSetName() != null) {
            sb.append("StackSetName: ").append(stackSetName()).append(",");
        }
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.of(clazz.cast(stackSetName()));
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, StopStackSetOperationRequest> {
        /**
         * <p>
         * The name or unique ID of the stack set that you want to stop the operation for.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the stack set that you want to stop the operation for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The ID of the stack operation.
         * </p>
         * 
         * @param operationId
         *        The ID of the stack operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStackSetOperationRequest model) {
            stackSetName(model.stackSetName);
            operationId(model.operationId);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StopStackSetOperationRequest build() {
            return new StopStackSetOperationRequest(this);
        }
    }
}
