/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ChangeSetSummary StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ChangeSetSummaryUnmarshaller implements Unmarshaller<ChangeSetSummary, StaxUnmarshallerContext> {

    public ChangeSetSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        ChangeSetSummary.Builder changeSetSummary = ChangeSetSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("StackId", targetDepth)) {
                    changeSetSummary.stackId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StackName", targetDepth)) {
                    changeSetSummary.stackName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ChangeSetId", targetDepth)) {
                    changeSetSummary.changeSetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ChangeSetName", targetDepth)) {
                    changeSetSummary.changeSetName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ExecutionStatus", targetDepth)) {
                    changeSetSummary.executionStatus(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    changeSetSummary.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StatusReason", targetDepth)) {
                    changeSetSummary.statusReason(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CreationTime", targetDepth)) {
                    changeSetSummary.creationTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Description", targetDepth)) {
                    changeSetSummary.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return changeSetSummary.build();
    }

    private static final ChangeSetSummaryUnmarshaller INSTANCE = new ChangeSetSummaryUnmarshaller();

    public static ChangeSetSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
