/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DeleteStackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteStackRequestMarshaller implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {

    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {

        if (deleteStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteStackRequest> request = new DefaultRequest<DeleteStackRequest>(deleteStackRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (deleteStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(deleteStackRequest.stackName()));
        }

        java.util.List<String> retainResourcesList = deleteStackRequest.retainResources();

        if (retainResourcesList != null) {
            if (!retainResourcesList.isEmpty()) {
                int retainResourcesListIndex = 1;

                for (String retainResourcesListValue : retainResourcesList) {
                    if (retainResourcesListValue != null) {
                        request.addParameter("RetainResources.member." + retainResourcesListIndex,
                                StringUtils.fromString(retainResourcesListValue));
                    }
                    retainResourcesListIndex++;
                }
            } else {
                request.addParameter("RetainResources", "");
            }
        }

        if (deleteStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(deleteStackRequest.roleARN()));
        }

        if (deleteStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(deleteStackRequest.clientRequestToken()));
        }

        return request;
    }

}
