/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListChangeSetsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListChangeSetsRequestMarshaller implements Marshaller<Request<ListChangeSetsRequest>, ListChangeSetsRequest> {

    public Request<ListChangeSetsRequest> marshall(ListChangeSetsRequest listChangeSetsRequest) {

        if (listChangeSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListChangeSetsRequest> request = new DefaultRequest<ListChangeSetsRequest>(listChangeSetsRequest,
                "CloudFormationClient");
        request.addParameter("Action", "ListChangeSets");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (listChangeSetsRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(listChangeSetsRequest.stackName()));
        }

        if (listChangeSetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listChangeSetsRequest.nextToken()));
        }

        return request;
    }

}
