/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStackInstancesResponse extends CloudFormationResponse implements
        ToCopyableBuilder<CreateStackInstancesResponse.Builder, CreateStackInstancesResponse> {
    private final String operationId;

    private CreateStackInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The unique identifier for this stack set operation.
     * </p>
     * 
     * @return The unique identifier for this stack set operation.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackInstancesResponse)) {
            return false;
        }
        CreateStackInstancesResponse other = (CreateStackInstancesResponse) obj;
        return Objects.equals(operationId(), other.operationId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStackInstancesResponse").add("OperationId", operationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, CreateStackInstancesResponse> {
        /**
         * <p>
         * The unique identifier for this stack set operation.
         * </p>
         * 
         * @param operationId
         *        The unique identifier for this stack set operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackInstancesResponse model) {
            operationId(model.operationId);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public CreateStackInstancesResponse build() {
            return new CreateStackInstancesResponse(this);
        }
    }
}
