/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStackInstanceRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeStackInstanceRequest.Builder, DescribeStackInstanceRequest> {
    private final String stackSetName;

    private final String stackInstanceAccount;

    private final String stackInstanceRegion;

    private DescribeStackInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.stackInstanceAccount = builder.stackInstanceAccount;
        this.stackInstanceRegion = builder.stackInstanceRegion;
    }

    /**
     * <p>
     * The name or the unique stack ID of the stack set that you want to get stack instance information for.
     * </p>
     * 
     * @return The name or the unique stack ID of the stack set that you want to get stack instance information for.
     */
    public String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * The ID of an AWS account that's associated with this stack instance.
     * </p>
     * 
     * @return The ID of an AWS account that's associated with this stack instance.
     */
    public String stackInstanceAccount() {
        return stackInstanceAccount;
    }

    /**
     * <p>
     * The name of a region that's associated with this stack instance.
     * </p>
     * 
     * @return The name of a region that's associated with this stack instance.
     */
    public String stackInstanceRegion() {
        return stackInstanceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackInstanceRequest)) {
            return false;
        }
        DescribeStackInstanceRequest other = (DescribeStackInstanceRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName())
                && Objects.equals(stackInstanceAccount(), other.stackInstanceAccount())
                && Objects.equals(stackInstanceRegion(), other.stackInstanceRegion());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStackInstanceRequest").add("StackSetName", stackSetName())
                .add("StackInstanceAccount", stackInstanceAccount()).add("StackInstanceRegion", stackInstanceRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.of(clazz.cast(stackSetName()));
        case "StackInstanceAccount":
            return Optional.of(clazz.cast(stackInstanceAccount()));
        case "StackInstanceRegion":
            return Optional.of(clazz.cast(stackInstanceRegion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, DescribeStackInstanceRequest> {
        /**
         * <p>
         * The name or the unique stack ID of the stack set that you want to get stack instance information for.
         * </p>
         * 
         * @param stackSetName
         *        The name or the unique stack ID of the stack set that you want to get stack instance information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The ID of an AWS account that's associated with this stack instance.
         * </p>
         * 
         * @param stackInstanceAccount
         *        The ID of an AWS account that's associated with this stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceAccount(String stackInstanceAccount);

        /**
         * <p>
         * The name of a region that's associated with this stack instance.
         * </p>
         * 
         * @param stackInstanceRegion
         *        The name of a region that's associated with this stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceRegion(String stackInstanceRegion);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String stackInstanceAccount;

        private String stackInstanceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackInstanceRequest model) {
            stackSetName(model.stackSetName);
            stackInstanceAccount(model.stackInstanceAccount);
            stackInstanceRegion(model.stackInstanceRegion);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getStackInstanceAccount() {
            return stackInstanceAccount;
        }

        @Override
        public final Builder stackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
            return this;
        }

        public final void setStackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
        }

        public final String getStackInstanceRegion() {
            return stackInstanceRegion;
        }

        @Override
        public final Builder stackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
            return this;
        }

        public final void setStackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeStackInstanceRequest build() {
            return new DescribeStackInstanceRequest(this);
        }
    }
}
