/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>DescribeStacks</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStacksResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStacksResponse.Builder, DescribeStacksResponse> {
    private final List<Stack> stacks;

    private final String nextToken;

    private DescribeStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stacks = builder.stacks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of stack structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of stack structures.
     */
    public List<Stack> stacks() {
        return stacks;
    }

    /**
     * <p>
     * If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page
     * exists, this value is null.
     * </p>
     * 
     * @return If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional
     *         page exists, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stacks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse) obj;
        return Objects.equals(stacks(), other.stacks()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeStacksResponse").add("Stacks", stacks()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stacks":
            return Optional.of(clazz.cast(stacks()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, DescribeStacksResponse> {
        /**
         * <p>
         * A list of stack structures.
         * </p>
         * 
         * @param stacks
         *        A list of stack structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Collection<Stack> stacks);

        /**
         * <p>
         * A list of stack structures.
         * </p>
         * 
         * @param stacks
         *        A list of stack structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Stack... stacks);

        /**
         * <p>
         * If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional page
         * exists, this value is null.
         * </p>
         * 
         * @param nextToken
         *        If the output exceeds 1 MB in size, a string that identifies the next page of stacks. If no additional
         *        page exists, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<Stack> stacks;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            stacks(model.stacks);
            nextToken(model.nextToken);
        }

        public final Collection<Stack.Builder> getStacks() {
            return stacks != null ? stacks.stream().map(Stack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
            return this;
        }

        public final void setStacks(Collection<Stack.BuilderImpl> stacks) {
            this.stacks = StacksCopier.copyFromBuilder(stacks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }
    }
}
