/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for a <a>GetTemplate</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTemplateRequest extends CloudFormationRequest implements
        ToCopyableBuilder<GetTemplateRequest.Builder, GetTemplateRequest> {
    private final String stackName;

    private final String changeSetName;

    private final String templateStage;

    private GetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.changeSetName = builder.changeSetName;
        this.templateStage = builder.templateStage;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running stacks: You can specify either the stack's name or its unique stack ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deleted stacks: You must specify the unique stack ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack, which are not always
     *         interchangeable:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running stacks: You can specify either the stack's name or its unique stack ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deleted stacks: You must specify the unique stack ID.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: There is no default value.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the associated
     * template. If you specify a name, you must also specify the <code>StackName</code>.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the
     *         associated template. If you specify a name, you must also specify the <code>StackName</code>.
     */
    public String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
     * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
     * processed all transforms, specify <code>Processed</code>.
     * </p>
     * <p>
     * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
     * template. By default, AWS CloudFormation specifies <code>Original</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateStage}
     * will return {@link TemplateStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateStageString}.
     * </p>
     * 
     * @return For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get
     *         the user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation
     *         has processed all transforms, specify <code>Processed</code>. </p>
     *         <p>
     *         If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the
     *         same template. By default, AWS CloudFormation specifies <code>Original</code>.
     * @see TemplateStage
     */
    public TemplateStage templateStage() {
        return TemplateStage.fromValue(templateStage);
    }

    /**
     * <p>
     * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
     * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
     * processed all transforms, specify <code>Processed</code>.
     * </p>
     * <p>
     * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
     * template. By default, AWS CloudFormation specifies <code>Original</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateStage}
     * will return {@link TemplateStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateStageString}.
     * </p>
     * 
     * @return For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get
     *         the user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation
     *         has processed all transforms, specify <code>Processed</code>. </p>
     *         <p>
     *         If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the
     *         same template. By default, AWS CloudFormation specifies <code>Original</code>.
     * @see TemplateStage
     */
    public String templateStageString() {
        return templateStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(templateStageString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateRequest)) {
            return false;
        }
        GetTemplateRequest other = (GetTemplateRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(changeSetName(), other.changeSetName())
                && Objects.equals(templateStageString(), other.templateStageString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetTemplateRequest").add("StackName", stackName()).add("ChangeSetName", changeSetName())
                .add("TemplateStage", templateStageString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "ChangeSetName":
            return Optional.of(clazz.cast(changeSetName()));
        case "TemplateStage":
            return Optional.of(clazz.cast(templateStageString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, GetTemplateRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running stacks: You can specify either the stack's name or its unique stack ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * Deleted stacks: You must specify the unique stack ID.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack, which are not always
         *        interchangeable:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running stacks: You can specify either the stack's name or its unique stack ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deleted stacks: You must specify the unique stack ID.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the associated
         * template. If you specify a name, you must also specify the <code>StackName</code>.
         * </p>
         * 
         * @param changeSetName
         *        The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation returns the
         *        associated template. If you specify a name, you must also specify the <code>StackName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
         * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
         * processed all transforms, specify <code>Processed</code>.
         * </p>
         * <p>
         * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
         * template. By default, AWS CloudFormation specifies <code>Original</code>.
         * </p>
         * 
         * @param templateStage
         *        For templates that include transforms, the stage of the template that AWS CloudFormation returns. To
         *        get the user-submitted template, specify <code>Original</code>. To get the template after AWS
         *        CloudFormation has processed all transforms, specify <code>Processed</code>. </p>
         *        <p>
         *        If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return
         *        the same template. By default, AWS CloudFormation specifies <code>Original</code>.
         * @see TemplateStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStage
         */
        Builder templateStage(String templateStage);

        /**
         * <p>
         * For templates that include transforms, the stage of the template that AWS CloudFormation returns. To get the
         * user-submitted template, specify <code>Original</code>. To get the template after AWS CloudFormation has
         * processed all transforms, specify <code>Processed</code>.
         * </p>
         * <p>
         * If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return the same
         * template. By default, AWS CloudFormation specifies <code>Original</code>.
         * </p>
         * 
         * @param templateStage
         *        For templates that include transforms, the stage of the template that AWS CloudFormation returns. To
         *        get the user-submitted template, specify <code>Original</code>. To get the template after AWS
         *        CloudFormation has processed all transforms, specify <code>Processed</code>. </p>
         *        <p>
         *        If the template doesn't include transforms, <code>Original</code> and <code>Processed</code> return
         *        the same template. By default, AWS CloudFormation specifies <code>Original</code>.
         * @see TemplateStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateStage
         */
        Builder templateStage(TemplateStage templateStage);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String changeSetName;

        private String templateStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateRequest model) {
            stackName(model.stackName);
            changeSetName(model.changeSetName);
            templateStage(model.templateStage);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getTemplateStage() {
            return templateStage;
        }

        @Override
        public final Builder templateStage(String templateStage) {
            this.templateStage = templateStage;
            return this;
        }

        @Override
        public final Builder templateStage(TemplateStage templateStage) {
            this.templateStage(templateStage.toString());
            return this;
        }

        public final void setTemplateStage(String templateStage) {
            this.templateStage = templateStage;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }
    }
}
