/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ParameterDeclaration data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ParameterDeclaration implements ToCopyableBuilder<ParameterDeclaration.Builder, ParameterDeclaration> {
    private final String parameterKey;

    private final String defaultValue;

    private final String parameterType;

    private final Boolean noEcho;

    private final String description;

    private final ParameterConstraints parameterConstraints;

    private ParameterDeclaration(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.parameterType = builder.parameterType;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
        this.parameterConstraints = builder.parameterConstraints;
    }

    /**
     * <p>
     * The name that is associated with the parameter.
     * </p>
     * 
     * @return The name that is associated with the parameter.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The default value of the parameter.
     * </p>
     * 
     * @return The default value of the parameter.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * The type of parameter.
     * </p>
     * 
     * @return The type of parameter.
     */
    public String parameterType() {
        return parameterType;
    }

    /**
     * <p>
     * Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management Console.
     * </p>
     * 
     * @return Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management
     *         Console.
     */
    public Boolean noEcho() {
        return noEcho;
    }

    /**
     * <p>
     * The description that is associate with the parameter.
     * </p>
     * 
     * @return The description that is associate with the parameter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The criteria that AWS CloudFormation uses to validate parameter values.
     * </p>
     * 
     * @return The criteria that AWS CloudFormation uses to validate parameter values.
     */
    public ParameterConstraints parameterConstraints() {
        return parameterConstraints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(parameterType());
        hashCode = 31 * hashCode + Objects.hashCode(noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parameterConstraints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDeclaration)) {
            return false;
        }
        ParameterDeclaration other = (ParameterDeclaration) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(parameterType(), other.parameterType()) && Objects.equals(noEcho(), other.noEcho())
                && Objects.equals(description(), other.description())
                && Objects.equals(parameterConstraints(), other.parameterConstraints());
    }

    @Override
    public String toString() {
        return ToString.builder("ParameterDeclaration").add("ParameterKey", parameterKey()).add("DefaultValue", defaultValue())
                .add("ParameterType", parameterType()).add("NoEcho", noEcho()).add("Description", description())
                .add("ParameterConstraints", parameterConstraints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.of(clazz.cast(parameterKey()));
        case "DefaultValue":
            return Optional.of(clazz.cast(defaultValue()));
        case "ParameterType":
            return Optional.of(clazz.cast(parameterType()));
        case "NoEcho":
            return Optional.of(clazz.cast(noEcho()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ParameterConstraints":
            return Optional.of(clazz.cast(parameterConstraints()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ParameterDeclaration> {
        /**
         * <p>
         * The name that is associated with the parameter.
         * </p>
         * 
         * @param parameterKey
         *        The name that is associated with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The default value of the parameter.
         * </p>
         * 
         * @param defaultValue
         *        The default value of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * The type of parameter.
         * </p>
         * 
         * @param parameterType
         *        The type of parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterType(String parameterType);

        /**
         * <p>
         * Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS Management
         * Console.
         * </p>
         * 
         * @param noEcho
         *        Flag that indicates whether the parameter value is shown as plain text in logs and in the AWS
         *        Management Console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noEcho(Boolean noEcho);

        /**
         * <p>
         * The description that is associate with the parameter.
         * </p>
         * 
         * @param description
         *        The description that is associate with the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The criteria that AWS CloudFormation uses to validate parameter values.
         * </p>
         * 
         * @param parameterConstraints
         *        The criteria that AWS CloudFormation uses to validate parameter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterConstraints(ParameterConstraints parameterConstraints);

        /**
         * <p>
         * The criteria that AWS CloudFormation uses to validate parameter values.
         * </p>
         * This is a convenience that creates an instance of the {@link ParameterConstraints.Builder} avoiding the need
         * to create one manually via {@link ParameterConstraints#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParameterConstraints.Builder#build()} is called immediately and
         * its result is passed to {@link #parameterConstraints(ParameterConstraints)}.
         * 
         * @param parameterConstraints
         *        a consumer that will call methods on {@link ParameterConstraints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterConstraints(ParameterConstraints)
         */
        default Builder parameterConstraints(Consumer<ParameterConstraints.Builder> parameterConstraints) {
            return parameterConstraints(ParameterConstraints.builder().apply(parameterConstraints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String defaultValue;

        private String parameterType;

        private Boolean noEcho;

        private String description;

        private ParameterConstraints parameterConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDeclaration model) {
            parameterKey(model.parameterKey);
            defaultValue(model.defaultValue);
            parameterType(model.parameterType);
            noEcho(model.noEcho);
            description(model.description);
            parameterConstraints(model.parameterConstraints);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getParameterType() {
            return parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public final Boolean getNoEcho() {
            return noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ParameterConstraints.Builder getParameterConstraints() {
            return parameterConstraints != null ? parameterConstraints.toBuilder() : null;
        }

        @Override
        public final Builder parameterConstraints(ParameterConstraints parameterConstraints) {
            this.parameterConstraints = parameterConstraints;
            return this;
        }

        public final void setParameterConstraints(ParameterConstraints.BuilderImpl parameterConstraints) {
            this.parameterConstraints = parameterConstraints != null ? parameterConstraints.build() : null;
        }

        @Override
        public ParameterDeclaration build() {
            return new ParameterDeclaration(this);
        }
    }
}
