/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains summary information about a stack instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StackInstanceSummary implements ToCopyableBuilder<StackInstanceSummary.Builder, StackInstanceSummary> {
    private final String stackSetId;

    private final String region;

    private final String account;

    private final String stackId;

    private final String status;

    private final String statusReason;

    private StackInstanceSummary(BuilderImpl builder) {
        this.stackSetId = builder.stackSetId;
        this.region = builder.region;
        this.account = builder.account;
        this.stackId = builder.stackId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The name or unique ID of the stack set that the stack instance is associated with.
     * </p>
     * 
     * @return The name or unique ID of the stack set that the stack instance is associated with.
     */
    public String stackSetId() {
        return stackSetId;
    }

    /**
     * <p>
     * The name of the AWS region that the stack instance is associated with.
     * </p>
     * 
     * @return The name of the AWS region that the stack instance is associated with.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The name of the AWS account that the stack instance is associated with.
     * </p>
     * 
     * @return The name of the AWS account that the stack instance is associated with.
     */
    public String account() {
        return account;
    }

    /**
     * <p>
     * The ID of the stack instance.
     * </p>
     * 
     * @return The ID of the stack instance.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The status of the stack instance, in terms of its synchronization with its associated stack set.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
     * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might
     * need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
     * <code>true</code>, to delete the stack instance, and then delete the stack manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was
     * stopped before the stack was created or updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CURRENT</code>: The stack is currently up to date with the stack set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in
     *         an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations.
     *         You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code>
     *         set to <code>true</code>, to delete the stack instance, and then delete the stack manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed
     *         or was stopped before the stack was created or updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CURRENT</code>: The stack is currently up to date with the stack set.
     *         </p>
     *         </li>
     * @see StackInstanceStatus
     */
    public StackInstanceStatus status() {
        return StackInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the stack instance, in terms of its synchronization with its associated stack set.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
     * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You might
     * need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
     * <code>true</code>, to delete the stack instance, and then delete the stack manually.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or was
     * stopped before the stack was created or updated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>CURRENT</code>: The stack is currently up to date with the stack set.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StackInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in
     *         an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations.
     *         You might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code>
     *         set to <code>true</code>, to delete the stack instance, and then delete the stack manually.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
     *         operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed
     *         or was stopped before the stack was created or updated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CURRENT</code>: The stack is currently up to date with the stack set.
     *         </p>
     *         </li>
     * @see StackInstanceStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The explanation for the specific status code assigned to this stack instance.
     * </p>
     * 
     * @return The explanation for the specific status code assigned to this stack instance.
     */
    public String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstanceSummary)) {
            return false;
        }
        StackInstanceSummary other = (StackInstanceSummary) obj;
        return Objects.equals(stackSetId(), other.stackSetId()) && Objects.equals(region(), other.region())
                && Objects.equals(account(), other.account()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(statusString(), other.statusString()) && Objects.equals(statusReason(), other.statusReason());
    }

    @Override
    public String toString() {
        return ToString.builder("StackInstanceSummary").add("StackSetId", stackSetId()).add("Region", region())
                .add("Account", account()).add("StackId", stackId()).add("Status", statusString())
                .add("StatusReason", statusReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetId":
            return Optional.of(clazz.cast(stackSetId()));
        case "Region":
            return Optional.of(clazz.cast(region()));
        case "Account":
            return Optional.of(clazz.cast(account()));
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "StatusReason":
            return Optional.of(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StackInstanceSummary> {
        /**
         * <p>
         * The name or unique ID of the stack set that the stack instance is associated with.
         * </p>
         * 
         * @param stackSetId
         *        The name or unique ID of the stack set that the stack instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetId(String stackSetId);

        /**
         * <p>
         * The name of the AWS region that the stack instance is associated with.
         * </p>
         * 
         * @param region
         *        The name of the AWS region that the stack instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The name of the AWS account that the stack instance is associated with.
         * </p>
         * 
         * @param account
         *        The name of the AWS account that the stack instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The ID of the stack instance.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The status of the stack instance, in terms of its synchronization with its associated stack set.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
         * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You
         * might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
         * <code>true</code>, to delete the stack instance, and then delete the stack manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or
         * was stopped before the stack was created or updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CURRENT</code>: The stack is currently up to date with the stack set.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack
         *        in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code>
         *        operations. You might need to perform a <code>DeleteStackInstances</code> operation, with
         *        <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the
         *        stack manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that
         *        failed or was stopped before the stack was created or updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CURRENT</code>: The stack is currently up to date with the stack set.
         *        </p>
         *        </li>
         * @see StackInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the stack instance, in terms of its synchronization with its associated stack set.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack in an
         * unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code> operations. You
         * might need to perform a <code>DeleteStackInstances</code> operation, with <code>RetainStacks</code> set to
         * <code>true</code>, to delete the stack instance, and then delete the stack manually.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that failed or
         * was stopped before the stack was created or updated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>CURRENT</code>: The stack is currently up to date with the stack set.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the stack instance, in terms of its synchronization with its associated stack set.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INOPERABLE</code>: A <code>DeleteStackInstances</code> operation has failed and left the stack
         *        in an unstable state. Stacks in this state are excluded from further <code>UpdateStackSet</code>
         *        operations. You might need to perform a <code>DeleteStackInstances</code> operation, with
         *        <code>RetainStacks</code> set to <code>true</code>, to delete the stack instance, and then delete the
         *        stack manually.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTDATED</code>: The stack isn't currently up to date with the stack set because:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The associated stack failed during a <code>CreateStackSet</code> or <code>UpdateStackSet</code>
         *        operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The stack was part of a <code>CreateStackSet</code> or <code>UpdateStackSet</code> operation that
         *        failed or was stopped before the stack was created or updated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CURRENT</code>: The stack is currently up to date with the stack set.
         *        </p>
         *        </li>
         * @see StackInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackInstanceStatus
         */
        Builder status(StackInstanceStatus status);

        /**
         * <p>
         * The explanation for the specific status code assigned to this stack instance.
         * </p>
         * 
         * @param statusReason
         *        The explanation for the specific status code assigned to this stack instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String stackSetId;

        private String region;

        private String account;

        private String stackId;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstanceSummary model) {
            stackSetId(model.stackSetId);
            region(model.region);
            account(model.account);
            stackId(model.stackId);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getStackSetId() {
            return stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAccount() {
            return account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackInstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public StackInstanceSummary build() {
            return new StackInstanceSummary(this);
        }
    }
}
