/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeStackInstanceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeStackInstanceRequestMarshaller implements
        Marshaller<Request<DescribeStackInstanceRequest>, DescribeStackInstanceRequest> {

    public Request<DescribeStackInstanceRequest> marshall(DescribeStackInstanceRequest describeStackInstanceRequest) {

        if (describeStackInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeStackInstanceRequest> request = new DefaultRequest<DescribeStackInstanceRequest>(
                describeStackInstanceRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeStackInstance");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeStackInstanceRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(describeStackInstanceRequest.stackSetName()));
        }

        if (describeStackInstanceRequest.stackInstanceAccount() != null) {
            request.addParameter("StackInstanceAccount",
                    StringUtils.fromString(describeStackInstanceRequest.stackInstanceAccount()));
        }

        if (describeStackInstanceRequest.stackInstanceRegion() != null) {
            request.addParameter("StackInstanceRegion",
                    StringUtils.fromString(describeStackInstanceRequest.stackInstanceRegion()));
        }

        return request;
    }

}
