/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListStackSetsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListStackSetsRequestMarshaller implements Marshaller<Request<ListStackSetsRequest>, ListStackSetsRequest> {

    public Request<ListStackSetsRequest> marshall(ListStackSetsRequest listStackSetsRequest) {

        if (listStackSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListStackSetsRequest> request = new DefaultRequest<ListStackSetsRequest>(listStackSetsRequest,
                "CloudFormationClient");
        request.addParameter("Action", "ListStackSets");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (listStackSetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listStackSetsRequest.nextToken()));
        }

        if (listStackSetsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(listStackSetsRequest.maxResults()));
        }

        if (listStackSetsRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString(listStackSetsRequest.statusString()));
        }

        return request;
    }

}
