/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.Export;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;

public final class ListExportsPaginator
implements SdkIterable<ListExportsResponse> {
    private final CloudFormationClient client;
    private final ListExportsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListExportsPaginator(CloudFormationClient client, ListExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public Iterator<ListExportsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Export> exports() {
        Function<ListExportsResponse, Iterator> getIterator = response -> response != null ? response.exports().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListExportsResponseFetcher
    implements NextPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListExportsResponse nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsPaginator.this.client.listExports(ListExportsPaginator.this.firstRequest);
            }
            return ListExportsPaginator.this.client.listExports((ListExportsRequest)((Object)ListExportsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

