/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>CancelUpdateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelUpdateStackRequest extends CloudFormationRequest implements
        ToCopyableBuilder<CancelUpdateStackRequest.Builder, CancelUpdateStackRequest> {
    private final String stackName;

    private final String clientRequestToken;

    private CancelUpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * A unique identifier for this <code>CancelUpdateStack</code> request. Specify this token if you plan to retry
     * requests so that AWS CloudFormation knows that you're not attempting to cancel an update on a stack with the same
     * name. You might retry <code>CancelUpdateStack</code> requests to ensure that AWS CloudFormation successfully
     * received them.
     * </p>
     * 
     * @return A unique identifier for this <code>CancelUpdateStack</code> request. Specify this token if you plan to
     *         retry requests so that AWS CloudFormation knows that you're not attempting to cancel an update on a stack
     *         with the same name. You might retry <code>CancelUpdateStack</code> requests to ensure that AWS
     *         CloudFormation successfully received them.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelUpdateStackRequest)) {
            return false;
        }
        CancelUpdateStackRequest other = (CancelUpdateStackRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CancelUpdateStackRequest").add("StackName", stackName())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, CancelUpdateStackRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * A unique identifier for this <code>CancelUpdateStack</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to cancel an update on a stack with the
         * same name. You might retry <code>CancelUpdateStack</code> requests to ensure that AWS CloudFormation
         * successfully received them.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>CancelUpdateStack</code> request. Specify this token if you plan to
         *        retry requests so that AWS CloudFormation knows that you're not attempting to cancel an update on a
         *        stack with the same name. You might retry <code>CancelUpdateStack</code> requests to ensure that AWS
         *        CloudFormation successfully received them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelUpdateStackRequest model) {
            stackName(model.stackName);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelUpdateStackRequest build() {
            return new CancelUpdateStackRequest(this);
        }
    }
}
