/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStackSetsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackSetsResponse.Builder, ListStackSetsResponse> {
    private final List<StackSetSummary> summaries;

    private final String nextToken;

    private ListStackSetsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>StackSetSummary</code> structures that contain information about the user's stack sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>StackSetSummary</code> structures that contain information about the user's stack sets.
     */
    public List<StackSetSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call <code>ListStackInstances</code> again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the
     *         request object's <code>NextToken</code> parameter. If the request returns all results,
     *         <code>NextToken</code> is set to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetsResponse)) {
            return false;
        }
        ListStackSetsResponse other = (ListStackSetsResponse) obj;
        return Objects.equals(summaries(), other.summaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListStackSetsResponse").add("Summaries", summaries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summaries":
            return Optional.of(clazz.cast(summaries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationResponse.Builder, CopyableBuilder<Builder, ListStackSetsResponse> {
        /**
         * <p>
         * A list of <code>StackSetSummary</code> structures that contain information about the user's stack sets.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetSummary</code> structures that contain information about the user's stack
         *        sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<StackSetSummary> summaries);

        /**
         * <p>
         * A list of <code>StackSetSummary</code> structures that contain information about the user's stack sets.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetSummary</code> structures that contain information about the user's stack
         *        sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(StackSetSummary... summaries);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token to the
         * request object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code>
         * is set to <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call <code>ListStackInstances</code> again and assign that token
         *        to the request object's <code>NextToken</code> parameter. If the request returns all results,
         *        <code>NextToken</code> is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackSetSummary> summaries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetsResponse model) {
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final Collection<StackSetSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(StackSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetSummary> summaries) {
            this.summaries = StackSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        public final void setSummaries(Collection<StackSetSummary.BuilderImpl> summaries) {
            this.summaries = StackSetSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackSetsResponse build() {
            return new ListStackSetsResponse(this);
        }
    }
}
