/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>SignalResource</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SignalResourceRequest extends CloudFormationRequest implements
        ToCopyableBuilder<SignalResourceRequest.Builder, SignalResourceRequest> {
    private final String stackName;

    private final String logicalResourceId;

    private final String uniqueId;

    private final String status;

    private SignalResourceRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.uniqueId = builder.uniqueId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The stack name or unique stack ID that includes the resource that you want to signal.
     * </p>
     * 
     * @return The stack name or unique stack ID that includes the resource that you want to signal.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given in
     * the template.
     * </p>
     * 
     * @return The logical ID of the resource that you want to signal. The logical ID is the name of the resource that
     *         given in the template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID
     * that you are signaling as the unique ID. If you send multiple signals to a single resource (such as signaling a
     * wait condition), each signal requires a different unique ID.
     * </p>
     * 
     * @return A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the
     *         instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource
     *         (such as signaling a wait condition), each signal requires a different unique ID.
     */
    public String uniqueId() {
        return uniqueId;
    }

    /**
     * <p>
     * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
     * immediately fail the stack creation or update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSignalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation
     *         to immediately fail the stack creation or update.
     * @see ResourceSignalStatus
     */
    public ResourceSignalStatus status() {
        return ResourceSignalStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
     * immediately fail the stack creation or update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSignalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation
     *         to immediately fail the stack creation or update.
     * @see ResourceSignalStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalResourceRequest)) {
            return false;
        }
        SignalResourceRequest other = (SignalResourceRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(uniqueId(), other.uniqueId()) && Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        return ToString.builder("SignalResourceRequest").add("StackName", stackName())
                .add("LogicalResourceId", logicalResourceId()).add("UniqueId", uniqueId()).add("Status", statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        case "LogicalResourceId":
            return Optional.of(clazz.cast(logicalResourceId()));
        case "UniqueId":
            return Optional.of(clazz.cast(uniqueId()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, SignalResourceRequest> {
        /**
         * <p>
         * The stack name or unique stack ID that includes the resource that you want to signal.
         * </p>
         * 
         * @param stackName
         *        The stack name or unique stack ID that includes the resource that you want to signal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given
         * in the template.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical ID of the resource that you want to signal. The logical ID is the name of the resource
         *        that given in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance
         * ID that you are signaling as the unique ID. If you send multiple signals to a single resource (such as
         * signaling a wait condition), each signal requires a different unique ID.
         * </p>
         * 
         * @param uniqueId
         *        A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the
         *        instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource
         *        (such as signaling a wait condition), each signal requires a different unique ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueId(String uniqueId);

        /**
         * <p>
         * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
         * immediately fail the stack creation or update.
         * </p>
         * 
         * @param status
         *        The status of the signal, which is either success or failure. A failure signal causes AWS
         *        CloudFormation to immediately fail the stack creation or update.
         * @see ResourceSignalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSignalStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the signal, which is either success or failure. A failure signal causes AWS CloudFormation to
         * immediately fail the stack creation or update.
         * </p>
         * 
         * @param status
         *        The status of the signal, which is either success or failure. A failure signal causes AWS
         *        CloudFormation to immediately fail the stack creation or update.
         * @see ResourceSignalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSignalStatus
         */
        Builder status(ResourceSignalStatus status);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String logicalResourceId;

        private String uniqueId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalResourceRequest model) {
            stackName(model.stackName);
            logicalResourceId(model.logicalResourceId);
            uniqueId(model.uniqueId);
            status(model.status);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getUniqueId() {
            return uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSignalStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SignalResourceRequest build() {
            return new SignalResourceRequest(this);
        }
    }
}
