/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTerminationProtectionRequest extends CloudFormationRequest implements
        ToCopyableBuilder<UpdateTerminationProtectionRequest.Builder, UpdateTerminationProtectionRequest> {
    private final Boolean enableTerminationProtection;

    private final String stackName;

    private UpdateTerminationProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * Whether to enable termination protection on the specified stack.
     * </p>
     * 
     * @return Whether to enable termination protection on the specified stack.
     */
    public Boolean enableTerminationProtection() {
        return enableTerminationProtection;
    }

    /**
     * <p>
     * The name or unique ID of the stack for which you want to set termination protection.
     * </p>
     * 
     * @return The name or unique ID of the stack for which you want to set termination protection.
     */
    public String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTerminationProtectionRequest)) {
            return false;
        }
        UpdateTerminationProtectionRequest other = (UpdateTerminationProtectionRequest) obj;
        return Objects.equals(enableTerminationProtection(), other.enableTerminationProtection())
                && Objects.equals(stackName(), other.stackName());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateTerminationProtectionRequest")
                .add("EnableTerminationProtection", enableTerminationProtection()).add("StackName", stackName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableTerminationProtection":
            return Optional.of(clazz.cast(enableTerminationProtection()));
        case "StackName":
            return Optional.of(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFormationRequest.Builder, CopyableBuilder<Builder, UpdateTerminationProtectionRequest> {
        /**
         * <p>
         * Whether to enable termination protection on the specified stack.
         * </p>
         * 
         * @param enableTerminationProtection
         *        Whether to enable termination protection on the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTerminationProtection(Boolean enableTerminationProtection);

        /**
         * <p>
         * The name or unique ID of the stack for which you want to set termination protection.
         * </p>
         * 
         * @param stackName
         *        The name or unique ID of the stack for which you want to set termination protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private Boolean enableTerminationProtection;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTerminationProtectionRequest model) {
            enableTerminationProtection(model.enableTerminationProtection);
            stackName(model.stackName);
        }

        public final Boolean getEnableTerminationProtection() {
            return enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateTerminationProtectionRequest build() {
            return new UpdateTerminationProtectionRequest(this);
        }
    }
}
