/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ContinueUpdateRollbackRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ContinueUpdateRollbackRequestMarshaller implements
        Marshaller<Request<ContinueUpdateRollbackRequest>, ContinueUpdateRollbackRequest> {

    public Request<ContinueUpdateRollbackRequest> marshall(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {

        if (continueUpdateRollbackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ContinueUpdateRollbackRequest> request = new DefaultRequest<ContinueUpdateRollbackRequest>(
                continueUpdateRollbackRequest, "CloudFormationClient");
        request.addParameter("Action", "ContinueUpdateRollback");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (continueUpdateRollbackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(continueUpdateRollbackRequest.stackName()));
        }

        if (continueUpdateRollbackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString(continueUpdateRollbackRequest.roleARN()));
        }

        java.util.List<String> resourcesToSkipList = continueUpdateRollbackRequest.resourcesToSkip();

        if (resourcesToSkipList != null) {
            if (!resourcesToSkipList.isEmpty()) {
                int resourcesToSkipListIndex = 1;

                for (String resourcesToSkipListValue : resourcesToSkipList) {
                    if (resourcesToSkipListValue != null) {
                        request.addParameter("ResourcesToSkip.member." + resourcesToSkipListIndex,
                                StringUtils.fromString(resourcesToSkipListValue));
                    }
                    resourcesToSkipListIndex++;
                }
            } else {
                request.addParameter("ResourcesToSkip", "");
            }
        }

        if (continueUpdateRollbackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(continueUpdateRollbackRequest.clientRequestToken()));
        }

        return request;
    }

}
