/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.IdempotentUtils;

/**
 * CreateStackInstancesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateStackInstancesRequestMarshaller implements
        Marshaller<Request<CreateStackInstancesRequest>, CreateStackInstancesRequest> {

    public Request<CreateStackInstancesRequest> marshall(CreateStackInstancesRequest createStackInstancesRequest) {

        if (createStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateStackInstancesRequest> request = new DefaultRequest<CreateStackInstancesRequest>(
                createStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(createStackInstancesRequest.stackSetName()));
        }

        java.util.List<String> accountsList = createStackInstancesRequest.accounts();

        if (accountsList != null) {
            if (!accountsList.isEmpty()) {
                int accountsListIndex = 1;

                for (String accountsListValue : accountsList) {
                    if (accountsListValue != null) {
                        request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString(accountsListValue));
                    }
                    accountsListIndex++;
                }
            } else {
                request.addParameter("Accounts", "");
            }
        }

        java.util.List<String> regionsList = createStackInstancesRequest.regions();

        if (regionsList != null) {
            if (!regionsList.isEmpty()) {
                int regionsListIndex = 1;

                for (String regionsListValue : regionsList) {
                    if (regionsListValue != null) {
                        request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString(regionsListValue));
                    }
                    regionsListIndex++;
                }
            } else {
                request.addParameter("Regions", "");
            }
        }

        StackSetOperationPreferences operationPreferences = createStackInstancesRequest.operationPreferences();
        if (operationPreferences != null) {

            java.util.List<String> regionOrderList = operationPreferences.regionOrder();

            if (regionOrderList != null) {
                if (!regionOrderList.isEmpty()) {
                    int regionOrderListIndex = 1;

                    for (String regionOrderListValue : regionOrderList) {
                        if (regionOrderListValue != null) {
                            request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex,
                                    StringUtils.fromString(regionOrderListValue));
                        }
                        regionOrderListIndex++;
                    }
                } else {
                    request.addParameter("OperationPreferences.RegionOrder", "");
                }
            }

            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount",
                        StringUtils.fromInteger(operationPreferences.failureToleranceCount()));
            }

            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage",
                        StringUtils.fromInteger(operationPreferences.failureTolerancePercentage()));
            }

            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount",
                        StringUtils.fromInteger(operationPreferences.maxConcurrentCount()));
            }

            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage",
                        StringUtils.fromInteger(operationPreferences.maxConcurrentPercentage()));
            }
        }

        request.addParameter("OperationId", IdempotentUtils.resolveString(createStackInstancesRequest.operationId()));

        return request;
    }

}
