/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * StackSetOperationPreferences StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StackSetOperationPreferencesUnmarshaller implements
        Unmarshaller<StackSetOperationPreferences, StaxUnmarshallerContext> {

    public StackSetOperationPreferences unmarshall(StaxUnmarshallerContext context) throws Exception {
        StackSetOperationPreferences.Builder stackSetOperationPreferences = StackSetOperationPreferences.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> regionOrder = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                stackSetOperationPreferences.regionOrder(regionOrder);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("RegionOrder", targetDepth)) {
                    regionOrder = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("RegionOrder/member", targetDepth)) {
                    regionOrder.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FailureToleranceCount", targetDepth)) {
                    stackSetOperationPreferences.failureToleranceCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FailureTolerancePercentage", targetDepth)) {
                    stackSetOperationPreferences
                            .failureTolerancePercentage(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxConcurrentCount", targetDepth)) {
                    stackSetOperationPreferences.maxConcurrentCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxConcurrentPercentage", targetDepth)) {
                    stackSetOperationPreferences.maxConcurrentPercentage(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    stackSetOperationPreferences.regionOrder(regionOrder);
                    break;
                }
            }
        }
        return stackSetOperationPreferences.build();
    }

    private static final StackSetOperationPreferencesUnmarshaller INSTANCE = new StackSetOperationPreferencesUnmarshaller();

    public static StackSetOperationPreferencesUnmarshaller getInstance() {
        return INSTANCE;
    }
}
