/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudformation.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * StackSet StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class StackSetUnmarshaller implements Unmarshaller<StackSet, StaxUnmarshallerContext> {

    public StackSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        StackSet.Builder stackSet = StackSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Parameter> parameters = null;
        java.util.List<String> capabilities = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                stackSet.parameters(parameters);
                stackSet.capabilities(capabilities);
                stackSet.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("StackSetName", targetDepth)) {
                    stackSet.stackSetName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StackSetId", targetDepth)) {
                    stackSet.stackSetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Description", targetDepth)) {
                    stackSet.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Status", targetDepth)) {
                    stackSet.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TemplateBody", targetDepth)) {
                    stackSet.templateBody(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Parameters", targetDepth)) {
                    parameters = new ArrayList<Parameter>();
                    continue;
                }

                if (context.testExpression("Parameters/member", targetDepth)) {
                    parameters.add(ParameterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Capabilities", targetDepth)) {
                    capabilities = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Capabilities/member", targetDepth)) {
                    capabilities.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Tags", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("Tags/member", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    stackSet.parameters(parameters);
                    stackSet.capabilities(capabilities);
                    stackSet.tags(tags);
                    break;
                }
            }
        }
        return stackSet.build();
    }

    private static final StackSetUnmarshaller INSTANCE = new StackSetUnmarshaller();

    public static StackSetUnmarshaller getInstance() {
        return INSTANCE;
    }
}
