/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.RollbackTriggersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RollbackConfiguration
implements ToCopyableBuilder<Builder, RollbackConfiguration> {
    private final List<RollbackTrigger> rollbackTriggers;
    private final Integer monitoringTimeInMinutes;

    private RollbackConfiguration(BuilderImpl builder) {
        this.rollbackTriggers = builder.rollbackTriggers;
        this.monitoringTimeInMinutes = builder.monitoringTimeInMinutes;
    }

    public List<RollbackTrigger> rollbackTriggers() {
        return this.rollbackTriggers;
    }

    public Integer monitoringTimeInMinutes() {
        return this.monitoringTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackTriggers());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringTimeInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackConfiguration)) {
            return false;
        }
        RollbackConfiguration other = (RollbackConfiguration)obj;
        return Objects.equals(this.rollbackTriggers(), other.rollbackTriggers()) && Objects.equals(this.monitoringTimeInMinutes(), other.monitoringTimeInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"RollbackConfiguration").add("RollbackTriggers", this.rollbackTriggers()).add("MonitoringTimeInMinutes", (Object)this.monitoringTimeInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RollbackTriggers": {
                return Optional.of(clazz.cast(this.rollbackTriggers()));
            }
            case "MonitoringTimeInMinutes": {
                return Optional.of(clazz.cast(this.monitoringTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<RollbackTrigger> rollbackTriggers;
        private Integer monitoringTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackConfiguration model) {
            this.rollbackTriggers(model.rollbackTriggers);
            this.monitoringTimeInMinutes(model.monitoringTimeInMinutes);
        }

        public final Collection<RollbackTrigger.Builder> getRollbackTriggers() {
            return this.rollbackTriggers != null ? (Collection)this.rollbackTriggers.stream().map(RollbackTrigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rollbackTriggers(Collection<RollbackTrigger> rollbackTriggers) {
            this.rollbackTriggers = RollbackTriggersCopier.copy(rollbackTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rollbackTriggers(RollbackTrigger ... rollbackTriggers) {
            this.rollbackTriggers(Arrays.asList(rollbackTriggers));
            return this;
        }

        public final void setRollbackTriggers(Collection<RollbackTrigger.BuilderImpl> rollbackTriggers) {
            this.rollbackTriggers = RollbackTriggersCopier.copyFromBuilder(rollbackTriggers);
        }

        public final Integer getMonitoringTimeInMinutes() {
            return this.monitoringTimeInMinutes;
        }

        @Override
        public final Builder monitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
            this.monitoringTimeInMinutes = monitoringTimeInMinutes;
            return this;
        }

        public final void setMonitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
            this.monitoringTimeInMinutes = monitoringTimeInMinutes;
        }

        public RollbackConfiguration build() {
            return new RollbackConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RollbackConfiguration> {
        public Builder rollbackTriggers(Collection<RollbackTrigger> var1);

        public Builder rollbackTriggers(RollbackTrigger ... var1);

        public Builder monitoringTimeInMinutes(Integer var1);
    }
}

