/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The StackSummary Data Type
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackSummary implements SdkPojo, Serializable, ToCopyableBuilder<StackSummary.Builder, StackSummary> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::templateDescription)).setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StackSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StackSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> DELETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StackSummary::deletionTime)).setter(setter(Builder::deletionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").build()).build();

    private static final SdkField<String> STACK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::stackStatusAsString)).setter(setter(Builder::stackStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatus").build()).build();

    private static final SdkField<String> STACK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::stackStatusReason)).setter(setter(Builder::stackStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusReason").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<String> ROOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StackSummary::rootId)).setter(setter(Builder::rootId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootId").build()).build();

    private static final SdkField<StackDriftInformationSummary> DRIFT_INFORMATION_FIELD = SdkField
            .<StackDriftInformationSummary> builder(MarshallingType.SDK_POJO).getter(getter(StackSummary::driftInformation))
            .setter(setter(Builder::driftInformation)).constructor(StackDriftInformationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            STACK_NAME_FIELD, TEMPLATE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, DELETION_TIME_FIELD,
            STACK_STATUS_FIELD, STACK_STATUS_REASON_FIELD, PARENT_ID_FIELD, ROOT_ID_FIELD, DRIFT_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackId;

    private final String stackName;

    private final String templateDescription;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final Instant deletionTime;

    private final String stackStatus;

    private final String stackStatusReason;

    private final String parentId;

    private final String rootId;

    private final StackDriftInformationSummary driftInformation;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.templateDescription = builder.templateDescription;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.parentId = builder.parentId;
        this.rootId = builder.rootId;
        this.driftInformation = builder.driftInformation;
    }

    /**
     * <p>
     * Unique stack identifier.
     * </p>
     * 
     * @return Unique stack identifier.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The template description of the template used to create the stack.
     * </p>
     * 
     * @return The template description of the template used to create the stack.
     */
    public String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The time the stack was created.
     * </p>
     * 
     * @return The time the stack was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time the stack was last updated. This field will only be returned if the stack has been updated at least
     * once.
     * </p>
     * 
     * @return The time the stack was last updated. This field will only be returned if the stack has been updated at
     *         least once.
     */
    public Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The time the stack was deleted.
     * </p>
     * 
     * @return The time the stack was deleted.
     */
    public Instant deletionTime() {
        return deletionTime;
    }

    /**
     * <p>
     * The current status of the stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stackStatus} will
     * return {@link StackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stackStatusAsString}.
     * </p>
     * 
     * @return The current status of the stack.
     * @see StackStatus
     */
    public StackStatus stackStatus() {
        return StackStatus.fromValue(stackStatus);
    }

    /**
     * <p>
     * The current status of the stack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stackStatus} will
     * return {@link StackStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stackStatusAsString}.
     * </p>
     * 
     * @return The current status of the stack.
     * @see StackStatus
     */
    public String stackStatusAsString() {
        return stackStatus;
    }

    /**
     * <p>
     * Success/Failure message associated with the stack status.
     * </p>
     * 
     * @return Success/Failure message associated with the stack status.
     */
    public String stackStatusReason() {
        return stackStatusReason;
    }

    /**
     * <p>
     * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this
     * stack. For the first level of nested stacks, the root stack is also the parent stack.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with
     * Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of
     *         this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working
     *         with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
     */
    public String parentId() {
        return parentId;
    }

    /**
     * <p>
     * For nested stacks--stacks created as resources for another stack--the stack ID of the the top-level stack to
     * which the nested stack ultimately belongs.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working with
     * Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * 
     * @return For nested stacks--stacks created as resources for another stack--the stack ID of the the top-level stack
     *         to which the nested stack ultimately belongs.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working
     *         with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
     */
    public String rootId() {
        return rootId;
    }

    /**
     * <p>
     * Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's
     * expected configuration, as defined in the stack template and any values specified as template parameters. For
     * more information, see <a href=
     * "http://docs.aws.amazon.com/http:/docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
     * >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * 
     * @return Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from
     *         it's expected configuration, as defined in the stack template and any values specified as template
     *         parameters. For more information, see <a href=
     *         "http://docs.aws.amazon.com/http:/docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
     *         >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
     */
    public StackDriftInformationSummary driftInformation() {
        return driftInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(rootId());
        hashCode = 31 * hashCode + Objects.hashCode(driftInformation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(deletionTime(), other.deletionTime())
                && Objects.equals(stackStatusAsString(), other.stackStatusAsString())
                && Objects.equals(stackStatusReason(), other.stackStatusReason()) && Objects.equals(parentId(), other.parentId())
                && Objects.equals(rootId(), other.rootId()) && Objects.equals(driftInformation(), other.driftInformation());
    }

    @Override
    public String toString() {
        return ToString.builder("StackSummary").add("StackId", stackId()).add("StackName", stackName())
                .add("TemplateDescription", templateDescription()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("DeletionTime", deletionTime())
                .add("StackStatus", stackStatusAsString()).add("StackStatusReason", stackStatusReason())
                .add("ParentId", parentId()).add("RootId", rootId()).add("DriftInformation", driftInformation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "DeletionTime":
            return Optional.ofNullable(clazz.cast(deletionTime()));
        case "StackStatus":
            return Optional.ofNullable(clazz.cast(stackStatusAsString()));
        case "StackStatusReason":
            return Optional.ofNullable(clazz.cast(stackStatusReason()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "RootId":
            return Optional.ofNullable(clazz.cast(rootId()));
        case "DriftInformation":
            return Optional.ofNullable(clazz.cast(driftInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSummary, T> g) {
        return obj -> g.apply((StackSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackSummary> {
        /**
         * <p>
         * Unique stack identifier.
         * </p>
         * 
         * @param stackId
         *        Unique stack identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The template description of the template used to create the stack.
         * </p>
         * 
         * @param templateDescription
         *        The template description of the template used to create the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The time the stack was created.
         * </p>
         * 
         * @param creationTime
         *        The time the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time the stack was last updated. This field will only be returned if the stack has been updated at least
         * once.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the stack was last updated. This field will only be returned if the stack has been updated at
         *        least once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The time the stack was deleted.
         * </p>
         * 
         * @param deletionTime
         *        The time the stack was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionTime(Instant deletionTime);

        /**
         * <p>
         * The current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        The current status of the stack.
         * @see StackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(String stackStatus);

        /**
         * <p>
         * The current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        The current status of the stack.
         * @see StackStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StackStatus
         */
        Builder stackStatus(StackStatus stackStatus);

        /**
         * <p>
         * Success/Failure message associated with the stack status.
         * </p>
         * 
         * @param stackStatusReason
         *        Success/Failure message associated with the stack status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusReason(String stackStatusReason);

        /**
         * <p>
         * For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of this
         * stack. For the first level of nested stacks, the root stack is also the parent stack.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working
         * with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
         * </p>
         * 
         * @param parentId
         *        For nested stacks--stacks created as resources for another stack--the stack ID of the direct parent of
         *        this stack. For the first level of nested stacks, the root stack is also the parent stack.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html"
         *        >Working with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * For nested stacks--stacks created as resources for another stack--the stack ID of the the top-level stack to
         * which the nested stack ultimately belongs.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Working
         * with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
         * </p>
         * 
         * @param rootId
         *        For nested stacks--stacks created as resources for another stack--the stack ID of the the top-level
         *        stack to which the nested stack ultimately belongs.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html"
         *        >Working with Nested Stacks</a> in the <i>AWS CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootId(String rootId);

        /**
         * <p>
         * Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's
         * expected configuration, as defined in the stack template and any values specified as template parameters. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/http:/docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
         * >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
         * </p>
         * 
         * @param driftInformation
         *        Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from
         *        it's expected configuration, as defined in the stack template and any values specified as template
         *        parameters. For more information, see <a href=
         *        "http://docs.aws.amazon.com/http:/docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
         *        >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftInformation(StackDriftInformationSummary driftInformation);

        /**
         * <p>
         * Summarizes information on whether a stack's actual configuration differs, or has <i>drifted</i>, from it's
         * expected configuration, as defined in the stack template and any values specified as template parameters. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/http:/docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html"
         * >Detecting Unregulated Configuration Changes to Stacks and Resources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link StackDriftInformationSummary.Builder} avoiding
         * the need to create one manually via {@link StackDriftInformationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackDriftInformationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #driftInformation(StackDriftInformationSummary)}.
         * 
         * @param driftInformation
         *        a consumer that will call methods on {@link StackDriftInformationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftInformation(StackDriftInformationSummary)
         */
        default Builder driftInformation(Consumer<StackDriftInformationSummary.Builder> driftInformation) {
            return driftInformation(StackDriftInformationSummary.builder().applyMutation(driftInformation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String stackName;

        private String templateDescription;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private Instant deletionTime;

        private String stackStatus;

        private String stackStatusReason;

        private String parentId;

        private String rootId;

        private StackDriftInformationSummary driftInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            stackId(model.stackId);
            stackName(model.stackName);
            templateDescription(model.templateDescription);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            deletionTime(model.deletionTime);
            stackStatus(model.stackStatus);
            stackStatusReason(model.stackStatusReason);
            parentId(model.parentId);
            rootId(model.rootId);
            driftInformation(model.driftInformation);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final Instant getDeletionTime() {
            return deletionTime;
        }

        @Override
        public final Builder deletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final void setDeletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
        }

        public final String getStackStatus() {
            return stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final String getStackStatusReason() {
            return stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public final String getParentId() {
            return parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getRootId() {
            return rootId;
        }

        @Override
        public final Builder rootId(String rootId) {
            this.rootId = rootId;
            return this;
        }

        public final void setRootId(String rootId) {
            this.rootId = rootId;
        }

        public final StackDriftInformationSummary.Builder getDriftInformation() {
            return driftInformation != null ? driftInformation.toBuilder() : null;
        }

        @Override
        public final Builder driftInformation(StackDriftInformationSummary driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final void setDriftInformation(StackDriftInformationSummary.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        @Override
        public StackSummary build() {
            return new StackSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
