/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypesResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListTypesResponse.Builder, ListTypesResponse> {
    private static final SdkField<List<TypeSummary>> TYPE_SUMMARIES_FIELD = SdkField
            .<List<TypeSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListTypesResponse::typeSummaries))
            .setter(setter(Builder::typeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TypeSummary> typeSummaries;

    private final String nextToken;

    private ListTypesResponse(BuilderImpl builder) {
        super(builder);
        this.typeSummaries = builder.typeSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of <code>TypeSummary</code> structures that contain information about the specified types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>TypeSummary</code> structures that contain information about the specified types.
     */
    public List<TypeSummary> typeSummaries() {
        return typeSummaries;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call this action again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call this action again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     *         <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResponse)) {
            return false;
        }
        ListTypesResponse other = (ListTypesResponse) obj;
        return Objects.equals(typeSummaries(), other.typeSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTypesResponse").add("TypeSummaries", typeSummaries()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeSummaries":
            return Optional.ofNullable(clazz.cast(typeSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypesResponse, T> g) {
        return obj -> g.apply((ListTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTypesResponse> {
        /**
         * <p>
         * A list of <code>TypeSummary</code> structures that contain information about the specified types.
         * </p>
         * 
         * @param typeSummaries
         *        A list of <code>TypeSummary</code> structures that contain information about the specified types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeSummaries(Collection<TypeSummary> typeSummaries);

        /**
         * <p>
         * A list of <code>TypeSummary</code> structures that contain information about the specified types.
         * </p>
         * 
         * @param typeSummaries
         *        A list of <code>TypeSummary</code> structures that contain information about the specified types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeSummaries(TypeSummary... typeSummaries);

        /**
         * <p>
         * A list of <code>TypeSummary</code> structures that contain information about the specified types.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypeSummary>.Builder} avoiding the need to
         * create one manually via {@link List<TypeSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypeSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #typeSummaries(List<TypeSummary>)}.
         * 
         * @param typeSummaries
         *        a consumer that will call methods on {@link List<TypeSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeSummaries(List<TypeSummary>)
         */
        Builder typeSummaries(Consumer<TypeSummary.Builder>... typeSummaries);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call this action again and assign that token to the request object's
         * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call this action again and assign that token to the request
         *        object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code>
         *        is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<TypeSummary> typeSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesResponse model) {
            super(model);
            typeSummaries(model.typeSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<TypeSummary.Builder> getTypeSummaries() {
            return typeSummaries != null ? typeSummaries.stream().map(TypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typeSummaries(Collection<TypeSummary> typeSummaries) {
            this.typeSummaries = TypeSummariesCopier.copy(typeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeSummaries(TypeSummary... typeSummaries) {
            typeSummaries(Arrays.asList(typeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeSummaries(Consumer<TypeSummary.Builder>... typeSummaries) {
            typeSummaries(Stream.of(typeSummaries).map(c -> TypeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTypeSummaries(Collection<TypeSummary.BuilderImpl> typeSummaries) {
            this.typeSummaries = TypeSummariesCopier.copyFromBuilder(typeSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypesResponse build() {
            return new ListTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
