/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTypeRegistrationResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeTypeRegistrationResponse.Builder, DescribeTypeRegistrationResponse> {
    private static final SdkField<String> PROGRESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRegistrationResponse::progressStatusAsString)).setter(setter(Builder::progressStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressStatus").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRegistrationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRegistrationResponse::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> TYPE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRegistrationResponse::typeVersionArn)).setter(setter(Builder::typeVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_STATUS_FIELD,
            DESCRIPTION_FIELD, TYPE_ARN_FIELD, TYPE_VERSION_ARN_FIELD));

    private final String progressStatus;

    private final String description;

    private final String typeArn;

    private final String typeVersionArn;

    private DescribeTypeRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.progressStatus = builder.progressStatus;
        this.description = builder.description;
        this.typeArn = builder.typeArn;
        this.typeVersionArn = builder.typeVersionArn;
    }

    /**
     * <p>
     * The current status of the type registration request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #progressStatus}
     * will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #progressStatusAsString}.
     * </p>
     * 
     * @return The current status of the type registration request.
     * @see RegistrationStatus
     */
    public RegistrationStatus progressStatus() {
        return RegistrationStatus.fromValue(progressStatus);
    }

    /**
     * <p>
     * The current status of the type registration request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #progressStatus}
     * will return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #progressStatusAsString}.
     * </p>
     * 
     * @return The current status of the type registration request.
     * @see RegistrationStatus
     */
    public String progressStatusAsString() {
        return progressStatus;
    }

    /**
     * <p>
     * The description of the type registration request.
     * </p>
     * 
     * @return The description of the type registration request.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the type being registered.
     * </p>
     * <p>
     * For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this will be
     * <code>null</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the type being registered.</p>
     *         <p>
     *         For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this
     *         will be <code>null</code>.
     */
    public String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this specific version of the type being registered.
     * </p>
     * <p>
     * For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this will be
     * <code>null</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this specific version of the type being registered.</p>
     *         <p>
     *         For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this
     *         will be <code>null</code>.
     */
    public String typeVersionArn() {
        return typeVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeRegistrationResponse)) {
            return false;
        }
        DescribeTypeRegistrationResponse other = (DescribeTypeRegistrationResponse) obj;
        return Objects.equals(progressStatusAsString(), other.progressStatusAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(typeArn(), other.typeArn())
                && Objects.equals(typeVersionArn(), other.typeVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTypeRegistrationResponse").add("ProgressStatus", progressStatusAsString())
                .add("Description", description()).add("TypeArn", typeArn()).add("TypeVersionArn", typeVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressStatus":
            return Optional.ofNullable(clazz.cast(progressStatusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "TypeVersionArn":
            return Optional.ofNullable(clazz.cast(typeVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeRegistrationResponse, T> g) {
        return obj -> g.apply((DescribeTypeRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTypeRegistrationResponse> {
        /**
         * <p>
         * The current status of the type registration request.
         * </p>
         * 
         * @param progressStatus
         *        The current status of the type registration request.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder progressStatus(String progressStatus);

        /**
         * <p>
         * The current status of the type registration request.
         * </p>
         * 
         * @param progressStatus
         *        The current status of the type registration request.
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder progressStatus(RegistrationStatus progressStatus);

        /**
         * <p>
         * The description of the type registration request.
         * </p>
         * 
         * @param description
         *        The description of the type registration request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the type being registered.
         * </p>
         * <p>
         * For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this will
         * be <code>null</code>.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) of the type being registered.</p>
         *        <p>
         *        For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this
         *        will be <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this specific version of the type being registered.
         * </p>
         * <p>
         * For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this will
         * be <code>null</code>.
         * </p>
         * 
         * @param typeVersionArn
         *        The Amazon Resource Name (ARN) of this specific version of the type being registered.</p>
         *        <p>
         *        For registration requests with a <code>ProgressStatus</code> of other than <code>COMPLETE</code>, this
         *        will be <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionArn(String typeVersionArn);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String progressStatus;

        private String description;

        private String typeArn;

        private String typeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeRegistrationResponse model) {
            super(model);
            progressStatus(model.progressStatus);
            description(model.description);
            typeArn(model.typeArn);
            typeVersionArn(model.typeVersionArn);
        }

        public final String getProgressStatusAsString() {
            return progressStatus;
        }

        @Override
        public final Builder progressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
            return this;
        }

        @Override
        public final Builder progressStatus(RegistrationStatus progressStatus) {
            this.progressStatus(progressStatus == null ? null : progressStatus.toString());
            return this;
        }

        public final void setProgressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        public final String getTypeVersionArn() {
            return typeVersionArn;
        }

        @Override
        public final Builder typeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
            return this;
        }

        public final void setTypeVersionArn(String typeVersionArn) {
            this.typeVersionArn = typeVersionArn;
        }

        @Override
        public DescribeTypeRegistrationResponse build() {
            return new DescribeTypeRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
