/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ResourceChange</code> structure describes the resource and the action that AWS CloudFormation will perform
 * on it if you execute this change set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceChange implements SdkPojo, Serializable, ToCopyableBuilder<ResourceChange.Builder, ResourceChange> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChange::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChange::logicalResourceId)).setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChange::physicalResourceId)).setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChange::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> REPLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChange::replacementAsString)).setter(setter(Builder::replacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replacement").build()).build();

    private static final SdkField<List<String>> SCOPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ResourceChange::scopeAsStrings))
            .setter(setter(Builder::scopeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceChangeDetail>> DETAILS_FIELD = SdkField
            .<List<ResourceChangeDetail>> builder(MarshallingType.LIST)
            .getter(getter(ResourceChange::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceChangeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceChangeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, REPLACEMENT_FIELD, SCOPE_FIELD,
            DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private final String resourceType;

    private final String replacement;

    private final List<String> scope;

    private final List<ResourceChangeDetail> details;

    private ResourceChange(BuilderImpl builder) {
        this.action = builder.action;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.replacement = builder.replacement;
        this.scope = builder.scope;
        this.details = builder.details;
    }

    /**
     * <p>
     * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     *         <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * @see ChangeAction
     */
    public ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
     *         <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
     * @see ChangeAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The resource's logical ID, which is defined in the stack's template.
     * </p>
     * 
     * @return The resource's logical ID, which is defined in the stack's template.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they
     * haven't been created.
     * </p>
     * 
     * @return The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because
     *         they haven't been created.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     * </p>
     * 
     * @return The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a
     * new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property
     * in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field
     * is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is
     * <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the
     * <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.
     * </p>
     * <p>
     * If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code>
     * value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code>
     * has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacement} will
     * return {@link Replacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replacementAsString}.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
     *         creating a new one and deleting the old one. This value depends on the value of the
     *         <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
     *         example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
     *         <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If
     *         the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
     *         <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
     *         <p>
     *         If you have multiple changes with different <code>RequiresRecreation</code> values, the
     *         <code>Replacement</code> value depends on the change with the most impact. A
     *         <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
     *         <code>Conditionally</code>, and then <code>Never</code>.
     * @see Replacement
     */
    public Replacement replacement() {
        return Replacement.fromValue(replacement);
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by creating a
     * new one and deleting the old one. This value depends on the value of the <code>RequiresRecreation</code> property
     * in the <code>ResourceTargetDefinition</code> structure. For example, if the <code>RequiresRecreation</code> field
     * is <code>Always</code> and the <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is
     * <code>True</code>. If the <code>RequiresRecreation</code> field is <code>Always</code> and the
     * <code>Evaluation</code> field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.
     * </p>
     * <p>
     * If you have multiple changes with different <code>RequiresRecreation</code> values, the <code>Replacement</code>
     * value depends on the change with the most impact. A <code>RequiresRecreation</code> value of <code>Always</code>
     * has the most impact, followed by <code>Conditionally</code>, and then <code>Never</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replacement} will
     * return {@link Replacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replacementAsString}.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
     *         creating a new one and deleting the old one. This value depends on the value of the
     *         <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
     *         example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
     *         <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>. If
     *         the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
     *         <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
     *         <p>
     *         If you have multiple changes with different <code>RequiresRecreation</code> values, the
     *         <code>Replacement</code> value depends on the change with the most impact. A
     *         <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
     *         <code>Conditionally</code>, and then <code>Never</code>.
     * @see Replacement
     */
    public String replacementAsString() {
        return replacement;
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
     * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScope()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as
     *         a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>
     *         .
     */
    public List<ResourceAttribute> scope() {
        return ScopeCopier.copyStringToEnum(scope);
    }

    /**
     * Returns true if the Scope property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasScope() {
        return scope != null && !(scope instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
     * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScope()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as
     *         a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>
     *         .
     */
    public List<String> scopeAsStrings() {
        return scope;
    }

    /**
     * Returns true if the Details property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
     * changes that AWS CloudFormation will make to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes
     *         the changes that AWS CloudFormation will make to the resource.
     */
    public List<ResourceChangeDetail> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(replacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChange)) {
            return false;
        }
        ResourceChange other = (ResourceChange) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(replacementAsString(), other.replacementAsString())
                && Objects.equals(scopeAsStrings(), other.scopeAsStrings()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceChange").add("Action", actionAsString()).add("LogicalResourceId", logicalResourceId())
                .add("PhysicalResourceId", physicalResourceId()).add("ResourceType", resourceType())
                .add("Replacement", replacementAsString()).add("Scope", scopeAsStrings()).add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Replacement":
            return Optional.ofNullable(clazz.cast(replacementAsString()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsStrings()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceChange, T> g) {
        return obj -> g.apply((ResourceChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceChange> {
        /**
         * <p>
         * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
         * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * </p>
         * 
         * @param action
         *        The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new
         *        resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new resource),
         * <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * </p>
         * 
         * @param action
         *        The action that AWS CloudFormation takes on the resource, such as <code>Add</code> (adds a new
         *        resource), <code>Modify</code> (changes a resource), or <code>Remove</code> (deletes a resource).
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The resource's logical ID, which is defined in the stack's template.
         * </p>
         * 
         * @param logicalResourceId
         *        The resource's logical ID, which is defined in the stack's template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because
         * they haven't been created.
         * </p>
         * 
         * @param physicalResourceId
         *        The resource's physical ID (resource name). Resources that you are adding don't have physical IDs
         *        because they haven't been created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        /**
         * <p>
         * The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS CloudFormation resource, such as <code>AWS::S3::Bucket</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         * creating a new one and deleting the old one. This value depends on the value of the
         * <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example,
         * if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
         * <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code>
         * field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>,
         * <code>Replacement</code> is <code>Conditionally</code>.
         * </p>
         * <p>
         * If you have multiple changes with different <code>RequiresRecreation</code> values, the
         * <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code>
         * value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then
         * <code>Never</code>.
         * </p>
         * 
         * @param replacement
         *        For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         *        creating a new one and deleting the old one. This value depends on the value of the
         *        <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
         *        example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
         *        <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>.
         *        If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code>
         *        field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
         *        <p>
         *        If you have multiple changes with different <code>RequiresRecreation</code> values, the
         *        <code>Replacement</code> value depends on the change with the most impact. A
         *        <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
         *        <code>Conditionally</code>, and then <code>Never</code>.
         * @see Replacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(String replacement);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         * creating a new one and deleting the old one. This value depends on the value of the
         * <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For example,
         * if the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code> field is
         * <code>Static</code>, <code>Replacement</code> is <code>True</code>. If the <code>RequiresRecreation</code>
         * field is <code>Always</code> and the <code>Evaluation</code> field is <code>Dynamic</code>,
         * <code>Replacement</code> is <code>Conditionally</code>.
         * </p>
         * <p>
         * If you have multiple changes with different <code>RequiresRecreation</code> values, the
         * <code>Replacement</code> value depends on the change with the most impact. A <code>RequiresRecreation</code>
         * value of <code>Always</code> has the most impact, followed by <code>Conditionally</code>, and then
         * <code>Never</code>.
         * </p>
         * 
         * @param replacement
         *        For the <code>Modify</code> action, indicates whether AWS CloudFormation will replace the resource by
         *        creating a new one and deleting the old one. This value depends on the value of the
         *        <code>RequiresRecreation</code> property in the <code>ResourceTargetDefinition</code> structure. For
         *        example, if the <code>RequiresRecreation</code> field is <code>Always</code> and the
         *        <code>Evaluation</code> field is <code>Static</code>, <code>Replacement</code> is <code>True</code>.
         *        If the <code>RequiresRecreation</code> field is <code>Always</code> and the <code>Evaluation</code>
         *        field is <code>Dynamic</code>, <code>Replacement</code> is <code>Conditionally</code>.</p>
         *        <p>
         *        If you have multiple changes with different <code>RequiresRecreation</code> values, the
         *        <code>Replacement</code> value depends on the change with the most impact. A
         *        <code>RequiresRecreation</code> value of <code>Always</code> has the most impact, followed by
         *        <code>Conditionally</code>, and then <code>Never</code>.
         * @see Replacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Replacement
         */
        Builder replacement(Replacement replacement);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeWithStrings(Collection<String> scope);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeWithStrings(String... scope);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Collection<ResourceAttribute> scope);

        /**
         * <p>
         * For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such as a
         * change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or <code>Tags</code>.
         * </p>
         * 
         * @param scope
         *        For the <code>Modify</code> action, indicates which resource attribute is triggering this update, such
         *        as a change in the resource attribute's <code>Metadata</code>, <code>Properties</code>, or
         *        <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(ResourceAttribute... scope);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * 
         * @param details
         *        For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that
         *        describes the changes that AWS CloudFormation will make to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<ResourceChangeDetail> details);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * 
         * @param details
         *        For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that
         *        describes the changes that AWS CloudFormation will make to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(ResourceChangeDetail... details);

        /**
         * <p>
         * For the <code>Modify</code> action, a list of <code>ResourceChangeDetail</code> structures that describes the
         * changes that AWS CloudFormation will make to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceChangeDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceChangeDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceChangeDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #details(List<ResourceChangeDetail>)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link List<ResourceChangeDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(List<ResourceChangeDetail>)
         */
        Builder details(Consumer<ResourceChangeDetail.Builder>... details);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String logicalResourceId;

        private String physicalResourceId;

        private String resourceType;

        private String replacement;

        private List<String> scope = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceChangeDetail> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChange model) {
            action(model.action);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceType(model.resourceType);
            replacement(model.replacement);
            scopeWithStrings(model.scope);
            details(model.details);
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getReplacementAsString() {
            return replacement;
        }

        @Override
        public final Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        @Override
        public final Builder replacement(Replacement replacement) {
            this.replacement(replacement == null ? null : replacement.toString());
            return this;
        }

        public final void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public final Collection<String> getScopeAsStrings() {
            return scope;
        }

        @Override
        public final Builder scopeWithStrings(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopeWithStrings(String... scope) {
            scopeWithStrings(Arrays.asList(scope));
            return this;
        }

        @Override
        public final Builder scope(Collection<ResourceAttribute> scope) {
            this.scope = ScopeCopier.copyEnumToString(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(ResourceAttribute... scope) {
            scope(Arrays.asList(scope));
            return this;
        }

        public final void setScopeWithStrings(Collection<String> scope) {
            this.scope = ScopeCopier.copy(scope);
        }

        public final Collection<ResourceChangeDetail.Builder> getDetails() {
            return details != null ? details.stream().map(ResourceChangeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<ResourceChangeDetail> details) {
            this.details = ResourceChangeDetailsCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(ResourceChangeDetail... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<ResourceChangeDetail.Builder>... details) {
            details(Stream.of(details).map(c -> ResourceChangeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDetails(Collection<ResourceChangeDetail.BuilderImpl> details) {
            this.details = ResourceChangeDetailsCopier.copyFromBuilder(details);
        }

        @Override
        public ResourceChange build() {
            return new ResourceChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
