/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ChangeSource;
import software.amazon.awssdk.services.cloudformation.model.EvaluationType;
import software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceChangeDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceChangeDetail> {
    private static final SdkField<ResourceTargetDefinition> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceChangeDetail.getter(ResourceChangeDetail::target)).setter(ResourceChangeDetail.setter(Builder::target)).constructor(ResourceTargetDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> EVALUATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceChangeDetail.getter(ResourceChangeDetail::evaluationAsString)).setter(ResourceChangeDetail.setter(Builder::evaluation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluation").build()}).build();
    private static final SdkField<String> CHANGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceChangeDetail.getter(ResourceChangeDetail::changeSourceAsString)).setter(ResourceChangeDetail.setter(Builder::changeSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSource").build()}).build();
    private static final SdkField<String> CAUSING_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceChangeDetail.getter(ResourceChangeDetail::causingEntity)).setter(ResourceChangeDetail.setter(Builder::causingEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CausingEntity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, EVALUATION_FIELD, CHANGE_SOURCE_FIELD, CAUSING_ENTITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceTargetDefinition target;
    private final String evaluation;
    private final String changeSource;
    private final String causingEntity;

    private ResourceChangeDetail(BuilderImpl builder) {
        this.target = builder.target;
        this.evaluation = builder.evaluation;
        this.changeSource = builder.changeSource;
        this.causingEntity = builder.causingEntity;
    }

    public ResourceTargetDefinition target() {
        return this.target;
    }

    public EvaluationType evaluation() {
        return EvaluationType.fromValue(this.evaluation);
    }

    public String evaluationAsString() {
        return this.evaluation;
    }

    public ChangeSource changeSource() {
        return ChangeSource.fromValue(this.changeSource);
    }

    public String changeSourceAsString() {
        return this.changeSource;
    }

    public String causingEntity() {
        return this.causingEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.causingEntity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChangeDetail)) {
            return false;
        }
        ResourceChangeDetail other = (ResourceChangeDetail)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.evaluationAsString(), other.evaluationAsString()) && Objects.equals(this.changeSourceAsString(), other.changeSourceAsString()) && Objects.equals(this.causingEntity(), other.causingEntity());
    }

    public String toString() {
        return ToString.builder((String)"ResourceChangeDetail").add("Target", (Object)this.target()).add("Evaluation", (Object)this.evaluationAsString()).add("ChangeSource", (Object)this.changeSourceAsString()).add("CausingEntity", (Object)this.causingEntity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Evaluation": {
                return Optional.ofNullable(clazz.cast(this.evaluationAsString()));
            }
            case "ChangeSource": {
                return Optional.ofNullable(clazz.cast(this.changeSourceAsString()));
            }
            case "CausingEntity": {
                return Optional.ofNullable(clazz.cast(this.causingEntity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceChangeDetail, T> g) {
        return obj -> g.apply((ResourceChangeDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceTargetDefinition target;
        private String evaluation;
        private String changeSource;
        private String causingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChangeDetail model) {
            this.target(model.target);
            this.evaluation(model.evaluation);
            this.changeSource(model.changeSource);
            this.causingEntity(model.causingEntity);
        }

        public final ResourceTargetDefinition.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(ResourceTargetDefinition target) {
            this.target = target;
            return this;
        }

        public final void setTarget(ResourceTargetDefinition.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getEvaluationAsString() {
            return this.evaluation;
        }

        @Override
        public final Builder evaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        @Override
        public final Builder evaluation(EvaluationType evaluation) {
            this.evaluation(evaluation == null ? null : evaluation.toString());
            return this;
        }

        public final void setEvaluation(String evaluation) {
            this.evaluation = evaluation;
        }

        public final String getChangeSourceAsString() {
            return this.changeSource;
        }

        @Override
        public final Builder changeSource(String changeSource) {
            this.changeSource = changeSource;
            return this;
        }

        @Override
        public final Builder changeSource(ChangeSource changeSource) {
            this.changeSource(changeSource == null ? null : changeSource.toString());
            return this;
        }

        public final void setChangeSource(String changeSource) {
            this.changeSource = changeSource;
        }

        public final String getCausingEntity() {
            return this.causingEntity;
        }

        @Override
        public final Builder causingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
            return this;
        }

        public final void setCausingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
        }

        public ResourceChangeDetail build() {
            return new ResourceChangeDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceChangeDetail> {
        public Builder target(ResourceTargetDefinition var1);

        default public Builder target(Consumer<ResourceTargetDefinition.Builder> target) {
            return this.target((ResourceTargetDefinition)((ResourceTargetDefinition.Builder)ResourceTargetDefinition.builder().applyMutation(target)).build());
        }

        public Builder evaluation(String var1);

        public Builder evaluation(EvaluationType var1);

        public Builder changeSource(String var1);

        public Builder changeSource(ChangeSource var1);

        public Builder causingEntity(String var1);
    }
}

