/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTypeRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeTypeRequest.Builder, DescribeTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD,
            ARN_FIELD, VERSION_ID_FIELD));

    private final String type;

    private final String typeName;

    private final String arn;

    private final String versionId;

    private DescribeTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.arn = builder.arn;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * Currently the only valid value is <code>RESOURCE</code>.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type. </p>
     *         <p>
     *         Currently the only valid value is <code>RESOURCE</code>.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * Currently the only valid value is <code>RESOURCE</code>.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type. </p>
     *         <p>
     *         Currently the only valid value is <code>RESOURCE</code>.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * @see RegistryType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the type.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The name of the type.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the type.
     * </p>
     * <p>
     * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the type.</p>
     *         <p>
     *         Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name
     * (ARN) assigned to the type version when it is registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific type
     * version. Otherwise, it returns information about the default type version.
     * </p>
     * 
     * @return The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource
     *         Name (ARN) assigned to the type version when it is registered.</p>
     *         <p>
     *         If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that
     *         specific type version. Otherwise, it returns information about the default type version.
     */
    public String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeRequest)) {
            return false;
        }
        DescribeTypeRequest other = (DescribeTypeRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTypeRequest").add("Type", typeAsString()).add("TypeName", typeName()).add("Arn", arn())
                .add("VersionId", versionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeRequest, T> g) {
        return obj -> g.apply((DescribeTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTypeRequest> {
        /**
         * <p>
         * The kind of type.
         * </p>
         * <p>
         * Currently the only valid value is <code>RESOURCE</code>.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of type. </p>
         *        <p>
         *        Currently the only valid value is <code>RESOURCE</code>.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of type.
         * </p>
         * <p>
         * Currently the only valid value is <code>RESOURCE</code>.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param type
         *        The kind of type. </p>
         *        <p>
         *        Currently the only valid value is <code>RESOURCE</code>.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the type.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the type.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the type.
         * </p>
         * <p>
         * Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the type.</p>
         *        <p>
         *        Conditional: You must specify either <code>TypeName</code> and <code>Type</code>, or <code>Arn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of a specific version of the type. The version ID is the value at the end of the Amazon Resource Name
         * (ARN) assigned to the type version when it is registered.
         * </p>
         * <p>
         * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific
         * type version. Otherwise, it returns information about the default type version.
         * </p>
         * 
         * @param versionId
         *        The ID of a specific version of the type. The version ID is the value at the end of the Amazon
         *        Resource Name (ARN) assigned to the type version when it is registered.</p>
         *        <p>
         *        If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that
         *        specific type version. Otherwise, it returns information about the default type version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String type;

        private String typeName;

        private String arn;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeRequest model) {
            super(model);
            type(model.type);
            typeName(model.typeName);
            arn(model.arn);
            versionId(model.versionId);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTypeRequest build() {
            return new DescribeTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
