/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypeVersionsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListTypeVersionsResponse.Builder, ListTypeVersionsResponse> {
    private static final SdkField<List<TypeVersionSummary>> TYPE_VERSION_SUMMARIES_FIELD = SdkField
            .<List<TypeVersionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListTypeVersionsResponse::typeVersionSummaries))
            .setter(setter(Builder::typeVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypeVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypeVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypeVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_VERSION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TypeVersionSummary> typeVersionSummaries;

    private final String nextToken;

    private ListTypeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.typeVersionSummaries = builder.typeVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TypeVersionSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTypeVersionSummaries() {
        return typeVersionSummaries != null && !(typeVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>TypeVersionSummary</code> structures that contain information about the specified type's
     * versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTypeVersionSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>TypeVersionSummary</code> structures that contain information about the specified type's
     *         versions.
     */
    public List<TypeVersionSummary> typeVersionSummaries() {
        return typeVersionSummaries;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call this action again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call this action again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     *         <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeVersionsResponse)) {
            return false;
        }
        ListTypeVersionsResponse other = (ListTypeVersionsResponse) obj;
        return Objects.equals(typeVersionSummaries(), other.typeVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTypeVersionsResponse").add("TypeVersionSummaries", typeVersionSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeVersionSummaries":
            return Optional.ofNullable(clazz.cast(typeVersionSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypeVersionsResponse, T> g) {
        return obj -> g.apply((ListTypeVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTypeVersionsResponse> {
        /**
         * <p>
         * A list of <code>TypeVersionSummary</code> structures that contain information about the specified type's
         * versions.
         * </p>
         * 
         * @param typeVersionSummaries
         *        A list of <code>TypeVersionSummary</code> structures that contain information about the specified
         *        type's versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionSummaries(Collection<TypeVersionSummary> typeVersionSummaries);

        /**
         * <p>
         * A list of <code>TypeVersionSummary</code> structures that contain information about the specified type's
         * versions.
         * </p>
         * 
         * @param typeVersionSummaries
         *        A list of <code>TypeVersionSummary</code> structures that contain information about the specified
         *        type's versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionSummaries(TypeVersionSummary... typeVersionSummaries);

        /**
         * <p>
         * A list of <code>TypeVersionSummary</code> structures that contain information about the specified type's
         * versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TypeVersionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<TypeVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypeVersionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #typeVersionSummaries(List<TypeVersionSummary>)}.
         * 
         * @param typeVersionSummaries
         *        a consumer that will call methods on {@link List<TypeVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typeVersionSummaries(List<TypeVersionSummary>)
         */
        Builder typeVersionSummaries(Consumer<TypeVersionSummary.Builder>... typeVersionSummaries);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call this action again and assign that token to the request object's
         * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call this action again and assign that token to the request
         *        object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code>
         *        is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<TypeVersionSummary> typeVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeVersionsResponse model) {
            super(model);
            typeVersionSummaries(model.typeVersionSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<TypeVersionSummary.Builder> getTypeVersionSummaries() {
            return typeVersionSummaries != null ? typeVersionSummaries.stream().map(TypeVersionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typeVersionSummaries(Collection<TypeVersionSummary> typeVersionSummaries) {
            this.typeVersionSummaries = TypeVersionSummariesCopier.copy(typeVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeVersionSummaries(TypeVersionSummary... typeVersionSummaries) {
            typeVersionSummaries(Arrays.asList(typeVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeVersionSummaries(Consumer<TypeVersionSummary.Builder>... typeVersionSummaries) {
            typeVersionSummaries(Stream.of(typeVersionSummaries).map(c -> TypeVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTypeVersionSummaries(Collection<TypeVersionSummary.BuilderImpl> typeVersionSummaries) {
            this.typeVersionSummaries = TypeVersionSummariesCopier.copyFromBuilder(typeVersionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypeVersionsResponse build() {
            return new ListTypeVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
