/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class StackResourceDriftStatusFiltersCopier {
    static List<String> copy(Collection<String> stackResourceDriftStatusFiltersParam) {
        if (stackResourceDriftStatusFiltersParam == null || stackResourceDriftStatusFiltersParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> stackResourceDriftStatusFiltersParamCopy = new ArrayList<>(stackResourceDriftStatusFiltersParam);
        return Collections.unmodifiableList(stackResourceDriftStatusFiltersParamCopy);
    }

    static List<String> copyEnumToString(Collection<StackResourceDriftStatus> stackResourceDriftStatusFiltersParam) {
        if (stackResourceDriftStatusFiltersParam == null || stackResourceDriftStatusFiltersParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> stackResourceDriftStatusFiltersParamCopy = stackResourceDriftStatusFiltersParam.stream()
                .map(Object::toString).collect(toList());
        return Collections.unmodifiableList(stackResourceDriftStatusFiltersParamCopy);
    }

    static List<StackResourceDriftStatus> copyStringToEnum(Collection<String> stackResourceDriftStatusFiltersParam) {
        if (stackResourceDriftStatusFiltersParam == null || stackResourceDriftStatusFiltersParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<StackResourceDriftStatus> stackResourceDriftStatusFiltersParamCopy = stackResourceDriftStatusFiltersParam.stream()
                .map(StackResourceDriftStatus::fromValue).collect(toList());
        return Collections.unmodifiableList(stackResourceDriftStatusFiltersParamCopy);
    }
}
