/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListTypesRequest.Builder, ListTypesRequest> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypesRequest::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypesRequest::provisioningTypeAsString)).setter(setter(Builder::provisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()).build();

    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypesRequest::deprecatedStatusAsString)).setter(setter(Builder::deprecatedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTypesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD,
            PROVISIONING_TYPE_FIELD, DEPRECATED_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String visibility;

    private final String provisioningType;

    private final String deprecatedStatus;

    private final Integer maxResults;

    private final String nextToken;

    private ListTypesRequest(BuilderImpl builder) {
        super(builder);
        this.visibility = builder.visibility;
        this.provisioningType = builder.provisioningType;
        this.deprecatedStatus = builder.deprecatedStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scope at which the type is visible and usable in CloudFormation operations.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     * Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>PRIVATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The scope at which the type is visible and usable in CloudFormation operations.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     *         Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>PRIVATE</code>.
     * @see Visibility
     */
    public Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The scope at which the type is visible and usable in CloudFormation operations.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     * Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default is <code>PRIVATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The scope at which the type is visible and usable in CloudFormation operations.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     *         Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default is <code>PRIVATE</code>.
     * @see Visibility
     */
    public String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration,
     * based on the types of handlers in the schema handler package submitted.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
     * update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
     * instead be replaced during stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and therefore cannot
     * actually be provisioned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
     *         registration, based on the types of handlers in the schema handler package submitted.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
     *         stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
     *         must instead be replaced during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and
     *         therefore cannot actually be provisioned.
     *         </p>
     *         </li>
     * @see ProvisioningType
     */
    public ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(provisioningType);
    }

    /**
     * <p>
     * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration,
     * based on the types of handlers in the schema handler package submitted.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
     * update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
     * instead be replaced during stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and therefore cannot
     * actually be provisioned.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
     *         registration, based on the types of handlers in the schema handler package submitted.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
     *         stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
     *         must instead be replaced during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and
     *         therefore cannot actually be provisioned.
     *         </p>
     *         </li>
     * @see ProvisioningType
     */
    public String provisioningTypeAsString() {
        return provisioningType;
    }

    /**
     * <p>
     * The deprecation status of the types that you want to get summary information about.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The type is registered for use in CloudFormation operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the types that you want to get summary information about.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The type is registered for use in CloudFormation operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
     *         operations.
     *         </p>
     *         </li>
     * @see DeprecatedStatus
     */
    public DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(deprecatedStatus);
    }

    /**
     * <p>
     * The deprecation status of the types that you want to get summary information about.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The type is registered for use in CloudFormation operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the types that you want to get summary information about.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The type is registered for use in CloudFormation operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
     *         operations.
     *         </p>
     *         </li>
     * @see DeprecatedStatus
     */
    public String deprecatedStatusAsString() {
        return deprecatedStatus;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous paginated request didn't return all of the remaining results, the response object's
     * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous paginated request didn't return all of the remaining results, the response object's
     *         <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
     *         action again and assign that token to the request object's <code>NextToken</code> parameter. If there are
     *         no remaining results, the previous response object's <code>NextToken</code> parameter is set to
     *         <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deprecatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesRequest)) {
            return false;
        }
        ListTypesRequest other = (ListTypesRequest) obj;
        return Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(provisioningTypeAsString(), other.provisioningTypeAsString())
                && Objects.equals(deprecatedStatusAsString(), other.deprecatedStatusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTypesRequest").add("Visibility", visibilityAsString())
                .add("ProvisioningType", provisioningTypeAsString()).add("DeprecatedStatus", deprecatedStatusAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "ProvisioningType":
            return Optional.ofNullable(clazz.cast(provisioningTypeAsString()));
        case "DeprecatedStatus":
            return Optional.ofNullable(clazz.cast(deprecatedStatusAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypesRequest, T> g) {
        return obj -> g.apply((ListTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTypesRequest> {
        /**
         * <p>
         * The scope at which the type is visible and usable in CloudFormation operations.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
         * Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>PRIVATE</code>.
         * </p>
         * 
         * @param visibility
         *        The scope at which the type is visible and usable in CloudFormation operations.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRIVATE</code>: The type is only visible and usable within the account in which it is
         *        registered. Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>PRIVATE</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The scope at which the type is visible and usable in CloudFormation operations.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
         * Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default is <code>PRIVATE</code>.
         * </p>
         * 
         * @param visibility
         *        The scope at which the type is visible and usable in CloudFormation operations.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRIVATE</code>: The type is only visible and usable within the account in which it is
         *        registered. Currently, AWS CloudFormation marks any types you create as <code>PRIVATE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default is <code>PRIVATE</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         * registration, based on the types of handlers in the schema handler package submitted.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
         * update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
         * instead be replaced during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and therefore
         * cannot actually be provisioned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param provisioningType
         *        The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         *        registration, based on the types of handlers in the schema handler package submitted.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
         *        stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
         *        must instead be replaced during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and
         *        therefore cannot actually be provisioned.
         *        </p>
         *        </li>
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(String provisioningType);

        /**
         * <p>
         * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         * registration, based on the types of handlers in the schema handler package submitted.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
         * update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
         * instead be replaced during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and therefore
         * cannot actually be provisioned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param provisioningType
         *        The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         *        registration, based on the types of handlers in the schema handler package submitted.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
         *        stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
         *        must instead be replaced during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROVISIONABLE</code>: The type does not include create, read, and delete handlers, and
         *        therefore cannot actually be provisioned.
         *        </p>
         *        </li>
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(ProvisioningType provisioningType);

        /**
         * <p>
         * The deprecation status of the types that you want to get summary information about.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The type is registered for use in CloudFormation operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         * operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the types that you want to get summary information about.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The type is registered for use in CloudFormation operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         *        operations.
         *        </p>
         *        </li>
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(String deprecatedStatus);

        /**
         * <p>
         * The deprecation status of the types that you want to get summary information about.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The type is registered for use in CloudFormation operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         * operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the types that you want to get summary information about.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The type is registered for use in CloudFormation operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         *        operations.
         *        </p>
         *        </li>
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(DeprecatedStatus deprecatedStatus);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous paginated request didn't return all of the remaining results, the response object's
         * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
         * action again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request didn't return all of the remaining results, the response object's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        this action again and assign that token to the request object's <code>NextToken</code> parameter. If
         *        there are no remaining results, the previous response object's <code>NextToken</code> parameter is set
         *        to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String visibility;

        private String provisioningType;

        private String deprecatedStatus;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesRequest model) {
            super(model);
            visibility(model.visibility);
            provisioningType(model.provisioningType);
            deprecatedStatus(model.deprecatedStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getVisibilityAsString() {
            return visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final String getProvisioningTypeAsString() {
            return provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        public final String getDeprecatedStatusAsString() {
            return deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypesRequest build() {
            return new ListTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
