/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectStackResourceDriftResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DetectStackResourceDriftResponse.Builder, DetectStackResourceDriftResponse> {
    private static final SdkField<StackResourceDrift> STACK_RESOURCE_DRIFT_FIELD = SdkField
            .<StackResourceDrift> builder(MarshallingType.SDK_POJO)
            .getter(getter(DetectStackResourceDriftResponse::stackResourceDrift)).setter(setter(Builder::stackResourceDrift))
            .constructor(StackResourceDrift::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDrift").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_DRIFT_FIELD));

    private final StackResourceDrift stackResourceDrift;

    private DetectStackResourceDriftResponse(BuilderImpl builder) {
        super(builder);
        this.stackResourceDrift = builder.stackResourceDrift;
    }

    /**
     * <p>
     * Information about whether the resource's actual configuration has drifted from its expected template
     * configuration, including actual and expected property values and any differences detected.
     * </p>
     * 
     * @return Information about whether the resource's actual configuration has drifted from its expected template
     *         configuration, including actual and expected property values and any differences detected.
     */
    public StackResourceDrift stackResourceDrift() {
        return stackResourceDrift;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackResourceDrift());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectStackResourceDriftResponse)) {
            return false;
        }
        DetectStackResourceDriftResponse other = (DetectStackResourceDriftResponse) obj;
        return Objects.equals(stackResourceDrift(), other.stackResourceDrift());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectStackResourceDriftResponse").add("StackResourceDrift", stackResourceDrift()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResourceDrift":
            return Optional.ofNullable(clazz.cast(stackResourceDrift()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectStackResourceDriftResponse, T> g) {
        return obj -> g.apply((DetectStackResourceDriftResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectStackResourceDriftResponse> {
        /**
         * <p>
         * Information about whether the resource's actual configuration has drifted from its expected template
         * configuration, including actual and expected property values and any differences detected.
         * </p>
         * 
         * @param stackResourceDrift
         *        Information about whether the resource's actual configuration has drifted from its expected template
         *        configuration, including actual and expected property values and any differences detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResourceDrift(StackResourceDrift stackResourceDrift);

        /**
         * <p>
         * Information about whether the resource's actual configuration has drifted from its expected template
         * configuration, including actual and expected property values and any differences detected.
         * </p>
         * This is a convenience that creates an instance of the {@link StackResourceDrift.Builder} avoiding the need to
         * create one manually via {@link StackResourceDrift#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackResourceDrift.Builder#build()} is called immediately and its
         * result is passed to {@link #stackResourceDrift(StackResourceDrift)}.
         * 
         * @param stackResourceDrift
         *        a consumer that will call methods on {@link StackResourceDrift.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackResourceDrift(StackResourceDrift)
         */
        default Builder stackResourceDrift(Consumer<StackResourceDrift.Builder> stackResourceDrift) {
            return stackResourceDrift(StackResourceDrift.builder().applyMutation(stackResourceDrift).build());
        }
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private StackResourceDrift stackResourceDrift;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectStackResourceDriftResponse model) {
            super(model);
            stackResourceDrift(model.stackResourceDrift);
        }

        public final StackResourceDrift.Builder getStackResourceDrift() {
            return stackResourceDrift != null ? stackResourceDrift.toBuilder() : null;
        }

        @Override
        public final Builder stackResourceDrift(StackResourceDrift stackResourceDrift) {
            this.stackResourceDrift = stackResourceDrift;
            return this;
        }

        public final void setStackResourceDrift(StackResourceDrift.BuilderImpl stackResourceDrift) {
            this.stackResourceDrift = stackResourceDrift != null ? stackResourceDrift.build() : null;
        }

        @Override
        public DetectStackResourceDriftResponse build() {
            return new DetectStackResourceDriftResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
