/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<CreateStackSetRequest.Builder, CreateStackSetRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::stackSetName)).setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::templateURL)).setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField
            .<List<Parameter>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackSetRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Parameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackSetRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateStackSetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ADMINISTRATION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::administrationRoleARN)).setter(setter(Builder::administrationRoleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrationRoleARN").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::executionRoleName)).setter(setter(Builder::executionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()).build();

    private static final SdkField<String> PERMISSION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::permissionModelAsString)).setter(setter(Builder::permissionModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionModel").build()).build();

    private static final SdkField<AutoDeployment> AUTO_DEPLOYMENT_FIELD = SdkField
            .<AutoDeployment> builder(MarshallingType.SDK_POJO).getter(getter(CreateStackSetRequest::autoDeployment))
            .setter(setter(Builder::autoDeployment)).constructor(AutoDeployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeployment").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateStackSetRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            DESCRIPTION_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, TAGS_FIELD,
            ADMINISTRATION_ROLE_ARN_FIELD, EXECUTION_ROLE_NAME_FIELD, PERMISSION_MODEL_FIELD, AUTO_DEPLOYMENT_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String stackSetName;

    private final String description;

    private final String templateBody;

    private final String templateURL;

    private final List<Parameter> parameters;

    private final List<String> capabilities;

    private final List<Tag> tags;

    private final String administrationRoleARN;

    private final String executionRoleName;

    private final String permissionModel;

    private final AutoDeployment autoDeployment;

    private final String clientRequestToken;

    private CreateStackSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.description = builder.description;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.administrationRoleARN = builder.administrationRoleARN;
        this.executionRoleName = builder.executionRoleName;
        this.permissionModel = builder.permissionModel;
        this.autoDeployment = builder.autoDeployment;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name to associate with the stack set. The name must be unique in the Region where you create your stack set.
     * </p>
     * <note>
     * <p>
     * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     * alphabetic character and can't be longer than 128 characters.
     * </p>
     * </note>
     * 
     * @return The name to associate with the stack set. The name must be unique in the Region where you create your
     *         stack set.</p> <note>
     *         <p>
     *         A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
     *         alphabetic character and can't be longer than 128 characters.
     *         </p>
     */
    public String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * A description of the stack set. You can use the description to identify the stack set's purpose or other
     * important information.
     * </p>
     * 
     * @return A description of the stack set. You can use the description to identify the stack set's purpose or other
     *         important information.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
     * bytes. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @return The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
     *         51,200 bytes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * The location of the file that contains the template body. The URL must point to a template (maximum size: 460,800
     * bytes) that's located in an Amazon S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template Anatomy</a>
     * in the AWS CloudFormation User Guide.
     * </p>
     * <p>
     * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     * </p>
     * 
     * @return The location of the file that contains the template body. The URL must point to a template (maximum size:
     *         460,800 bytes) that's located in an Amazon S3 bucket. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
     *         Anatomy</a> in the AWS CloudFormation User Guide.</p>
     *         <p>
     *         Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
     */
    public String templateURL() {
        return templateURL;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The input parameters for the stack set template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The input parameters for the stack set template.
     */
    public List<Parameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for AWS CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
     * creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, AWS CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates contain macros. If your stack template contains one or more macros, and you choose to create a
     * stack directly from the processed template, without first reviewing the resulting changes in a change set, you
     * must acknowledge this capability. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     * CloudFormation Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <note>
     * <p>
     * Stack sets do not currently support macros in stack templates. (This includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
     * capability, if you include a macro in your template the stack set operation will fail.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *         in order for AWS CloudFormation to create the stack set and related stack instances.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your AWS account; for
     *         example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must
     *         explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, AWS CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some templates contain macros. If your stack template contains one or more macros, and you choose to
     *         create a stack directly from the processed template, without first reviewing the resulting changes in a
     *         change set, you must acknowledge this capability. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         <note>
     *         <p>
     *         Stack sets do not currently support macros in stack templates. (This includes the <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
     *         capability, if you include a macro in your template the stack set operation will fail.
     *         </p>
     *         </note></li>
     */
    public List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(capabilities);
    }

    /**
     * Returns true if the Capabilities property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
     * order for AWS CloudFormation to create the stack set and related stack instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     * </p>
     * <p>
     * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
     * creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly
     * acknowledge this by specifying one of these capabilities.
     * </p>
     * <p>
     * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     * <code>CAPABILITY_NAMED_IAM</code> capability.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have IAM resources, you can specify either capability.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify either of these capabilities, AWS CloudFormation returns an
     * <code>InsufficientCapabilities</code> error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If your stack template contains these resources, we recommend that you review all permissions associated with
     * them and edit their permissions if necessary.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     * AWS::IAM::AccessKey</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     * AWS::IAM::Group</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     * AWS::IAM::InstanceProfile</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     * AWS::IAM::Policy</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     * AWS::IAM::Role</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     * AWS::IAM::User</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     * AWS::IAM::UserToGroupAddition</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CAPABILITY_AUTO_EXPAND</code>
     * </p>
     * <p>
     * Some templates contain macros. If your stack template contains one or more macros, and you choose to create a
     * stack directly from the processed template, without first reviewing the resulting changes in a change set, you
     * must acknowledge this capability. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     * CloudFormation Macros to Perform Custom Processing on Templates</a>.
     * </p>
     * <note>
     * <p>
     * Stack sets do not currently support macros in stack templates. (This includes the <a href=
     * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     * >AWS::Include</a> and <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
     * capability, if you include a macro in your template the stack set operation will fail.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities
     *         in order for AWS CloudFormation to create the stack set and related stack instances.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
     *         </p>
     *         <p>
     *         Some stack templates might include resources that can affect permissions in your AWS account; for
     *         example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must
     *         explicitly acknowledge this by specifying one of these capabilities.
     *         </p>
     *         <p>
     *         The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
     *         <code>CAPABILITY_NAMED_IAM</code> capability.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you have IAM resources, you can specify either capability.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify either of these capabilities, AWS CloudFormation returns an
     *         <code>InsufficientCapabilities</code> error.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If your stack template contains these resources, we recommend that you review all permissions associated
     *         with them and edit their permissions if necessary.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
     *         AWS::IAM::AccessKey</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
     *         AWS::IAM::Group</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
     *         AWS::IAM::InstanceProfile</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
     *         AWS::IAM::Policy</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
     *         AWS::IAM::Role</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
     *         AWS::IAM::User</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
     *         AWS::IAM::UserToGroupAddition</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
     *         >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CAPABILITY_AUTO_EXPAND</code>
     *         </p>
     *         <p>
     *         Some templates contain macros. If your stack template contains one or more macros, and you choose to
     *         create a stack directly from the processed template, without first reviewing the resulting changes in a
     *         change set, you must acknowledge this capability. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
     *         CloudFormation Macros to Perform Custom Processing on Templates</a>.
     *         </p>
     *         <note>
     *         <p>
     *         Stack sets do not currently support macros in stack templates. (This includes the <a href=
     *         "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
     *         >AWS::Include</a> and <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
     *         >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
     *         capability, if you include a macro in your template the stack set operation will fail.
     *         </p>
     *         </note></li>
     */
    public List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also
     * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can be
     * specified.
     * </p>
     * <p>
     * If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if you have
     * the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code> action fails
     * with an <code>access denied</code> error, and the stack set is not created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation
     *         also propagates these tags to supported resources that are created in the stacks. A maximum number of 50
     *         tags can be specified.</p>
     *         <p>
     *         If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if
     *         you have the required IAM permission to tag resources. If you don't, the entire
     *         <code>CreateStackSet</code> action fails with an <code>access denied</code> error, and the stack set is
     *         not created.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
     * manage specific stack sets within the same administrator account. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
     * Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p>
     *         <p>
     *         Specify an IAM role only if you are using customized administrator roles to control which users or groups
     *         can manage specific stack sets within the same administrator account. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html"
     *         >Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User
     *         Guide</i>.
     */
    public String administrationRoleARN() {
        return administrationRoleARN;
    }

    /**
     * <p>
     * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role, AWS
     * CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set operation.
     * </p>
     * <p>
     * Specify an IAM role only if you are using customized execution roles to control which stack resources users and
     * groups can include in their stack sets.
     * </p>
     * 
     * @return The name of the IAM execution role to use to create the stack set. If you do not specify an execution
     *         role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack
     *         set operation.</p>
     *         <p>
     *         Specify an IAM role only if you are using customized execution roles to control which stack resources
     *         users and groups can include in their stack sets.
     */
    public String executionRoleName() {
        return executionRoleName;
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by AWS Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionModel}
     * will return {@link PermissionModels#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionModelAsString}.
     * </p>
     * 
     * @return Describes how the IAM roles required for stack set operations are created. By default,
     *         <code>SELF-MANAGED</code> is specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         With <code>self-managed</code> permissions, you must create the administrator and execution roles
     *         required to deploy to target accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
     *         >Grant Self-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *         deploy to accounts managed by AWS Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *         >Grant Service-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     * @see PermissionModels
     */
    public PermissionModels permissionModel() {
        return PermissionModels.fromValue(permissionModel);
    }

    /**
     * <p>
     * Describes how the IAM roles required for stack set operations are created. By default, <code>SELF-MANAGED</code>
     * is specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
     * deploy to target accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">Grant
     * Self-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to deploy
     * to accounts managed by AWS Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     * >Grant Service-Managed Stack Set Permissions</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionModel}
     * will return {@link PermissionModels#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionModelAsString}.
     * </p>
     * 
     * @return Describes how the IAM roles required for stack set operations are created. By default,
     *         <code>SELF-MANAGED</code> is specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         With <code>self-managed</code> permissions, you must create the administrator and execution roles
     *         required to deploy to target accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
     *         >Grant Self-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
     *         deploy to accounts managed by AWS Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
     *         >Grant Service-Managed Stack Set Permissions</a>.
     *         </p>
     *         </li>
     * @see PermissionModels
     */
    public String permissionModelAsString() {
        return permissionModel;
    }

    /**
     * <p>
     * Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to the target
     * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @return Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to the
     *         target organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
     *         <code>SERVICE_MANAGED</code>.
     */
    public AutoDeployment autoDeployment() {
        return autoDeployment;
    }

    /**
     * <p>
     * A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     * requests so that AWS CloudFormation knows that you're not attempting to create another stack set with the same
     * name. You might retry <code>CreateStackSet</code> requests to ensure that AWS CloudFormation successfully
     * received them.
     * </p>
     * <p>
     * If you don't specify an operation ID, the SDK generates one automatically.
     * </p>
     * 
     * @return A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
     *         requests so that AWS CloudFormation knows that you're not attempting to create another stack set with the
     *         same name. You might retry <code>CreateStackSet</code> requests to ensure that AWS CloudFormation
     *         successfully received them.</p>
     *         <p>
     *         If you don't specify an operation ID, the SDK generates one automatically.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(administrationRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(permissionModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackSetRequest)) {
            return false;
        }
        CreateStackSetRequest other = (CreateStackSetRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName()) && Objects.equals(description(), other.description())
                && Objects.equals(templateBody(), other.templateBody()) && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(tags(), other.tags())
                && Objects.equals(administrationRoleARN(), other.administrationRoleARN())
                && Objects.equals(executionRoleName(), other.executionRoleName())
                && Objects.equals(permissionModelAsString(), other.permissionModelAsString())
                && Objects.equals(autoDeployment(), other.autoDeployment())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateStackSetRequest").add("StackSetName", stackSetName()).add("Description", description())
                .add("TemplateBody", templateBody()).add("TemplateURL", templateURL()).add("Parameters", parameters())
                .add("Capabilities", capabilitiesAsStrings()).add("Tags", tags())
                .add("AdministrationRoleARN", administrationRoleARN()).add("ExecutionRoleName", executionRoleName())
                .add("PermissionModel", permissionModelAsString()).add("AutoDeployment", autoDeployment())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AdministrationRoleARN":
            return Optional.ofNullable(clazz.cast(administrationRoleARN()));
        case "ExecutionRoleName":
            return Optional.ofNullable(clazz.cast(executionRoleName()));
        case "PermissionModel":
            return Optional.ofNullable(clazz.cast(permissionModelAsString()));
        case "AutoDeployment":
            return Optional.ofNullable(clazz.cast(autoDeployment()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackSetRequest, T> g) {
        return obj -> g.apply((CreateStackSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackSetRequest> {
        /**
         * <p>
         * The name to associate with the stack set. The name must be unique in the Region where you create your stack
         * set.
         * </p>
         * <note>
         * <p>
         * A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with an
         * alphabetic character and can't be longer than 128 characters.
         * </p>
         * </note>
         * 
         * @param stackSetName
         *        The name to associate with the stack set. The name must be unique in the Region where you create your
         *        stack set.</p> <note>
         *        <p>
         *        A stack name can contain only alphanumeric characters (case-sensitive) and hyphens. It must start with
         *        an alphabetic character and can't be longer than 128 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * A description of the stack set. You can use the description to identify the stack set's purpose or other
         * important information.
         * </p>
         * 
         * @param description
         *        A description of the stack set. You can use the description to identify the stack set's purpose or
         *        other important information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The structure that contains the template body, with a minimum length of 1 byte and a maximum length of 51,200
         * bytes. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
         * </p>
         * 
         * @param templateBody
         *        The structure that contains the template body, with a minimum length of 1 byte and a maximum length of
         *        51,200 bytes. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * The location of the file that contains the template body. The URL must point to a template (maximum size:
         * 460,800 bytes) that's located in an Amazon S3 bucket. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         * Anatomy</a> in the AWS CloudFormation User Guide.
         * </p>
         * <p>
         * Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
         * </p>
         * 
         * @param templateURL
         *        The location of the file that contains the template body. The URL must point to a template (maximum
         *        size: 460,800 bytes) that's located in an Amazon S3 bucket. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html">Template
         *        Anatomy</a> in the AWS CloudFormation User Guide.</p>
         *        <p>
         *        Conditional: You must specify either the TemplateBody or the TemplateURL parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * The input parameters for the stack set template.
         * </p>
         * 
         * @param parameters
         *        The input parameters for the stack set template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<Parameter> parameters);

        /**
         * <p>
         * The input parameters for the stack set template.
         * </p>
         * 
         * @param parameters
         *        The input parameters for the stack set template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameter... parameters);

        /**
         * <p>
         * The input parameters for the stack set template.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Parameter>.Builder} avoiding the need to
         * create one manually via {@link List<Parameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Parameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<Parameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<Parameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<Parameter>)
         */
        Builder parameters(Consumer<Parameter.Builder>... parameters);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
         * order for AWS CloudFormation to create the stack set and related stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates contain macros. If your stack template contains one or more macros, and you choose to create a
         * stack directly from the processed template, without first reviewing the resulting changes in a change set,
         * you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <note>
         * <p>
         * Stack sets do not currently support macros in stack templates. (This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
         * capability, if you include a macro in your template the stack set operation will fail.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack set template contains certain
         *        capabilities in order for AWS CloudFormation to create the stack set and related stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you
         *        must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates contain macros. If your stack template contains one or more macros, and you choose to
         *        create a stack directly from the processed template, without first reviewing the resulting changes in
         *        a change set, you must acknowledge this capability. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Stack sets do not currently support macros in stack templates. (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify
         *        this capability, if you include a macro in your template the stack set operation will fail.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
         * order for AWS CloudFormation to create the stack set and related stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates contain macros. If your stack template contains one or more macros, and you choose to create a
         * stack directly from the processed template, without first reviewing the resulting changes in a change set,
         * you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <note>
         * <p>
         * Stack sets do not currently support macros in stack templates. (This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
         * capability, if you include a macro in your template the stack set operation will fail.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack set template contains certain
         *        capabilities in order for AWS CloudFormation to create the stack set and related stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you
         *        must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates contain macros. If your stack template contains one or more macros, and you choose to
         *        create a stack directly from the processed template, without first reviewing the resulting changes in
         *        a change set, you must acknowledge this capability. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Stack sets do not currently support macros in stack templates. (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify
         *        this capability, if you include a macro in your template the stack set operation will fail.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
         * order for AWS CloudFormation to create the stack set and related stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates contain macros. If your stack template contains one or more macros, and you choose to create a
         * stack directly from the processed template, without first reviewing the resulting changes in a change set,
         * you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <note>
         * <p>
         * Stack sets do not currently support macros in stack templates. (This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
         * capability, if you include a macro in your template the stack set operation will fail.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack set template contains certain
         *        capabilities in order for AWS CloudFormation to create the stack set and related stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you
         *        must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates contain macros. If your stack template contains one or more macros, and you choose to
         *        create a stack directly from the processed template, without first reviewing the resulting changes in
         *        a change set, you must acknowledge this capability. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Stack sets do not currently support macros in stack templates. (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify
         *        this capability, if you include a macro in your template the stack set operation will fail.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * In some cases, you must explicitly acknowledge that your stack set template contains certain capabilities in
         * order for AWS CloudFormation to create the stack set and related stack instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         * </p>
         * <p>
         * Some stack templates might include resources that can affect permissions in your AWS account; for example, by
         * creating new AWS Identity and Access Management (IAM) users. For those stack sets, you must explicitly
         * acknowledge this by specifying one of these capabilities.
         * </p>
         * <p>
         * The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         * <code>CAPABILITY_NAMED_IAM</code> capability.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you have IAM resources, you can specify either capability.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify either of these capabilities, AWS CloudFormation returns an
         * <code>InsufficientCapabilities</code> error.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If your stack template contains these resources, we recommend that you review all permissions associated with
         * them and edit their permissions if necessary.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         * AWS::IAM::AccessKey</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         * AWS::IAM::Group</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">
         * AWS::IAM::InstanceProfile</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         * AWS::IAM::Policy</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         * AWS::IAM::Role</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         * AWS::IAM::User</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html">
         * AWS::IAM::UserToGroupAddition</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         * >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CAPABILITY_AUTO_EXPAND</code>
         * </p>
         * <p>
         * Some templates contain macros. If your stack template contains one or more macros, and you choose to create a
         * stack directly from the processed template, without first reviewing the resulting changes in a change set,
         * you must acknowledge this capability. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         * CloudFormation Macros to Perform Custom Processing on Templates</a>.
         * </p>
         * <note>
         * <p>
         * Stack sets do not currently support macros in stack templates. (This includes the <a href=
         * "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         * >AWS::Include</a> and <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         * >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify this
         * capability, if you include a macro in your template the stack set operation will fail.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param capabilities
         *        In some cases, you must explicitly acknowledge that your stack set template contains certain
         *        capabilities in order for AWS CloudFormation to create the stack set and related stack instances.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_IAM</code> and <code>CAPABILITY_NAMED_IAM</code>
         *        </p>
         *        <p>
         *        Some stack templates might include resources that can affect permissions in your AWS account; for
         *        example, by creating new AWS Identity and Access Management (IAM) users. For those stack sets, you
         *        must explicitly acknowledge this by specifying one of these capabilities.
         *        </p>
         *        <p>
         *        The following IAM resources require you to specify either the <code>CAPABILITY_IAM</code> or
         *        <code>CAPABILITY_NAMED_IAM</code> capability.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you have IAM resources, you can specify either capability.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you have IAM resources with custom names, you <i>must</i> specify <code>CAPABILITY_NAMED_IAM</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify either of these capabilities, AWS CloudFormation returns an
         *        <code>InsufficientCapabilities</code> error.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If your stack template contains these resources, we recommend that you review all permissions
         *        associated with them and edit their permissions if necessary.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html">
         *        AWS::IAM::AccessKey</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">
         *        AWS::IAM::Group</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html"
         *        > AWS::IAM::InstanceProfile</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html">
         *        AWS::IAM::Policy</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">
         *        AWS::IAM::Role</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html">
         *        AWS::IAM::User</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html"
         *        > AWS::IAM::UserToGroupAddition</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities"
         *        >Acknowledging IAM Resources in AWS CloudFormation Templates</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CAPABILITY_AUTO_EXPAND</code>
         *        </p>
         *        <p>
         *        Some templates contain macros. If your stack template contains one or more macros, and you choose to
         *        create a stack directly from the processed template, without first reviewing the resulting changes in
         *        a change set, you must acknowledge this capability. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html">Using AWS
         *        CloudFormation Macros to Perform Custom Processing on Templates</a>.
         *        </p>
         *        <note>
         *        <p>
         *        Stack sets do not currently support macros in stack templates. (This includes the <a href=
         *        "http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html"
         *        >AWS::Include</a> and <a
         *        href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html"
         *        >AWS::Serverless</a> transforms, which are macros hosted by AWS CloudFormation.) Even if you specify
         *        this capability, if you include a macro in your template the stack set operation will fail.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also
         * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can
         * be specified.
         * </p>
         * <p>
         * If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if you
         * have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
         * action fails with an <code>access denied</code> error, and the stack set is not created.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to associate with this stack set and the stacks created from it. AWS
         *        CloudFormation also propagates these tags to supported resources that are created in the stacks. A
         *        maximum number of 50 tags can be specified.</p>
         *        <p>
         *        If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see
         *        if you have the required IAM permission to tag resources. If you don't, the entire
         *        <code>CreateStackSet</code> action fails with an <code>access denied</code> error, and the stack set
         *        is not created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also
         * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can
         * be specified.
         * </p>
         * <p>
         * If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if you
         * have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
         * action fails with an <code>access denied</code> error, and the stack set is not created.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to associate with this stack set and the stacks created from it. AWS
         *        CloudFormation also propagates these tags to supported resources that are created in the stacks. A
         *        maximum number of 50 tags can be specified.</p>
         *        <p>
         *        If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see
         *        if you have the required IAM permission to tag resources. If you don't, the entire
         *        <code>CreateStackSet</code> action fails with an <code>access denied</code> error, and the stack set
         *        is not created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key-value pairs to associate with this stack set and the stacks created from it. AWS CloudFormation also
         * propagates these tags to supported resources that are created in the stacks. A maximum number of 50 tags can
         * be specified.
         * </p>
         * <p>
         * If you specify tags as part of a <code>CreateStackSet</code> action, AWS CloudFormation checks to see if you
         * have the required IAM permission to tag resources. If you don't, the entire <code>CreateStackSet</code>
         * action fails with an <code>access denied</code> error, and the stack set is not created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the IAM role to use to create this stack set.
         * </p>
         * <p>
         * Specify an IAM role only if you are using customized administrator roles to control which users or groups can
         * manage specific stack sets within the same administrator account. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">Prerequisites:
         * Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User Guide</i>.
         * </p>
         * 
         * @param administrationRoleARN
         *        The Amazon Resource Number (ARN) of the IAM role to use to create this stack set. </p>
         *        <p>
         *        Specify an IAM role only if you are using customized administrator roles to control which users or
         *        groups can manage specific stack sets within the same administrator account. For more information, see
         *        <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html">
         *        Prerequisites: Granting Permissions for Stack Set Operations</a> in the <i>AWS CloudFormation User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrationRoleARN(String administrationRoleARN);

        /**
         * <p>
         * The name of the IAM execution role to use to create the stack set. If you do not specify an execution role,
         * AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the stack set
         * operation.
         * </p>
         * <p>
         * Specify an IAM role only if you are using customized execution roles to control which stack resources users
         * and groups can include in their stack sets.
         * </p>
         * 
         * @param executionRoleName
         *        The name of the IAM execution role to use to create the stack set. If you do not specify an execution
         *        role, AWS CloudFormation uses the <code>AWSCloudFormationStackSetExecutionRole</code> role for the
         *        stack set operation.</p>
         *        <p>
         *        Specify an IAM role only if you are using customized execution roles to control which stack resources
         *        users and groups can include in their stack sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleName(String executionRoleName);

        /**
         * <p>
         * Describes how the IAM roles required for stack set operations are created. By default,
         * <code>SELF-MANAGED</code> is specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
         * deploy to target accounts. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         * >Grant Self-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
         * deploy to accounts managed by AWS Organizations. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant
         * Service-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionModel
         *        Describes how the IAM roles required for stack set operations are created. By default,
         *        <code>SELF-MANAGED</code> is specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        With <code>self-managed</code> permissions, you must create the administrator and execution roles
         *        required to deploy to target accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         *        >Grant Self-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required
         *        to deploy to accounts managed by AWS Organizations. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
         *        >Grant Service-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         * @see PermissionModels
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionModels
         */
        Builder permissionModel(String permissionModel);

        /**
         * <p>
         * Describes how the IAM roles required for stack set operations are created. By default,
         * <code>SELF-MANAGED</code> is specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * With <code>self-managed</code> permissions, you must create the administrator and execution roles required to
         * deploy to target accounts. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         * >Grant Self-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required to
         * deploy to accounts managed by AWS Organizations. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html">Grant
         * Service-Managed Stack Set Permissions</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissionModel
         *        Describes how the IAM roles required for stack set operations are created. By default,
         *        <code>SELF-MANAGED</code> is specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        With <code>self-managed</code> permissions, you must create the administrator and execution roles
         *        required to deploy to target accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html"
         *        >Grant Self-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        With <code>service-managed</code> permissions, StackSets automatically creates the IAM roles required
         *        to deploy to accounts managed by AWS Organizations. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-service-managed.html"
         *        >Grant Service-Managed Stack Set Permissions</a>.
         *        </p>
         *        </li>
         * @see PermissionModels
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionModels
         */
        Builder permissionModel(PermissionModels permissionModel);

        /**
         * <p>
         * Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to the target
         * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
         * <code>SERVICE_MANAGED</code>.
         * </p>
         * 
         * @param autoDeployment
         *        Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to the
         *        target organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
         *        <code>SERVICE_MANAGED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeployment(AutoDeployment autoDeployment);

        /**
         * <p>
         * Describes whether StackSets automatically deploys to AWS Organizations accounts that are added to the target
         * organization or organizational unit (OU). Specify only if <code>PermissionModel</code> is
         * <code>SERVICE_MANAGED</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoDeployment.Builder} avoiding the need to
         * create one manually via {@link AutoDeployment#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoDeployment.Builder#build()} is called immediately and its
         * result is passed to {@link #autoDeployment(AutoDeployment)}.
         * 
         * @param autoDeployment
         *        a consumer that will call methods on {@link AutoDeployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoDeployment(AutoDeployment)
         */
        default Builder autoDeployment(Consumer<AutoDeployment.Builder> autoDeployment) {
            return autoDeployment(AutoDeployment.builder().applyMutation(autoDeployment).build());
        }

        /**
         * <p>
         * A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to retry
         * requests so that AWS CloudFormation knows that you're not attempting to create another stack set with the
         * same name. You might retry <code>CreateStackSet</code> requests to ensure that AWS CloudFormation
         * successfully received them.
         * </p>
         * <p>
         * If you don't specify an operation ID, the SDK generates one automatically.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for this <code>CreateStackSet</code> request. Specify this token if you plan to
         *        retry requests so that AWS CloudFormation knows that you're not attempting to create another stack set
         *        with the same name. You might retry <code>CreateStackSet</code> requests to ensure that AWS
         *        CloudFormation successfully received them.</p>
         *        <p>
         *        If you don't specify an operation ID, the SDK generates one automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String description;

        private String templateBody;

        private String templateURL;

        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String administrationRoleARN;

        private String executionRoleName;

        private String permissionModel;

        private AutoDeployment autoDeployment;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackSetRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            description(model.description);
            templateBody(model.templateBody);
            templateURL(model.templateURL);
            parameters(model.parameters);
            capabilitiesWithStrings(model.capabilities);
            tags(model.tags);
            administrationRoleARN(model.administrationRoleARN);
            executionRoleName(model.executionRoleName);
            permissionModel(model.permissionModel);
            autoDeployment(model.autoDeployment);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return parameters != null ? parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> Parameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilitiesAsStrings() {
            return capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getAdministrationRoleARN() {
            return administrationRoleARN;
        }

        @Override
        public final Builder administrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
            return this;
        }

        public final void setAdministrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
        }

        public final String getExecutionRoleName() {
            return executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        public final String getPermissionModelAsString() {
            return permissionModel;
        }

        @Override
        public final Builder permissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        @Override
        public final Builder permissionModel(PermissionModels permissionModel) {
            this.permissionModel(permissionModel == null ? null : permissionModel.toString());
            return this;
        }

        public final void setPermissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
        }

        public final AutoDeployment.Builder getAutoDeployment() {
            return autoDeployment != null ? autoDeployment.toBuilder() : null;
        }

        @Override
        public final Builder autoDeployment(AutoDeployment autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        public final void setAutoDeployment(AutoDeployment.BuilderImpl autoDeployment) {
            this.autoDeployment = autoDeployment != null ? autoDeployment.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackSetRequest build() {
            return new CreateStackSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
