/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTypeResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeTypeResponse.Builder, DescribeTypeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::defaultVersionId)).setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::provisioningTypeAsString)).setter(setter(Builder::provisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()).build();

    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::deprecatedStatusAsString)).setter(setter(Builder::deprecatedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeTypeResponse::loggingConfig))
            .setter(setter(Builder::loggingConfig)).constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()).build();

    private static final SdkField<String> DOCUMENTATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTypeResponse::documentationUrl)).setter(setter(Builder::documentationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationUrl").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeTypeResponse::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeTypeResponse::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD,
            TYPE_NAME_FIELD, DEFAULT_VERSION_ID_FIELD, DESCRIPTION_FIELD, SCHEMA_FIELD, PROVISIONING_TYPE_FIELD,
            DEPRECATED_STATUS_FIELD, LOGGING_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, VISIBILITY_FIELD, SOURCE_URL_FIELD,
            DOCUMENTATION_URL_FIELD, LAST_UPDATED_FIELD, TIME_CREATED_FIELD));

    private final String arn;

    private final String type;

    private final String typeName;

    private final String defaultVersionId;

    private final String description;

    private final String schema;

    private final String provisioningType;

    private final String deprecatedStatus;

    private final LoggingConfig loggingConfig;

    private final String executionRoleArn;

    private final String visibility;

    private final String sourceUrl;

    private final String documentationUrl;

    private final Instant lastUpdated;

    private final Instant timeCreated;

    private DescribeTypeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.description = builder.description;
        this.schema = builder.schema;
        this.provisioningType = builder.provisioningType;
        this.deprecatedStatus = builder.deprecatedStatus;
        this.loggingConfig = builder.loggingConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.visibility = builder.visibility;
        this.sourceUrl = builder.sourceUrl;
        this.documentationUrl = builder.documentationUrl;
        this.lastUpdated = builder.lastUpdated;
        this.timeCreated = builder.timeCreated;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the type.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the type.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * Currently the only valid value is <code>RESOURCE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type. </p>
     *         <p>
     *         Currently the only valid value is <code>RESOURCE</code>.
     * @see RegistryType
     */
    public RegistryType type() {
        return RegistryType.fromValue(type);
    }

    /**
     * <p>
     * The kind of type.
     * </p>
     * <p>
     * Currently the only valid value is <code>RESOURCE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RegistryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of type. </p>
     *         <p>
     *         Currently the only valid value is <code>RESOURCE</code>.
     * @see RegistryType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the registered type.
     * </p>
     * 
     * @return The name of the registered type.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The ID of the default version of the type. The default version is used when the type version is not specified.
     * </p>
     * <p>
     * To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
     * </p>
     * 
     * @return The ID of the default version of the type. The default version is used when the type version is not
     *         specified.</p>
     *         <p>
     *         To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
     */
    public String defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * The description of the registered type.
     * </p>
     * 
     * @return The description of the registered type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The schema that defines the type.
     * </p>
     * <p>
     * For more information on type schemas, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
     * Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * 
     * @return The schema that defines the type.</p>
     *         <p>
     *         For more information on type schemas, see <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
     *         Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
     */
    public String schema() {
        return schema;
    }

    /**
     * <p>
     * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration,
     * based on the types of handlers in the schema handler package submitted.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
     * update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
     * instead be replaced during stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore cannot
     * actually be provisioned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * create
     * </p>
     * </li>
     * <li>
     * <p>
     * read
     * </p>
     * </li>
     * <li>
     * <p>
     * delete
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
     *         registration, based on the types of handlers in the schema handler package submitted.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
     *         stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
     *         must instead be replaced during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore
     *         cannot actually be provisioned.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         read
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         delete
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ProvisioningType
     */
    public ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(provisioningType);
    }

    /**
     * <p>
     * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during registration,
     * based on the types of handlers in the schema handler package submitted.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
     * update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
     * instead be replaced during stack update operations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore cannot
     * actually be provisioned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * create
     * </p>
     * </li>
     * <li>
     * <p>
     * read
     * </p>
     * </li>
     * <li>
     * <p>
     * delete
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
     *         registration, based on the types of handlers in the schema handler package submitted.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
     *         stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
     *         must instead be replaced during stack update operations.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore
     *         cannot actually be provisioned.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         create
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         read
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         delete
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ProvisioningType
     */
    public String provisioningTypeAsString() {
        return provisioningType;
    }

    /**
     * <p>
     * The deprecation status of the type.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its
     * provisioning behavior and visibility scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the type.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its
     *         provisioning behavior and visibility scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
     *         operations.
     *         </p>
     *         </li>
     * @see DeprecatedStatus
     */
    public DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(deprecatedStatus);
    }

    /**
     * <p>
     * The deprecation status of the type.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its
     * provisioning behavior and visibility scope.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deprecatedStatus}
     * will return {@link DeprecatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deprecatedStatusAsString}.
     * </p>
     * 
     * @return The deprecation status of the type.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its
     *         provisioning behavior and visibility scope.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
     *         operations.
     *         </p>
     *         </li>
     * @see DeprecatedStatus
     */
    public String deprecatedStatusAsString() {
        return deprecatedStatus;
    }

    /**
     * <p>
     * Contains logging configuration information for a type.
     * </p>
     * 
     * @return Contains logging configuration information for a type.
     */
    public LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM execution role used to register the type. If your resource type calls
     * AWS APIs in any of its handlers, you must create an <i> <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that includes
     * the necessary permissions to call those AWS APIs, and provision that execution role in your account.
     * CloudFormation then assumes that execution role to provide your resource type with the appropriate credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM execution role used to register the type. If your resource type
     *         calls AWS APIs in any of its handlers, you must create an <i> <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
     *         includes the necessary permissions to call those AWS APIs, and provision that execution role in your
     *         account. CloudFormation then assumes that execution role to provide your resource type with the
     *         appropriate credentials.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The scope at which the type is visible and usable in CloudFormation operations.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     * Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The scope at which the type is visible and usable in CloudFormation operations.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     *         Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The scope at which the type is visible and usable in CloudFormation operations.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     * Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The scope at which the type is visible and usable in CloudFormation operations.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
     *         Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
     *         </p>
     *         </li>
     * @see Visibility
     */
    public String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The URL of the source code for the type.
     * </p>
     * 
     * @return The URL of the source code for the type.
     */
    public String sourceUrl() {
        return sourceUrl;
    }

    /**
     * <p>
     * The URL of a page providing detailed documentation for this type.
     * </p>
     * 
     * @return The URL of a page providing detailed documentation for this type.
     */
    public String documentationUrl() {
        return documentationUrl;
    }

    /**
     * <p>
     * When the specified type version was registered.
     * </p>
     * 
     * @return When the specified type version was registered.
     */
    public Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * When the specified type version was registered.
     * </p>
     * 
     * @return When the specified type version was registered.
     */
    public Instant timeCreated() {
        return timeCreated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deprecatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(documentationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeResponse)) {
            return false;
        }
        DescribeTypeResponse other = (DescribeTypeResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(defaultVersionId(), other.defaultVersionId())
                && Objects.equals(description(), other.description()) && Objects.equals(schema(), other.schema())
                && Objects.equals(provisioningTypeAsString(), other.provisioningTypeAsString())
                && Objects.equals(deprecatedStatusAsString(), other.deprecatedStatusAsString())
                && Objects.equals(loggingConfig(), other.loggingConfig())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(sourceUrl(), other.sourceUrl()) && Objects.equals(documentationUrl(), other.documentationUrl())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(timeCreated(), other.timeCreated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTypeResponse").add("Arn", arn()).add("Type", typeAsString()).add("TypeName", typeName())
                .add("DefaultVersionId", defaultVersionId()).add("Description", description()).add("Schema", schema())
                .add("ProvisioningType", provisioningTypeAsString()).add("DeprecatedStatus", deprecatedStatusAsString())
                .add("LoggingConfig", loggingConfig()).add("ExecutionRoleArn", executionRoleArn())
                .add("Visibility", visibilityAsString()).add("SourceUrl", sourceUrl())
                .add("DocumentationUrl", documentationUrl()).add("LastUpdated", lastUpdated()).add("TimeCreated", timeCreated())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "DefaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "ProvisioningType":
            return Optional.ofNullable(clazz.cast(provisioningTypeAsString()));
        case "DeprecatedStatus":
            return Optional.ofNullable(clazz.cast(deprecatedStatusAsString()));
        case "LoggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "DocumentationUrl":
            return Optional.ofNullable(clazz.cast(documentationUrl()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "TimeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeResponse, T> g) {
        return obj -> g.apply((DescribeTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTypeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the type.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The kind of type.
         * </p>
         * <p>
         * Currently the only valid value is <code>RESOURCE</code>.
         * </p>
         * 
         * @param type
         *        The kind of type. </p>
         *        <p>
         *        Currently the only valid value is <code>RESOURCE</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of type.
         * </p>
         * <p>
         * Currently the only valid value is <code>RESOURCE</code>.
         * </p>
         * 
         * @param type
         *        The kind of type. </p>
         *        <p>
         *        Currently the only valid value is <code>RESOURCE</code>.
         * @see RegistryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistryType
         */
        Builder type(RegistryType type);

        /**
         * <p>
         * The name of the registered type.
         * </p>
         * 
         * @param typeName
         *        The name of the registered type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The ID of the default version of the type. The default version is used when the type version is not
         * specified.
         * </p>
         * <p>
         * To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
         * </p>
         * 
         * @param defaultVersionId
         *        The ID of the default version of the type. The default version is used when the type version is not
         *        specified.</p>
         *        <p>
         *        To set the default version of a type, use <code> <a>SetTypeDefaultVersion</a> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);

        /**
         * <p>
         * The description of the registered type.
         * </p>
         * 
         * @param description
         *        The description of the registered type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The schema that defines the type.
         * </p>
         * <p>
         * For more information on type schemas, see <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">Resource
         * Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
         * </p>
         * 
         * @param schema
         *        The schema that defines the type.</p>
         *        <p>
         *        For more information on type schemas, see <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >Resource Provider Schema</a> in the <i>CloudFormation CLI User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         * registration, based on the types of handlers in the schema handler package submitted.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
         * update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
         * instead be replaced during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore cannot
         * actually be provisioned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * create
         * </p>
         * </li>
         * <li>
         * <p>
         * read
         * </p>
         * </li>
         * <li>
         * <p>
         * delete
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param provisioningType
         *        The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         *        registration, based on the types of handlers in the schema handler package submitted.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
         *        stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
         *        must instead be replaced during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore
         *        cannot actually be provisioned.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        read
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        delete
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(String provisioningType);

        /**
         * <p>
         * The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         * registration, based on the types of handlers in the schema handler package submitted.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during stack
         * update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and must
         * instead be replaced during stack update operations.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore cannot
         * actually be provisioned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * create
         * </p>
         * </li>
         * <li>
         * <p>
         * read
         * </p>
         * </li>
         * <li>
         * <p>
         * delete
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param provisioningType
         *        The provisioning behavior of the type. AWS CloudFormation determines the provisioning type during
         *        registration, based on the types of handlers in the schema handler package submitted.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULLY_MUTABLE</code>: The type includes an update handler to process updates to the type during
         *        stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMMUTABLE</code>: The type does not include an update handler, so the type cannot be updated and
         *        must instead be replaced during stack update operations.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_PROVISIONABLE</code>: The type does not include all of the following handlers, and therefore
         *        cannot actually be provisioned.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        create
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        read
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        delete
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(ProvisioningType provisioningType);

        /**
         * <p>
         * The deprecation status of the type.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its
         * provisioning behavior and visibility scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         * operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the type.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on
         *        its provisioning behavior and visibility scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         *        operations.
         *        </p>
         *        </li>
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(String deprecatedStatus);

        /**
         * <p>
         * The deprecation status of the type.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on its
         * provisioning behavior and visibility scope.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         * operations.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deprecatedStatus
         *        The deprecation status of the type.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LIVE</code>: The type is registered and can be used in CloudFormation operations, dependent on
         *        its provisioning behavior and visibility scope.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code>: The type has been deregistered and can no longer be used in CloudFormation
         *        operations.
         *        </p>
         *        </li>
         * @see DeprecatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeprecatedStatus
         */
        Builder deprecatedStatus(DeprecatedStatus deprecatedStatus);

        /**
         * <p>
         * Contains logging configuration information for a type.
         * </p>
         * 
         * @param loggingConfig
         *        Contains logging configuration information for a type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * <p>
         * Contains logging configuration information for a type.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingConfig.Builder} avoiding the need to
         * create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM execution role used to register the type. If your resource type
         * calls AWS APIs in any of its handlers, you must create an <i> <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
         * includes the necessary permissions to call those AWS APIs, and provision that execution role in your account.
         * CloudFormation then assumes that execution role to provide your resource type with the appropriate
         * credentials.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM execution role used to register the type. If your resource
         *        type calls AWS APIs in any of its handlers, you must create an <i> <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html">IAM execution role</a> </i> that
         *        includes the necessary permissions to call those AWS APIs, and provision that execution role in your
         *        account. CloudFormation then assumes that execution role to provide your resource type with the
         *        appropriate credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The scope at which the type is visible and usable in CloudFormation operations.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
         * Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        The scope at which the type is visible and usable in CloudFormation operations.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRIVATE</code>: The type is only visible and usable within the account in which it is
         *        registered. Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The scope at which the type is visible and usable in CloudFormation operations.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PRIVATE</code>: The type is only visible and usable within the account in which it is registered.
         * Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param visibility
         *        The scope at which the type is visible and usable in CloudFormation operations.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PRIVATE</code>: The type is only visible and usable within the account in which it is
         *        registered. Currently, AWS CloudFormation marks any types you register as <code>PRIVATE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PUBLIC</code>: The type is publically visible and usable within any Amazon account.
         *        </p>
         *        </li>
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The URL of the source code for the type.
         * </p>
         * 
         * @param sourceUrl
         *        The URL of the source code for the type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        /**
         * <p>
         * The URL of a page providing detailed documentation for this type.
         * </p>
         * 
         * @param documentationUrl
         *        The URL of a page providing detailed documentation for this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationUrl(String documentationUrl);

        /**
         * <p>
         * When the specified type version was registered.
         * </p>
         * 
         * @param lastUpdated
         *        When the specified type version was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * When the specified type version was registered.
         * </p>
         * 
         * @param timeCreated
         *        When the specified type version was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(Instant timeCreated);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String arn;

        private String type;

        private String typeName;

        private String defaultVersionId;

        private String description;

        private String schema;

        private String provisioningType;

        private String deprecatedStatus;

        private LoggingConfig loggingConfig;

        private String executionRoleArn;

        private String visibility;

        private String sourceUrl;

        private String documentationUrl;

        private Instant lastUpdated;

        private Instant timeCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeResponse model) {
            super(model);
            arn(model.arn);
            type(model.type);
            typeName(model.typeName);
            defaultVersionId(model.defaultVersionId);
            description(model.description);
            schema(model.schema);
            provisioningType(model.provisioningType);
            deprecatedStatus(model.deprecatedStatus);
            loggingConfig(model.loggingConfig);
            executionRoleArn(model.executionRoleArn);
            visibility(model.visibility);
            sourceUrl(model.sourceUrl);
            documentationUrl(model.documentationUrl);
            lastUpdated(model.lastUpdated);
            timeCreated(model.timeCreated);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getProvisioningType() {
            return provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        public final String getDeprecatedStatus() {
            return deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getVisibility() {
            return visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        public final String getDocumentationUrl() {
            return documentationUrl;
        }

        @Override
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Instant getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public DescribeTypeResponse build() {
            return new DescribeTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
