/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.cloudformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CfnRegistryException;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationException;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreatedButModifiedException;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.InsufficientCapabilitiesException;
import software.amazon.awssdk.services.cloudformation.model.InvalidChangeSetStatusException;
import software.amazon.awssdk.services.cloudformation.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudformation.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.cloudformation.model.LimitExceededException;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.NameAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationIdAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.OperationInProgressException;
import software.amazon.awssdk.services.cloudformation.model.OperationNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.OperationStatusCheckFailedException;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotEmptyException;
import software.amazon.awssdk.services.cloudformation.model.StackSetNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.StaleRequestException;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.TokenAlreadyExistsException;
import software.amazon.awssdk.services.cloudformation.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher;
import software.amazon.awssdk.services.cloudformation.transform.CancelUpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ContinueUpdateRollbackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.CreateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeleteStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DeregisterTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackDriftDetectionStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackInstanceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceDriftsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeTypeRegistrationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DescribeTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackResourceDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.DetectStackSetDriftRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.EstimateTemplateCostRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ExecuteChangeSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.GetTemplateSummaryRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListChangeSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetOperationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStackSetsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListStacksRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypeRegistrationsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypeVersionsRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RecordHandlerProgressRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RegisterTypeRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetStackPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SetTypeDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.SignalResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.StopStackSetOperationRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackInstancesRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateStackSetRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.UpdateTerminationProtectionRequestMarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ValidateTemplateRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CloudFormationAsyncClient}.
 *
 * @see CloudFormationAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudFormationAsyncClient implements CloudFormationAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudFormationAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFormationAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note>
     *
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelUpdateStack");

            HttpResponseHandler<CancelUpdateStackResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelUpdateStackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelUpdateStackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelUpdateStackRequest, CancelUpdateStackResponse>()
                            .withOperationName("CancelUpdateStack")
                            .withMarshaller(new CancelUpdateStackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelUpdateStackRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelUpdateStackRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelUpdateStackRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all
     * changes after a failed stack update. For example, you might have a stack that is rolling back to an old database
     * instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't know the database was
     * deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update
     * rollback to fail.
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ContinueUpdateRollback");

            HttpResponseHandler<ContinueUpdateRollbackResponse> responseHandler = protocolFactory
                    .createResponseHandler(ContinueUpdateRollbackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ContinueUpdateRollbackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ContinueUpdateRollbackRequest, ContinueUpdateRollbackResponse>()
                            .withOperationName("ContinueUpdateRollback")
                            .withMarshaller(new ContinueUpdateRollbackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(continueUpdateRollbackRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = continueUpdateRollbackRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, continueUpdateRollbackRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that AWS CloudFormation will create. If
     * you create a change set for an existing stack, AWS CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to understand which
     * resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before
     * you create or update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * AWS CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn't make changes until you execute the change set.
     * </p>
     *
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateChangeSetResponse> createChangeSet(CreateChangeSetRequest createChangeSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChangeSet");

            HttpResponseHandler<CreateChangeSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateChangeSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateChangeSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateChangeSetRequest, CreateChangeSetResponse>()
                            .withOperationName("CreateChangeSet")
                            .withMarshaller(new CreateChangeSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createChangeSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createChangeSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChangeSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     *
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStack");

            HttpResponseHandler<CreateStackResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateStackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateStackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStackRequest, CreateStackResponse>()
                            .withOperationName("CreateStack").withMarshaller(new CreateStackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStackRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStackRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a
     * stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or
     * <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.
     * </p>
     *
     * @param createStackInstancesRequest
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            CreateStackInstancesRequest createStackInstancesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStackInstances");

            HttpResponseHandler<CreateStackInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateStackInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateStackInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStackInstancesRequest, CreateStackInstancesResponse>()
                            .withOperationName("CreateStackInstances")
                            .withMarshaller(new CreateStackInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStackInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStackInstancesRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackInstancesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     *
     * @param createStackSetRequest
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStackSetResponse> createStackSet(CreateStackSetRequest createStackSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStackSet");

            HttpResponseHandler<CreateStackSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateStackSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateStackSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStackSetRequest, CreateStackSetResponse>()
                            .withOperationName("CreateStackSet")
                            .withMarshaller(new CreateStackSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStackSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStackSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStackSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, AWS CloudFormation successfully deleted the change set.
     * </p>
     *
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChangeSet");

            HttpResponseHandler<DeleteChangeSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteChangeSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteChangeSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteChangeSetRequest, DeleteChangeSetResponse>()
                            .withOperationName("DeleteChangeSet")
                            .withMarshaller(new DeleteChangeSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteChangeSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteChangeSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChangeSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     *
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStack");

            HttpResponseHandler<DeleteStackResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteStackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteStackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStackRequest, DeleteStackResponse>()
                            .withOperationName("DeleteStack").withMarshaller(new DeleteStackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStackRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStackRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Regions.
     * </p>
     *
     * @param deleteStackInstancesRequest
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            DeleteStackInstancesRequest deleteStackInstancesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStackInstances");

            HttpResponseHandler<DeleteStackInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteStackInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteStackInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStackInstancesRequest, DeleteStackInstancesResponse>()
                            .withOperationName("DeleteStackInstances")
                            .withMarshaller(new DeleteStackInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStackInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStackInstancesRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackInstancesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     *
     * @param deleteStackSetRequest
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this stack set, because it still contains one or more
     *         stack instances. Delete all stack instances from the stack set before deleting the stack set.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStackSetResponse> deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStackSet");

            HttpResponseHandler<DeleteStackSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteStackSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteStackSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStackSetRequest, DeleteStackSetResponse>()
                            .withOperationName("DeleteStackSet")
                            .withMarshaller(new DeleteStackSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStackSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStackSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStackSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a type or type version from active use in the CloudFormation registry. If a type or type version is
     * deregistered, it cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister a type, you must individually deregister all registered versions of that type. If a type has only a
     * single registered version, deregistering that version results in the type itself being deregistered.
     * </p>
     * <p>
     * You cannot deregister the default version of a type, unless it is the only registered version of that type, in
     * which case the type itself is deregistered as well.
     * </p>
     *
     * @param deregisterTypeRequest
     * @return A Java Future containing the result of the DeregisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeregisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterTypeResponse> deregisterType(DeregisterTypeRequest deregisterTypeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterType");

            HttpResponseHandler<DeregisterTypeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeregisterTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeregisterTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterTypeRequest, DeregisterTypeResponse>()
                            .withOperationName("DeregisterType")
                            .withMarshaller(new DeregisterTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterTypeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deregisterTypeRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountLimits");

            HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAccountLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                            .withOperationName("DescribeAccountLimits")
                            .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAccountLimitsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeAccountLimitsRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeAccountLimitsPublisher describeAccountLimitsPaginator(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        return new DescribeAccountLimitsPublisher(this, applyPaginatorUserAgent(describeAccountLimitsRequest));
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeChangeSetResponse> describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChangeSet");

            HttpResponseHandler<DescribeChangeSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeChangeSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeChangeSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeChangeSetRequest, DescribeChangeSetResponse>()
                            .withOperationName("DescribeChangeSet")
                            .withMarshaller(new DescribeChangeSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeChangeSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeChangeSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeChangeSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information on stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     * @return A Java Future containing the result of the DescribeStackDriftDetectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackDriftDetectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackDriftDetectionStatusResponse> describeStackDriftDetectionStatus(
            DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackDriftDetectionStatus");

            HttpResponseHandler<DescribeStackDriftDetectionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackDriftDetectionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackDriftDetectionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackDriftDetectionStatusRequest, DescribeStackDriftDetectionStatusResponse>()
                            .withOperationName("DescribeStackDriftDetectionStatus")
                            .withMarshaller(new DescribeStackDriftDetectionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackDriftDetectionStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackDriftDetectionStatusRequest
                    .overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    describeStackDriftDetectionStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            DescribeStackEventsRequest describeStackEventsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackEvents");

            HttpResponseHandler<DescribeStackEventsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackEventsRequest, DescribeStackEventsResponse>()
                            .withOperationName("DescribeStackEvents")
                            .withMarshaller(new DescribeStackEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackEventsRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackEventsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeStackEventsPublisher describeStackEventsPaginator(DescribeStackEventsRequest describeStackEventsRequest) {
        return new DescribeStackEventsPublisher(this, applyPaginatorUserAgent(describeStackEventsRequest));
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, AWS account, and Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     *
     * @param describeStackInstanceRequest
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            DescribeStackInstanceRequest describeStackInstanceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackInstance");

            HttpResponseHandler<DescribeStackInstanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackInstanceRequest, DescribeStackInstanceResponse>()
                            .withOperationName("DescribeStackInstance")
                            .withMarshaller(new DescribeStackInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackInstanceRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackInstanceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            DescribeStackResourceRequest describeStackResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackResource");

            HttpResponseHandler<DescribeStackResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackResourceRequest, DescribeStackResourceResponse>()
                            .withOperationName("DescribeStackResource")
                            .withMarshaller(new DescribeStackResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackResourceRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where AWS CloudFormation detects configuration
     * drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A Java Future containing the result of the DescribeStackResourceDrifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackResourceDriftsResponse> describeStackResourceDrifts(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackResourceDrifts");

            HttpResponseHandler<DescribeStackResourceDriftsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackResourceDriftsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackResourceDriftsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackResourceDriftsRequest, DescribeStackResourceDriftsResponse>()
                            .withOperationName("DescribeStackResourceDrifts")
                            .withMarshaller(new DescribeStackResourceDriftsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackResourceDriftsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackResourceDriftsRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    describeStackResourceDriftsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where AWS CloudFormation detects configuration
     * drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribeStackResourceDriftsPublisher describeStackResourceDriftsPaginator(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        return new DescribeStackResourceDriftsPublisher(this, applyPaginatorUserAgent(describeStackResourceDriftsRequest));
    }

    /**
     * <p>
     * Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the
     * associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified,
     * the associated resources of the stack that the resource belongs to are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     *
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            DescribeStackResourcesRequest describeStackResourcesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackResources");

            HttpResponseHandler<DescribeStackResourcesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackResourcesRequest, DescribeStackResourcesResponse>()
                            .withOperationName("DescribeStackResources")
                            .withMarshaller(new DescribeStackResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackResourcesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackResourcesRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackResourcesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     *
     * @param describeStackSetRequest
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackSetResponse> describeStackSet(DescribeStackSetRequest describeStackSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackSet");

            HttpResponseHandler<DescribeStackSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackSetRequest, DescribeStackSetResponse>()
                            .withOperationName("DescribeStackSet")
                            .withMarshaller(new DescribeStackSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStackSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     *
     * @param describeStackSetOperationRequest
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            DescribeStackSetOperationRequest describeStackSetOperationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStackSetOperation");

            HttpResponseHandler<DescribeStackSetOperationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStackSetOperationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStackSetOperationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStackSetOperationRequest, DescribeStackSetOperationResponse>()
                            .withOperationName("DescribeStackSetOperation")
                            .withMarshaller(new DescribeStackSetOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStackSetOperationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStackSetOperationRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    describeStackSetOperationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStacks");

            HttpResponseHandler<DescribeStacksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStacksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStacksRequest, DescribeStacksResponse>()
                            .withOperationName("DescribeStacks")
                            .withMarshaller(new DescribeStacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeStacksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeStacksRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStacksRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    public DescribeStacksPublisher describeStacksPaginator(DescribeStacksRequest describeStacksRequest) {
        return new DescribeStacksPublisher(this, applyPaginatorUserAgent(describeStacksRequest));
    }

    /**
     * <p>
     * Returns detailed information about a type that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific type
     * version. Otherwise, it returns information about the default type version.
     * </p>
     *
     * @param describeTypeRequest
     * @return A Java Future containing the result of the DescribeType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTypeResponse> describeType(DescribeTypeRequest describeTypeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeType");

            HttpResponseHandler<DescribeTypeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTypeRequest, DescribeTypeResponse>()
                            .withOperationName("DescribeType").withMarshaller(new DescribeTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTypeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTypeRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a type's registration, including its current status and type and version identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <code> <a>RegisterType</a> </code>, you can then use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <code> <a>DescribeType</a> </code> to return detailed
     * informaiton about a type.
     * </p>
     *
     * @param describeTypeRegistrationRequest
     * @return A Java Future containing the result of the DescribeTypeRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeTypeRegistration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTypeRegistrationResponse> describeTypeRegistration(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTypeRegistration");

            HttpResponseHandler<DescribeTypeRegistrationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTypeRegistrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTypeRegistrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTypeRegistrationRequest, DescribeTypeRegistrationResponse>()
                            .withOperationName("DescribeTypeRegistration")
                            .withMarshaller(new DescribeTypeRegistrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTypeRegistrationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTypeRegistrationRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTypeRegistrationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, AWS CloudFormation compares the actual configuration of the resource with its
     * expected template configuration. Only resource properties explicitly defined in the stack template are checked
     * for drift. A stack is considered to have drifted if one or more of its resources differ from their expected
     * template configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, AWS CloudFormation does not detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     *
     * @param detectStackDriftRequest
     * @return A Java Future containing the result of the DetectStackDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectStackDriftResponse> detectStackDrift(DetectStackDriftRequest detectStackDriftRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectStackDrift");

            HttpResponseHandler<DetectStackDriftResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetectStackDriftResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DetectStackDriftResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectStackDriftRequest, DetectStackDriftResponse>()
                            .withOperationName("DetectStackDrift")
                            .withMarshaller(new DetectStackDriftRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectStackDriftRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectStackDriftRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectStackDriftRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from it's
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which AWS CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that do not currently support drift detection cannot be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     *
     * @param detectStackResourceDriftRequest
     * @return A Java Future containing the result of the DetectStackResourceDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackResourceDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectStackResourceDriftResponse> detectStackResourceDrift(
            DetectStackResourceDriftRequest detectStackResourceDriftRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectStackResourceDrift");

            HttpResponseHandler<DetectStackResourceDriftResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetectStackResourceDriftResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DetectStackResourceDriftResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectStackResourceDriftRequest, DetectStackResourceDriftResponse>()
                            .withOperationName("DetectStackResourceDrift")
                            .withMarshaller(new DetectStackResourceDriftRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectStackResourceDriftRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectStackResourceDriftRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectStackResourceDriftRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation
     * Performs Drift Detection on a Stack Set</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the number of stack instances
     * included in the stack set, as well as the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackSet</a> </code> to return detailed informaiton about the stack set, including detailed
     * information about the last <i>completed</i> drift operation performed on the stack set. (Information about drift
     * operations that are in progress is not included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>ListStackInstances</a> </code> to return a list of stack instances belonging to the stack set,
     * including the drift status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackInstance</a> </code> to return detailed information about a specific stack instance,
     * including its drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on performing a drift detection operation on a stack set, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a>.
     * </p>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <code> <a>StopStackSetOperation</a> </code>.
     * </p>
     *
     * @param detectStackSetDriftRequest
     * @return A Java Future containing the result of the DetectStackSetDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackSetDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectStackSetDriftResponse> detectStackSetDrift(
            DetectStackSetDriftRequest detectStackSetDriftRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectStackSetDrift");

            HttpResponseHandler<DetectStackSetDriftResponse> responseHandler = protocolFactory
                    .createResponseHandler(DetectStackSetDriftResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DetectStackSetDriftResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectStackSetDriftRequest, DetectStackSetDriftResponse>()
                            .withOperationName("DetectStackSetDrift")
                            .withMarshaller(new DetectStackSetDriftRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectStackSetDriftRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectStackSetDriftRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectStackSetDriftRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a
     * query string that describes the resources required to run the template.
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            EstimateTemplateCostRequest estimateTemplateCostRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EstimateTemplateCost");

            HttpResponseHandler<EstimateTemplateCostResponse> responseHandler = protocolFactory
                    .createResponseHandler(EstimateTemplateCostResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<EstimateTemplateCostResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EstimateTemplateCostRequest, EstimateTemplateCostResponse>()
                            .withOperationName("EstimateTemplateCost")
                            .withMarshaller(new EstimateTemplateCostRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(estimateTemplateCostRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = estimateTemplateCostRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, estimateTemplateCostRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a>
     * action to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You
     * can't specify a temporary stack policy that overrides the current policy.
     * </p>
     *
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteChangeSet");

            HttpResponseHandler<ExecuteChangeSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(ExecuteChangeSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ExecuteChangeSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteChangeSetRequest, ExecuteChangeSetResponse>()
                            .withOperationName("ExecuteChangeSet")
                            .withMarshaller(new ExecuteChangeSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(executeChangeSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = executeChangeSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeChangeSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     *
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStackPolicyResponse> getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStackPolicy");

            HttpResponseHandler<GetStackPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetStackPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetStackPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStackPolicyRequest, GetStackPolicyResponse>()
                            .withOperationName("GetStackPolicy")
                            .withMarshaller(new GetStackPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStackPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStackPolicyRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStackPolicyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTemplateResponse> getTemplate(GetTemplateRequest getTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemplate");

            HttpResponseHandler<GetTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTemplateRequest, GetTemplateResponse>()
                            .withOperationName("GetTemplate").withMarshaller(new GetTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTemplateRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTemplateRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemplateSummary");

            HttpResponseHandler<GetTemplateSummaryResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetTemplateSummaryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetTemplateSummaryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTemplateSummaryRequest, GetTemplateSummaryResponse>()
                            .withOperationName("GetTemplateSummary")
                            .withMarshaller(new GetTemplateSummaryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTemplateSummaryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTemplateSummaryRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTemplateSummaryRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListChangeSetsResponse> listChangeSets(ListChangeSetsRequest listChangeSetsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChangeSets");

            HttpResponseHandler<ListChangeSetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListChangeSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListChangeSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListChangeSetsRequest, ListChangeSetsResponse>()
                            .withOperationName("ListChangeSets")
                            .withMarshaller(new ListChangeSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listChangeSetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listChangeSetsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChangeSetsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    public ListChangeSetsPublisher listChangeSetsPaginator(ListChangeSetsRequest listChangeSetsRequest) {
        return new ListChangeSetsPublisher(this, applyPaginatorUserAgent(listChangeSetsRequest));
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExports");

            HttpResponseHandler<ListExportsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListExportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListExportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListExportsRequest, ListExportsResponse>()
                            .withOperationName("ListExports").withMarshaller(new ListExportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listExportsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listExportsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    public ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, applyPaginatorUserAgent(listExportsRequest));
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");

            HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListImportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListImportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                            .withOperationName("ListImports").withMarshaller(new ListImportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listImportsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listImportsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    public ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, applyPaginatorUserAgent(listImportsRequest));
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or Region, or that have a
     * specific status.
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStackInstancesResponse> listStackInstances(ListStackInstancesRequest listStackInstancesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackInstances");

            HttpResponseHandler<ListStackInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListStackInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListStackInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStackInstancesRequest, ListStackInstancesResponse>()
                            .withOperationName("ListStackInstances")
                            .withMarshaller(new ListStackInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStackInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStackInstancesRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackInstancesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or Region, or that have a
     * specific status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    public ListStackInstancesPublisher listStackInstancesPaginator(ListStackInstancesRequest listStackInstancesRequest) {
        return new ListStackInstancesPublisher(this, applyPaginatorUserAgent(listStackInstancesRequest));
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStackResourcesResponse> listStackResources(ListStackResourcesRequest listStackResourcesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackResources");

            HttpResponseHandler<ListStackResourcesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListStackResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListStackResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStackResourcesRequest, ListStackResourcesResponse>()
                            .withOperationName("ListStackResources")
                            .withMarshaller(new ListStackResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStackResourcesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStackResourcesRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackResourcesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    public ListStackResourcesPublisher listStackResourcesPaginator(ListStackResourcesRequest listStackResourcesRequest) {
        return new ListStackResourcesPublisher(this, applyPaginatorUserAgent(listStackResourcesRequest));
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSetOperationResults");

            HttpResponseHandler<ListStackSetOperationResultsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListStackSetOperationResultsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListStackSetOperationResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStackSetOperationResultsRequest, ListStackSetOperationResultsResponse>()
                            .withOperationName("ListStackSetOperationResults")
                            .withMarshaller(new ListStackSetOperationResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStackSetOperationResultsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStackSetOperationResultsRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    listStackSetOperationResultsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    public ListStackSetOperationResultsPublisher listStackSetOperationResultsPaginator(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        return new ListStackSetOperationResultsPublisher(this, applyPaginatorUserAgent(listStackSetOperationResultsRequest));
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSetOperations");

            HttpResponseHandler<ListStackSetOperationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListStackSetOperationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListStackSetOperationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStackSetOperationsRequest, ListStackSetOperationsResponse>()
                            .withOperationName("ListStackSetOperations")
                            .withMarshaller(new ListStackSetOperationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStackSetOperationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStackSetOperationsRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackSetOperationsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListStackSetOperationsPublisher listStackSetOperationsPaginator(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        return new ListStackSetOperationsPublisher(this, applyPaginatorUserAgent(listStackSetOperationsRequest));
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     *
     * @param listStackSetsRequest
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStackSetsResponse> listStackSets(ListStackSetsRequest listStackSetsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackSets");

            HttpResponseHandler<ListStackSetsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListStackSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListStackSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStackSetsRequest, ListStackSetsResponse>()
                            .withOperationName("ListStackSets")
                            .withMarshaller(new ListStackSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStackSetsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStackSetsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStackSetsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @param listStackSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    public ListStackSetsPublisher listStackSetsPaginator(ListStackSetsRequest listStackSetsRequest) {
        return new ListStackSetsPublisher(this, applyPaginatorUserAgent(listStackSetsRequest));
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListStacksResponse> listStacks(ListStacksRequest listStacksRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStacks");

            HttpResponseHandler<ListStacksResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListStacksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListStacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStacksRequest, ListStacksResponse>().withOperationName("ListStacks")
                            .withMarshaller(new ListStacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStacksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStacksRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStacksRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    public ListStacksPublisher listStacksPaginator(ListStacksRequest listStacksRequest) {
        return new ListStacksPublisher(this, applyPaginatorUserAgent(listStacksRequest));
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified type(s).
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A Java Future containing the result of the ListTypeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTypeRegistrationsResponse> listTypeRegistrations(
            ListTypeRegistrationsRequest listTypeRegistrationsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypeRegistrations");

            HttpResponseHandler<ListTypeRegistrationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTypeRegistrationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListTypeRegistrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTypeRegistrationsRequest, ListTypeRegistrationsResponse>()
                            .withOperationName("ListTypeRegistrations")
                            .withMarshaller(new ListTypeRegistrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTypeRegistrationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTypeRegistrationsRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypeRegistrationsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified type(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTypeRegistrationsPublisher listTypeRegistrationsPaginator(ListTypeRegistrationsRequest listTypeRegistrationsRequest) {
        return new ListTypeRegistrationsPublisher(this, applyPaginatorUserAgent(listTypeRegistrationsRequest));
    }

    /**
     * <p>
     * Returns summary information about the versions of a type.
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A Java Future containing the result of the ListTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTypeVersionsResponse> listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypeVersions");

            HttpResponseHandler<ListTypeVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTypeVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListTypeVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTypeVersionsRequest, ListTypeVersionsResponse>()
                            .withOperationName("ListTypeVersions")
                            .withMarshaller(new ListTypeVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTypeVersionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTypeVersionsRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypeVersionsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summary information about the versions of a type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTypeVersionsPublisher listTypeVersionsPaginator(ListTypeVersionsRequest listTypeVersionsRequest) {
        return new ListTypeVersionsPublisher(this, applyPaginatorUserAgent(listTypeVersionsRequest));
    }

    /**
     * <p>
     * Returns summary information about types that have been registered with CloudFormation.
     * </p>
     *
     * @param listTypesRequest
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTypesResponse> listTypes(ListTypesRequest listTypesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypes");

            HttpResponseHandler<ListTypesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTypesRequest, ListTypesResponse>().withOperationName("ListTypes")
                            .withMarshaller(new ListTypesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTypesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTypesRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summary information about types that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     *
     * @param listTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    public ListTypesPublisher listTypesPaginator(ListTypesRequest listTypesRequest) {
        return new ListTypesPublisher(this, applyPaginatorUserAgent(listTypesRequest));
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Do not use this API in your code.
     * </p>
     *
     * @param recordHandlerProgressRequest
     * @return A Java Future containing the result of the RecordHandlerProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidStateTransitionException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.</li>
     *         <li>OperationStatusCheckFailedException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RecordHandlerProgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RecordHandlerProgressResponse> recordHandlerProgress(
            RecordHandlerProgressRequest recordHandlerProgressRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RecordHandlerProgress");

            HttpResponseHandler<RecordHandlerProgressResponse> responseHandler = protocolFactory
                    .createResponseHandler(RecordHandlerProgressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RecordHandlerProgressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RecordHandlerProgressRequest, RecordHandlerProgressResponse>()
                            .withOperationName("RecordHandlerProgress")
                            .withMarshaller(new RecordHandlerProgressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(recordHandlerProgressRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = recordHandlerProgressRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, recordHandlerProgressRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a type with the CloudFormation service. Registering a type makes it available for use in CloudFormation
     * templates in your AWS account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the resource schema
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers have been specified for the resource
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the resource type available for use in your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to develop types and ready them for registeration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource type versions registered at a time. This maximum is per account and per
     * region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to
     * deregister specific resource type versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <code> <a>RegisterType</a> </code>, you can use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of the registration request.
     * </p>
     *
     * @param registerTypeRequest
     * @return A Java Future containing the result of the RegisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterTypeResponse> registerType(RegisterTypeRequest registerTypeRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterType");

            HttpResponseHandler<RegisterTypeResponse> responseHandler = protocolFactory
                    .createResponseHandler(RegisterTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RegisterTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterTypeRequest, RegisterTypeResponse>()
                            .withOperationName("RegisterType").withMarshaller(new RegisterTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerTypeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerTypeRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     *
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SetStackPolicyResponse> setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetStackPolicy");

            HttpResponseHandler<SetStackPolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetStackPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetStackPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetStackPolicyRequest, SetStackPolicyResponse>()
                            .withOperationName("SetStackPolicy")
                            .withMarshaller(new SetStackPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(setStackPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = setStackPolicyRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setStackPolicyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specify the default version of a type. The default version of a type will be used in CloudFormation operations.
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     * @return A Java Future containing the result of the SetTypeDefaultVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SetTypeDefaultVersionResponse> setTypeDefaultVersion(
            SetTypeDefaultVersionRequest setTypeDefaultVersionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTypeDefaultVersion");

            HttpResponseHandler<SetTypeDefaultVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(SetTypeDefaultVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SetTypeDefaultVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetTypeDefaultVersionRequest, SetTypeDefaultVersionResponse>()
                            .withOperationName("SetTypeDefaultVersion")
                            .withMarshaller(new SetTypeDefaultVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(setTypeDefaultVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = setTypeDefaultVersionRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setTypeDefaultVersionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. AWS CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     *
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SignalResourceResponse> signalResource(SignalResourceRequest signalResourceRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SignalResource");

            HttpResponseHandler<SignalResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(SignalResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<SignalResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SignalResourceRequest, SignalResourceResponse>()
                            .withOperationName("SignalResource")
                            .withMarshaller(new SignalResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(signalResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = signalResourceRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, signalResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     *
     * @param stopStackSetOperationRequest
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            StopStackSetOperationRequest stopStackSetOperationRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStackSetOperation");

            HttpResponseHandler<StopStackSetOperationResponse> responseHandler = protocolFactory
                    .createResponseHandler(StopStackSetOperationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<StopStackSetOperationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopStackSetOperationRequest, StopStackSetOperationResponse>()
                            .withOperationName("StopStackSetOperation")
                            .withMarshaller(new StopStackSetOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopStackSetOperationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopStackSetOperationRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopStackSetOperationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     *
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStack");

            HttpResponseHandler<UpdateStackResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateStackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateStackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStackRequest, UpdateStackResponse>()
                            .withOperationName("UpdateStack").withMarshaller(new UpdateStackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStackRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateStackRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A
     * stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Regions and accounts where they already exist; to create additional stack
     * instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance are not updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     *
     * @param updateStackInstancesRequest
     * @return A Java Future containing the result of the UpdateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStackInstancesResponse> updateStackInstances(
            UpdateStackInstancesRequest updateStackInstancesRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStackInstances");

            HttpResponseHandler<UpdateStackInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateStackInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateStackInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStackInstancesRequest, UpdateStackInstancesResponse>()
                            .withOperationName("UpdateStackInstances")
                            .withMarshaller(new UpdateStackInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStackInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateStackInstancesRequest.overrideConfiguration().orElse(
                    null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackInstancesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the stack set, and associated stack instances in the specified accounts and Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     *
     * @param updateStackSetRequest
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStackSetResponse> updateStackSet(UpdateStackSetRequest updateStackSetRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStackSet");

            HttpResponseHandler<UpdateStackSetResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateStackSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateStackSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStackSetRequest, UpdateStackSetResponse>()
                            .withOperationName("UpdateStackSet")
                            .withMarshaller(new UpdateStackSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStackSetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateStackSetRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStackSetRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     *
     * @param updateTerminationProtectionRequest
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTerminationProtection");

            HttpResponseHandler<UpdateTerminationProtectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdateTerminationProtectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdateTerminationProtectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTerminationProtectionRequest, UpdateTerminationProtectionResponse>()
                            .withOperationName("UpdateTerminationProtection")
                            .withMarshaller(new UpdateTerminationProtectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTerminationProtectionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTerminationProtectionRequest.overrideConfiguration()
                    .orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                    updateTerminationProtectionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn't, AWS
     * CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a
     * template validation error.
     * </p>
     *
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ValidateTemplateResponse> validateTemplate(ValidateTemplateRequest validateTemplateRequest) {
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ValidateTemplate");

            HttpResponseHandler<ValidateTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(ValidateTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ValidateTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ValidateTemplateRequest, ValidateTemplateResponse>()
                            .withOperationName("ValidateTemplate")
                            .withMarshaller(new ValidateTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(validateTemplateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = validateTemplateRequest.overrideConfiguration().orElse(null);
            executeFuture.whenComplete((r, e) -> {
                List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestOverrideConfig);
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return executeFuture;
        } catch (Throwable t) {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, validateTemplateRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOperationException")
                                .exceptionBuilderSupplier(InvalidOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TokenAlreadyExistsException")
                                .exceptionBuilderSupplier(TokenAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CFNRegistryException")
                                .exceptionBuilderSupplier(CfnRegistryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConditionalCheckFailed")
                                .exceptionBuilderSupplier(OperationStatusCheckFailedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameAlreadyExistsException")
                                .exceptionBuilderSupplier(NameAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotFoundException")
                                .exceptionBuilderSupplier(OperationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackSetNotFoundException")
                                .exceptionBuilderSupplier(StackSetNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCapabilitiesException")
                                .exceptionBuilderSupplier(InsufficientCapabilitiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationInProgressException")
                                .exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StaleRequestException")
                                .exceptionBuilderSupplier(StaleRequestException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidChangeSetStatus")
                                .exceptionBuilderSupplier(InvalidChangeSetStatusException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackSetNotEmptyException")
                                .exceptionBuilderSupplier(StackSetNotEmptyException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ChangeSetNotFound")
                                .exceptionBuilderSupplier(ChangeSetNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StackInstanceNotFoundException")
                                .exceptionBuilderSupplier(StackInstanceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateTransition")
                                .exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationIdAlreadyExistsException")
                                .exceptionBuilderSupplier(OperationIdAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TypeNotFoundException")
                                .exceptionBuilderSupplier(TypeNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreatedButModifiedException")
                                .exceptionBuilderSupplier(CreatedButModifiedException::builder).httpStatusCode(409).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(CloudFormationException::builder)
                .build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CloudFormationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
