/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CancelUpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackRequest;
import software.amazon.awssdk.services.cloudformation.model.ContinueUpdateRollbackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.CreateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackResponse;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DeregisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackResourceDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftRequest;
import software.amazon.awssdk.services.cloudformation.model.DetectStackSetDriftResponse;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostResponse;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.GetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateResponse;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryRequest;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest;
import software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressResponse;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeRequest;
import software.amazon.awssdk.services.cloudformation.model.RegisterTypeResponse;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyRequest;
import software.amazon.awssdk.services.cloudformation.model.SetStackPolicyResponse;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionRequest;
import software.amazon.awssdk.services.cloudformation.model.SetTypeDefaultVersionResponse;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceResponse;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetResponse;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionRequest;
import software.amazon.awssdk.services.cloudformation.model.UpdateTerminationProtectionResponse;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateRequest;
import software.amazon.awssdk.services.cloudformation.model.ValidateTemplateResponse;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher;
import software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher;

/**
 * Service client for accessing AWS CloudFormation asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS CloudFormation</fullname>
 * <p>
 * AWS CloudFormation allows you to create and manage AWS infrastructure deployments predictably and repeatedly. You can
 * use AWS CloudFormation to leverage AWS products, such as Amazon Elastic Compute Cloud, Amazon Elastic Block Store,
 * Amazon Simple Notification Service, Elastic Load Balancing, and Auto Scaling to build highly-reliable, highly
 * scalable, cost-effective applications without creating or configuring the underlying AWS infrastructure.
 * </p>
 * <p>
 * With AWS CloudFormation, you declare all of your resources and dependencies in a template file. The template defines
 * a collection of resources as a single unit called a stack. AWS CloudFormation creates and deletes all member
 * resources of the stack together and manages all dependencies between the resources for you.
 * </p>
 * <p>
 * For more information about AWS CloudFormation, see the <a href="http://aws.amazon.com/cloudformation/">AWS
 * CloudFormation Product Page</a>.
 * </p>
 * <p>
 * Amazon CloudFormation makes use of other AWS products. If you need additional technical information about a specific
 * AWS product, you can find the product's technical documentation at <a
 * href="https://docs.aws.amazon.com/">docs.aws.amazon.com</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CloudFormationAsyncClient extends SdkClient {
    String SERVICE_NAME = "cloudformation";

    /**
     * Create a {@link CloudFormationAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFormationAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFormationAsyncClient}.
     */
    static CloudFormationAsyncClientBuilder builder() {
        return new DefaultCloudFormationAsyncClientBuilder();
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note>
     *
     * @param cancelUpdateStackRequest
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and
     * reverts to the previous stack configuration.
     * </p>
     * <note>
     * <p>
     * You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelUpdateStackRequest.Builder} avoiding the need
     * to create one manually via {@link CancelUpdateStackRequest#builder()}
     * </p>
     *
     * @param cancelUpdateStackRequest
     *        A {@link Consumer} that will call methods on {@link CancelUpdateStackInput.Builder} to create a request.
     *        The input for the <a>CancelUpdateStack</a> action.
     * @return A Java Future containing the result of the CancelUpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CancelUpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelUpdateStackResponse> cancelUpdateStack(
            Consumer<CancelUpdateStackRequest.Builder> cancelUpdateStackRequest) {
        return cancelUpdateStack(CancelUpdateStackRequest.builder().applyMutation(cancelUpdateStackRequest).build());
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all
     * changes after a failed stack update. For example, you might have a stack that is rolling back to an old database
     * instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't know the database was
     * deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update
     * rollback to fail.
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        The input for the <a>ContinueUpdateRollback</a> action.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state, continues rolling it back to the
     * <code>UPDATE_ROLLBACK_COMPLETE</code> state. Depending on the cause of the failure, you can manually <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed"
     * > fix the error</a> and continue the rollback. By continuing the rollback, you can return your stack to a working
     * state (the <code>UPDATE_ROLLBACK_COMPLETE</code> state), and then try to update the stack again.
     * </p>
     * <p>
     * A stack goes into the <code>UPDATE_ROLLBACK_FAILED</code> state when AWS CloudFormation cannot roll back all
     * changes after a failed stack update. For example, you might have a stack that is rolling back to an old database
     * instance that was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't know the database was
     * deleted, it assumes that the database instance still exists and attempts to roll back to it, causing the update
     * rollback to fail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ContinueUpdateRollbackRequest.Builder} avoiding the
     * need to create one manually via {@link ContinueUpdateRollbackRequest#builder()}
     * </p>
     *
     * @param continueUpdateRollbackRequest
     *        A {@link Consumer} that will call methods on {@link ContinueUpdateRollbackInput.Builder} to create a
     *        request. The input for the <a>ContinueUpdateRollback</a> action.
     * @return A Java Future containing the result of the ContinueUpdateRollback operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ContinueUpdateRollback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ContinueUpdateRollbackResponse> continueUpdateRollback(
            Consumer<ContinueUpdateRollbackRequest.Builder> continueUpdateRollbackRequest) {
        return continueUpdateRollback(ContinueUpdateRollbackRequest.builder().applyMutation(continueUpdateRollbackRequest)
                .build());
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that AWS CloudFormation will create. If
     * you create a change set for an existing stack, AWS CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to understand which
     * resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before
     * you create or update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * AWS CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn't make changes until you execute the change set.
     * </p>
     *
     * @param createChangeSetRequest
     *        The input for the <a>CreateChangeSet</a> action.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChangeSetResponse> createChangeSet(CreateChangeSetRequest createChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a list of changes that will be applied to a stack so that you can review the changes before executing
     * them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set
     * for a stack that doesn't exist, the change set shows all of the resources that AWS CloudFormation will create. If
     * you create a change set for an existing stack, AWS CloudFormation compares the stack's information with the
     * information that you submit in the change set and lists the differences. Use change sets to understand which
     * resources AWS CloudFormation will create or change, and how it will change resources in an existing stack, before
     * you create or update a stack.
     * </p>
     * <p>
     * To create a change set for a stack that doesn't exist, for the <code>ChangeSetType</code> parameter, specify
     * <code>CREATE</code>. To create a change set for an existing stack, specify <code>UPDATE</code> for the
     * <code>ChangeSetType</code> parameter. To create a change set for an import operation, specify <code>IMPORT</code>
     * for the <code>ChangeSetType</code> parameter. After the <code>CreateChangeSet</code> call successfully completes,
     * AWS CloudFormation starts creating the change set. To check the status of the change set or to review it, use the
     * <a>DescribeChangeSet</a> action.
     * </p>
     * <p>
     * When you are satisfied with the changes the change set will make, execute the change set by using the
     * <a>ExecuteChangeSet</a> action. AWS CloudFormation doesn't make changes until you execute the change set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateChangeSetRequest#builder()}
     * </p>
     *
     * @param createChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateChangeSetInput.Builder} to create a request. The
     *        input for the <a>CreateChangeSet</a> action.
     * @return A Java Future containing the result of the CreateChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateChangeSetResponse> createChangeSet(
            Consumer<CreateChangeSetRequest.Builder> createChangeSetRequest) {
        return createChangeSet(CreateChangeSetRequest.builder().applyMutation(createChangeSetRequest).build());
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     *
     * @param createStackRequest
     *        The input for <a>CreateStack</a> action.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(CreateStackRequest createStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack as specified in the template. After the call completes successfully, the stack creation starts.
     * You can check the status of the stack via the <a>DescribeStacks</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     * </p>
     *
     * @param createStackRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackInput.Builder} to create a request. The
     *        input for <a>CreateStack</a> action.
     * @return A Java Future containing the result of the CreateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>AlreadyExistsException The resource with the name requested already exists.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStackResponse> createStack(Consumer<CreateStackRequest.Builder> createStackRequest) {
        return createStack(CreateStackRequest.builder().applyMutation(createStackRequest).build());
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a
     * stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or
     * <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.
     * </p>
     *
     * @param createStackInstancesRequest
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            CreateStackInstancesRequest createStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a
     * stack in a specific account and Region. You must specify at least one value for either <code>Accounts</code> or
     * <code>DeploymentTargets</code>, and you must specify at least one value for <code>Regions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStackInstancesRequest#builder()}
     * </p>
     *
     * @param createStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackInstancesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStackInstancesResponse> createStackInstances(
            Consumer<CreateStackInstancesRequest.Builder> createStackInstancesRequest) {
        return createStackInstances(CreateStackInstancesRequest.builder().applyMutation(createStackInstancesRequest).build());
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     *
     * @param createStackSetRequest
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackSetResponse> createStackSet(CreateStackSetRequest createStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackSetRequest#builder()}
     * </p>
     *
     * @param createStackSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackSetInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NameAlreadyExistsException The specified name is already in use.</li>
     *         <li>CreatedButModifiedException The specified resource exists, but has been changed.</li>
     *         <li>LimitExceededException The quota for the resource has already been reached.</p>
     *         <p>
     *         For information on resource and stack limitations, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html"
     *         >Limits</a> in the <i>AWS CloudFormation User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.CreateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStackSetResponse> createStackSet(Consumer<CreateStackSetRequest.Builder> createStackSetRequest) {
        return createStackSet(CreateStackSetRequest.builder().applyMutation(createStackSetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, AWS CloudFormation successfully deleted the change set.
     * </p>
     *
     * @param deleteChangeSetRequest
     *        The input for the <a>DeleteChangeSet</a> action.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(DeleteChangeSetRequest deleteChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set.
     * </p>
     * <p>
     * If the call successfully completes, AWS CloudFormation successfully deleted the change set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteChangeSetRequest#builder()}
     * </p>
     *
     * @param deleteChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChangeSetInput.Builder} to create a request. The
     *        input for the <a>DeleteChangeSet</a> action.
     * @return A Java Future containing the result of the DeleteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteChangeSetResponse> deleteChangeSet(
            Consumer<DeleteChangeSetRequest.Builder> deleteChangeSetRequest) {
        return deleteChangeSet(DeleteChangeSetRequest.builder().applyMutation(deleteChangeSetRequest).build());
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     *
     * @param deleteStackRequest
     *        The input for <a>DeleteStack</a> action.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(DeleteStackRequest deleteStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified stack. Once the call completes successfully, stack deletion starts. Deleted stacks do not
     * show up in the <a>DescribeStacks</a> API if the deletion has been completed successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     * </p>
     *
     * @param deleteStackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackInput.Builder} to create a request. The
     *        input for <a>DeleteStack</a> action.
     * @return A Java Future containing the result of the DeleteStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStackResponse> deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest) {
        return deleteStack(DeleteStackRequest.builder().applyMutation(deleteStackRequest).build());
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Regions.
     * </p>
     *
     * @param deleteStackInstancesRequest
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            DeleteStackInstancesRequest deleteStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes stack instances for the specified accounts, in the specified Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteStackInstancesRequest#builder()}
     * </p>
     *
     * @param deleteStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackInstancesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStackInstancesResponse> deleteStackInstances(
            Consumer<DeleteStackInstancesRequest.Builder> deleteStackInstancesRequest) {
        return deleteStackInstances(DeleteStackInstancesRequest.builder().applyMutation(deleteStackInstancesRequest).build());
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     *
     * @param deleteStackSetRequest
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this stack set, because it still contains one or more
     *         stack instances. Delete all stack instances from the stack set before deleting the stack set.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackSetResponse> deleteStackSet(DeleteStackSetRequest deleteStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stack set. Before you can delete a stack set, all of its member stack instances must be deleted. For
     * more information about how to do this, see <a>DeleteStackInstances</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackSetRequest#builder()}
     * </p>
     *
     * @param deleteStackSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackSetInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotEmptyException You can't yet delete this stack set, because it still contains one or more
     *         stack instances. Delete all stack instances from the stack set before deleting the stack set.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeleteStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStackSetResponse> deleteStackSet(Consumer<DeleteStackSetRequest.Builder> deleteStackSetRequest) {
        return deleteStackSet(DeleteStackSetRequest.builder().applyMutation(deleteStackSetRequest).build());
    }

    /**
     * <p>
     * Removes a type or type version from active use in the CloudFormation registry. If a type or type version is
     * deregistered, it cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister a type, you must individually deregister all registered versions of that type. If a type has only a
     * single registered version, deregistering that version results in the type itself being deregistered.
     * </p>
     * <p>
     * You cannot deregister the default version of a type, unless it is the only registered version of that type, in
     * which case the type itself is deregistered as well.
     * </p>
     *
     * @param deregisterTypeRequest
     * @return A Java Future containing the result of the DeregisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeregisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTypeResponse> deregisterType(DeregisterTypeRequest deregisterTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a type or type version from active use in the CloudFormation registry. If a type or type version is
     * deregistered, it cannot be used in CloudFormation operations.
     * </p>
     * <p>
     * To deregister a type, you must individually deregister all registered versions of that type. If a type has only a
     * single registered version, deregistering that version results in the type itself being deregistered.
     * </p>
     * <p>
     * You cannot deregister the default version of a type, unless it is the only registered version of that type, in
     * which case the type itself is deregistered as well.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeregisterTypeRequest#builder()}
     * </p>
     *
     * @param deregisterTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTypeInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeregisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DeregisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeregisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTypeResponse> deregisterType(Consumer<DeregisterTypeRequest.Builder> deregisterTypeRequest) {
        return deregisterType(DeregisterTypeRequest.builder().applyMutation(deregisterTypeRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountLimitsInput.Builder} to create a
     *        request. The input for the <a>DescribeAccountLimits</a> action.
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest).build());
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountLimitsResponse> describeAccountLimits() {
        return describeAccountLimits(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator() {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves your account's AWS CloudFormation limits, such as the maximum number of stacks that you can create in
     * your account. For more information about account limits, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html">AWS
     * CloudFormation Limits</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeAccountLimitsPublisher publisher = client.describeAccountLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.cloudformation.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountLimitsRequest#builder()}
     * </p>
     *
     * @param describeAccountLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountLimitsInput.Builder} to create a
     *        request. The input for the <a>DescribeAccountLimits</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsPublisher describeAccountLimitsPaginator(
            Consumer<DescribeAccountLimitsRequest.Builder> describeAccountLimitsRequest) {
        return describeAccountLimitsPaginator(DescribeAccountLimitsRequest.builder().applyMutation(describeAccountLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.
     * </p>
     *
     * @param describeChangeSetRequest
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the inputs for the change set and a list of changes that AWS CloudFormation will make if you execute the
     * change set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html"
     * >Updating Stacks Using Change Sets</a> in the AWS CloudFormation User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChangeSetRequest#builder()}
     * </p>
     *
     * @param describeChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChangeSetInput.Builder} to create a request.
     *        The input for the <a>DescribeChangeSet</a> action.
     * @return A Java Future containing the result of the DescribeChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChangeSetResponse> describeChangeSet(
            Consumer<DescribeChangeSetRequest.Builder> describeChangeSetRequest) {
        return describeChangeSet(DescribeChangeSetRequest.builder().applyMutation(describeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information on stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     * @return A Java Future containing the result of the DescribeStackDriftDetectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackDriftDetectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackDriftDetectionStatusResponse> describeStackDriftDetectionStatus(
            DescribeStackDriftDetectionStatusRequest describeStackDriftDetectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a stack drift detection operation. A stack drift detection operation detects whether a
     * stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration, as defined in the
     * stack template and any values specified as template parameters. A stack is considered to have drifted if one or
     * more of its resources have drifted. For more information on stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <a>DetectStackDrift</a> to initiate a stack drift detection operation. <code>DetectStackDrift</code> returns
     * a <code>StackDriftDetectionId</code> you can use to monitor the progress of the operation using
     * <code>DescribeStackDriftDetectionStatus</code>. Once the drift detection operation has completed, use
     * <a>DescribeStackResourceDrifts</a> to return drift information about the stack and its resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackDriftDetectionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackDriftDetectionStatusRequest#builder()}
     * </p>
     *
     * @param describeStackDriftDetectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackDriftDetectionStatusInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStackDriftDetectionStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackDriftDetectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackDriftDetectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackDriftDetectionStatusResponse> describeStackDriftDetectionStatus(
            Consumer<DescribeStackDriftDetectionStatusRequest.Builder> describeStackDriftDetectionStatusRequest) {
        return describeStackDriftDetectionStatus(DescribeStackDriftDetectionStatusRequest.builder()
                .applyMutation(describeStackDriftDetectionStatusRequest).build());
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            DescribeStackEventsRequest describeStackEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     * </p>
     *
     * @param describeStackEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackEventsInput.Builder} to create a request.
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A Java Future containing the result of the DescribeStackEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackEventsResponse> describeStackEvents(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) {
        return describeStackEvents(DescribeStackEventsRequest.builder().applyMutation(describeStackEventsRequest).build());
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackEventsRequest
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsPublisher describeStackEventsPaginator(DescribeStackEventsRequest describeStackEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all stack related events for a specified stack in reverse chronological order. For more information about
     * a stack's event history, go to <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html">Stacks</a> in the AWS
     * CloudFormation User Guide.
     * </p>
     * <note>
     * <p>
     * You can list events for stacks that have failed to create or have been deleted by specifying the unique stack
     * identifier (stack ID).
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackEventsPublisher publisher = client.describeStackEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackEvents(software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackEventsRequest#builder()}
     * </p>
     *
     * @param describeStackEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackEventsInput.Builder} to create a request.
     *        The input for <a>DescribeStackEvents</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackEventsPublisher describeStackEventsPaginator(
            Consumer<DescribeStackEventsRequest.Builder> describeStackEventsRequest) {
        return describeStackEventsPaginator(DescribeStackEventsRequest.builder().applyMutation(describeStackEventsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, AWS account, and Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     *
     * @param describeStackInstanceRequest
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            DescribeStackInstanceRequest describeStackInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack instance that's associated with the specified stack set, AWS account, and Region.
     * </p>
     * <p>
     * For a list of stack instances that are associated with a specific stack set, use <a>ListStackInstances</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackInstanceRequest#builder()}
     * </p>
     *
     * @param describeStackInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackInstanceInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStackInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackInstanceResponse> describeStackInstance(
            Consumer<DescribeStackInstanceRequest.Builder> describeStackInstanceRequest) {
        return describeStackInstance(DescribeStackInstanceRequest.builder().applyMutation(describeStackInstanceRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param describeStackResourceRequest
     *        The input for <a>DescribeStackResource</a> action.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            DescribeStackResourceRequest describeStackResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified resource in the specified stack.
     * </p>
     * <p>
     * For deleted stacks, DescribeStackResource returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourceRequest#builder()}
     * </p>
     *
     * @param describeStackResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourceInput.Builder} to create a
     *        request. The input for <a>DescribeStackResource</a> action.
     * @return A Java Future containing the result of the DescribeStackResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceResponse> describeStackResource(
            Consumer<DescribeStackResourceRequest.Builder> describeStackResourceRequest) {
        return describeStackResource(DescribeStackResourceRequest.builder().applyMutation(describeStackResourceRequest).build());
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where AWS CloudFormation detects configuration
     * drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A Java Future containing the result of the DescribeStackResourceDrifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceDriftsResponse> describeStackResourceDrifts(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where AWS CloudFormation detects configuration
     * drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackResourceDriftsRequest#builder()}
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourceDriftsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStackResourceDrifts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourceDriftsResponse> describeStackResourceDrifts(
            Consumer<DescribeStackResourceDriftsRequest.Builder> describeStackResourceDriftsRequest) {
        return describeStackResourceDrifts(DescribeStackResourceDriftsRequest.builder()
                .applyMutation(describeStackResourceDriftsRequest).build());
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where AWS CloudFormation detects configuration
     * drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsPublisher describeStackResourceDriftsPaginator(
            DescribeStackResourceDriftsRequest describeStackResourceDriftsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns drift information for the resources that have been checked for drift in the specified stack. This
     * includes actual and expected configuration values for resources where AWS CloudFormation detects configuration
     * drift.
     * </p>
     * <p>
     * For a given stack, there will be one <code>StackResourceDrift</code> for each stack resource that has been
     * checked for drift. Resources that have not yet been checked for drift are not included. Resources that do not
     * currently support drift detection are not checked, and so not included. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * Use <a>DetectStackResourceDrift</a> to detect drift on individual resources, or <a>DetectStackDrift</a> to detect
     * drift on all supported resources for a given stack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStackResourceDriftsPublisher publisher = client.describeStackResourceDriftsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStackResourceDrifts(software.amazon.awssdk.services.cloudformation.model.DescribeStackResourceDriftsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourceDriftsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStackResourceDriftsRequest#builder()}
     * </p>
     *
     * @param describeStackResourceDriftsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourceDriftsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResourceDrifts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStackResourceDriftsPublisher describeStackResourceDriftsPaginator(
            Consumer<DescribeStackResourceDriftsRequest.Builder> describeStackResourceDriftsRequest) {
        return describeStackResourceDriftsPaginator(DescribeStackResourceDriftsRequest.builder()
                .applyMutation(describeStackResourceDriftsRequest).build());
    }

    /**
     * <p>
     * Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the
     * associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified,
     * the associated resources of the stack that the resource belongs to are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note>
     *
     * @param describeStackResourcesRequest
     *        The input for <a>DescribeStackResources</a> action.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            DescribeStackResourcesRequest describeStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns AWS resource descriptions for running and deleted stacks. If <code>StackName</code> is specified, all the
     * associated resources that are part of the stack are returned. If <code>PhysicalResourceId</code> is specified,
     * the associated resources of the stack that the resource belongs to are returned.
     * </p>
     * <note>
     * <p>
     * Only the first 100 resources will be returned. If your stack has more resources than this, you should use
     * <code>ListStackResources</code> instead.
     * </p>
     * </note>
     * <p>
     * For deleted stacks, <code>DescribeStackResources</code> returns resource information for up to 90 days after the
     * stack has been deleted.
     * </p>
     * <p>
     * You must specify either <code>StackName</code> or <code>PhysicalResourceId</code>, but not both. In addition, you
     * can specify <code>LogicalResourceId</code> to filter the returned result. For more information about resources,
     * the <code>LogicalResourceId</code> and <code>PhysicalResourceId</code>, go to the <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/">AWS CloudFormation User Guide</a>.
     * </p>
     * <note>
     * <p>
     * A <code>ValidationError</code> is returned if you specify both <code>StackName</code> and
     * <code>PhysicalResourceId</code> in the same request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStackResourcesRequest#builder()}
     * </p>
     *
     * @param describeStackResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackResourcesInput.Builder} to create a
     *        request. The input for <a>DescribeStackResources</a> action.
     * @return A Java Future containing the result of the DescribeStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackResourcesResponse> describeStackResources(
            Consumer<DescribeStackResourcesRequest.Builder> describeStackResourcesRequest) {
        return describeStackResources(DescribeStackResourcesRequest.builder().applyMutation(describeStackResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     *
     * @param describeStackSetRequest
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetResponse> describeStackSet(DescribeStackSetRequest describeStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackSetRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStackSetRequest#builder()}
     * </p>
     *
     * @param describeStackSetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackSetInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetResponse> describeStackSet(
            Consumer<DescribeStackSetRequest.Builder> describeStackSetRequest) {
        return describeStackSet(DescribeStackSetRequest.builder().applyMutation(describeStackSetRequest).build());
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     *
     * @param describeStackSetOperationRequest
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            DescribeStackSetOperationRequest describeStackSetOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of the specified stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStackSetOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStackSetOperationRequest#builder()}
     * </p>
     *
     * @param describeStackSetOperationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStackSetOperationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStackSetOperationResponse> describeStackSetOperation(
            Consumer<DescribeStackSetOperationRequest.Builder> describeStackSetOperationRequest) {
        return describeStackSetOperation(DescribeStackSetOperationRequest.builder()
                .applyMutation(describeStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksInput.Builder} to create a request. The
     *        input for <a>DescribeStacks</a> action.
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return describeStacks(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStacksResponse> describeStacks() {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksPublisher describeStacksPaginator() {
        return describeStacksPaginator(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStacksRequest
     *        The input for <a>DescribeStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksPublisher describeStacksPaginator(DescribeStacksRequest describeStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the specified stack; if no stack name was specified, then it returns the description
     * for all the stacks created.
     * </p>
     * <note>
     * <p>
     * If the stack does not exist, an <code>AmazonCloudFormationException</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.DescribeStacksPublisher publisher = client.describeStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStacks(software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksInput.Builder} to create a request. The
     *        input for <a>DescribeStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStacksPublisher describeStacksPaginator(Consumer<DescribeStacksRequest.Builder> describeStacksRequest) {
        return describeStacksPaginator(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a type that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific type
     * version. Otherwise, it returns information about the default type version.
     * </p>
     *
     * @param describeTypeRequest
     * @return A Java Future containing the result of the DescribeType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTypeResponse> describeType(DescribeTypeRequest describeTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a type that has been registered.
     * </p>
     * <p>
     * If you specify a <code>VersionId</code>, <code>DescribeType</code> returns information about that specific type
     * version. Otherwise, it returns information about the default type version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTypeRequest#builder()}
     * </p>
     *
     * @param describeTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTypeInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTypeResponse> describeType(Consumer<DescribeTypeRequest.Builder> describeTypeRequest) {
        return describeType(DescribeTypeRequest.builder().applyMutation(describeTypeRequest).build());
    }

    /**
     * <p>
     * Returns information about a type's registration, including its current status and type and version identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <code> <a>RegisterType</a> </code>, you can then use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <code> <a>DescribeType</a> </code> to return detailed
     * informaiton about a type.
     * </p>
     *
     * @param describeTypeRegistrationRequest
     * @return A Java Future containing the result of the DescribeTypeRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeTypeRegistration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTypeRegistrationResponse> describeTypeRegistration(
            DescribeTypeRegistrationRequest describeTypeRegistrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a type's registration, including its current status and type and version identifiers.
     * </p>
     * <p>
     * When you initiate a registration request using <code> <a>RegisterType</a> </code>, you can then use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of that registration request.
     * </p>
     * <p>
     * Once the registration request has completed, use <code> <a>DescribeType</a> </code> to return detailed
     * informaiton about a type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTypeRegistrationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTypeRegistrationRequest#builder()}
     * </p>
     *
     * @param describeTypeRegistrationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTypeRegistrationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTypeRegistration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DescribeTypeRegistration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeTypeRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTypeRegistrationResponse> describeTypeRegistration(
            Consumer<DescribeTypeRegistrationRequest.Builder> describeTypeRegistrationRequest) {
        return describeTypeRegistration(DescribeTypeRegistrationRequest.builder().applyMutation(describeTypeRegistrationRequest)
                .build());
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, AWS CloudFormation compares the actual configuration of the resource with its
     * expected template configuration. Only resource properties explicitly defined in the stack template are checked
     * for drift. A stack is considered to have drifted if one or more of its resources differ from their expected
     * template configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, AWS CloudFormation does not detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     *
     * @param detectStackDriftRequest
     * @return A Java Future containing the result of the DetectStackDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackDriftResponse> detectStackDrift(DetectStackDriftRequest detectStackDriftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detects whether a stack's actual configuration differs, or has <i>drifted</i>, from it's expected configuration,
     * as defined in the stack template and any values specified as template parameters. For each resource in the stack
     * that supports drift detection, AWS CloudFormation compares the actual configuration of the resource with its
     * expected template configuration. Only resource properties explicitly defined in the stack template are checked
     * for drift. A stack is considered to have drifted if one or more of its resources differ from their expected
     * template configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackDrift</code> to detect drift on all supported resources for a given stack, or
     * <a>DetectStackResourceDrift</a> to detect drift on individual resources.
     * </p>
     * <p>
     * For a list of stack resources that currently support drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <p>
     * <code>DetectStackDrift</code> can take up to several minutes, depending on the number of resources contained
     * within the stack. Use <a>DescribeStackDriftDetectionStatus</a> to monitor the progress of a detect stack drift
     * operation. Once the drift detection operation has completed, use <a>DescribeStackResourceDrifts</a> to return
     * drift information about the stack and its resources.
     * </p>
     * <p>
     * When detecting drift on a stack, AWS CloudFormation does not detect drift on any nested stacks belonging to that
     * stack. Perform <code>DetectStackDrift</code> directly on the nested stack itself.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackDriftRequest.Builder} avoiding the need
     * to create one manually via {@link DetectStackDriftRequest#builder()}
     * </p>
     *
     * @param detectStackDriftRequest
     *        A {@link Consumer} that will call methods on {@link DetectStackDriftInput.Builder} to create a request.
     * @return A Java Future containing the result of the DetectStackDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackDriftResponse> detectStackDrift(
            Consumer<DetectStackDriftRequest.Builder> detectStackDriftRequest) {
        return detectStackDrift(DetectStackDriftRequest.builder().applyMutation(detectStackDriftRequest).build());
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from it's
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which AWS CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that do not currently support drift detection cannot be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     *
     * @param detectStackResourceDriftRequest
     * @return A Java Future containing the result of the DetectStackResourceDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackResourceDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackResourceDriftResponse> detectStackResourceDrift(
            DetectStackResourceDriftRequest detectStackResourceDriftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about whether a resource's actual configuration differs, or has <i>drifted</i>, from it's
     * expected configuration, as defined in the stack template and any values specified as template parameters. This
     * information includes actual and expected property values for resources in which AWS CloudFormation detects drift.
     * Only resource properties explicitly defined in the stack template are checked for drift. For more information
     * about stack and resource drift, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
     * Unregulated Configuration Changes to Stacks and Resources</a>.
     * </p>
     * <p>
     * Use <code>DetectStackResourceDrift</code> to detect drift on individual resources, or <a>DetectStackDrift</a> to
     * detect drift on all resources in a given stack that support drift detection.
     * </p>
     * <p>
     * Resources that do not currently support drift detection cannot be checked. For a list of resources that support
     * drift detection, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html"
     * >Resources that Support Drift Detection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackResourceDriftRequest.Builder} avoiding
     * the need to create one manually via {@link DetectStackResourceDriftRequest#builder()}
     * </p>
     *
     * @param detectStackResourceDriftRequest
     *        A {@link Consumer} that will call methods on {@link DetectStackResourceDriftInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetectStackResourceDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackResourceDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackResourceDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackResourceDriftResponse> detectStackResourceDrift(
            Consumer<DetectStackResourceDriftRequest.Builder> detectStackResourceDriftRequest) {
        return detectStackResourceDrift(DetectStackResourceDriftRequest.builder().applyMutation(detectStackResourceDriftRequest)
                .build());
    }

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation
     * Performs Drift Detection on a Stack Set</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the number of stack instances
     * included in the stack set, as well as the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackSet</a> </code> to return detailed informaiton about the stack set, including detailed
     * information about the last <i>completed</i> drift operation performed on the stack set. (Information about drift
     * operations that are in progress is not included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>ListStackInstances</a> </code> to return a list of stack instances belonging to the stack set,
     * including the drift status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackInstance</a> </code> to return detailed information about a specific stack instance,
     * including its drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on performing a drift detection operation on a stack set, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a>.
     * </p>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <code> <a>StopStackSetOperation</a> </code>.
     * </p>
     *
     * @param detectStackSetDriftRequest
     * @return A Java Future containing the result of the DetectStackSetDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackSetDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackSetDriftResponse> detectStackSetDrift(
            DetectStackSetDriftRequest detectStackSetDriftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift
     * detection on the stack associated with each stack instance in the stack set. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">How CloudFormation
     * Performs Drift Detection on a Stack Set</a>.
     * </p>
     * <p>
     * <code>DetectStackSetDrift</code> returns the <code>OperationId</code> of the stack set drift detection operation.
     * Use this operation id with <code> <a>DescribeStackSetOperation</a> </code> to monitor the progress of the drift
     * detection operation. The drift detection operation may take some time, depending on the number of stack instances
     * included in the stack set, as well as the number of resources included in each stack.
     * </p>
     * <p>
     * Once the operation has completed, use the following actions to return drift information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackSet</a> </code> to return detailed informaiton about the stack set, including detailed
     * information about the last <i>completed</i> drift operation performed on the stack set. (Information about drift
     * operations that are in progress is not included.)
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>ListStackInstances</a> </code> to return a list of stack instances belonging to the stack set,
     * including the drift status and last drift time checked of each instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code> <a>DescribeStackInstance</a> </code> to return detailed information about a specific stack instance,
     * including its drift status and last drift time checked.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on performing a drift detection operation on a stack set, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html">Detecting Unmanaged
     * Changes in Stack Sets</a>.
     * </p>
     * <p>
     * You can only run a single drift detection operation on a given stack set at one time.
     * </p>
     * <p>
     * To stop a drift detection stack set operation, use <code> <a>StopStackSetOperation</a> </code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetectStackSetDriftRequest.Builder} avoiding the
     * need to create one manually via {@link DetectStackSetDriftRequest#builder()}
     * </p>
     *
     * @param detectStackSetDriftRequest
     *        A {@link Consumer} that will call methods on {@link DetectStackSetDriftInput.Builder} to create a request.
     * @return A Java Future containing the result of the DetectStackSetDrift operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.DetectStackSetDrift
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DetectStackSetDrift"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DetectStackSetDriftResponse> detectStackSetDrift(
            Consumer<DetectStackSetDriftRequest.Builder> detectStackSetDriftRequest) {
        return detectStackSetDrift(DetectStackSetDriftRequest.builder().applyMutation(detectStackSetDriftRequest).build());
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a
     * query string that describes the resources required to run the template.
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        The input for an <a>EstimateTemplateCost</a> action.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            EstimateTemplateCostRequest estimateTemplateCostRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the estimated monthly cost of a template. The return value is an AWS Simple Monthly Calculator URL with a
     * query string that describes the resources required to run the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EstimateTemplateCostRequest.Builder} avoiding the
     * need to create one manually via {@link EstimateTemplateCostRequest#builder()}
     * </p>
     *
     * @param estimateTemplateCostRequest
     *        A {@link Consumer} that will call methods on {@link EstimateTemplateCostInput.Builder} to create a
     *        request. The input for an <a>EstimateTemplateCost</a> action.
     * @return A Java Future containing the result of the EstimateTemplateCost operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.EstimateTemplateCost
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EstimateTemplateCostResponse> estimateTemplateCost(
            Consumer<EstimateTemplateCostRequest.Builder> estimateTemplateCostRequest) {
        return estimateTemplateCost(EstimateTemplateCostRequest.builder().applyMutation(estimateTemplateCostRequest).build());
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a>
     * action to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You
     * can't specify a temporary stack policy that overrides the current policy.
     * </p>
     *
     * @param executeChangeSetRequest
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(ExecuteChangeSetRequest executeChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack using the input information that was provided when the specified change set was created. After
     * the call successfully completes, AWS CloudFormation starts updating the stack. Use the <a>DescribeStacks</a>
     * action to view the status of the update.
     * </p>
     * <p>
     * When you execute a change set, AWS CloudFormation deletes all other change sets associated with the stack because
     * they aren't valid for the updated stack.
     * </p>
     * <p>
     * If a stack policy is associated with the stack, AWS CloudFormation enforces the policy during the update. You
     * can't specify a temporary stack policy that overrides the current policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteChangeSetRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteChangeSetRequest#builder()}
     * </p>
     *
     * @param executeChangeSetRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteChangeSetInput.Builder} to create a request.
     *        The input for the <a>ExecuteChangeSet</a> action.
     * @return A Java Future containing the result of the ExecuteChangeSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidChangeSetStatusException The specified change set can't be used to update the stack. For
     *         example, the change set status might be <code>CREATE_IN_PROGRESS</code>, or the stack status might be
     *         <code>UPDATE_IN_PROGRESS</code>.</li>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ExecuteChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteChangeSetResponse> executeChangeSet(
            Consumer<ExecuteChangeSetRequest.Builder> executeChangeSetRequest) {
        return executeChangeSet(ExecuteChangeSetRequest.builder().applyMutation(executeChangeSetRequest).build());
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     *
     * @param getStackPolicyRequest
     *        The input for the <a>GetStackPolicy</a> action.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStackPolicyResponse> getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetStackPolicyRequest#builder()}
     * </p>
     *
     * @param getStackPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetStackPolicyInput.Builder} to create a request. The
     *        input for the <a>GetStackPolicy</a> action.
     * @return A Java Future containing the result of the GetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStackPolicyResponse> getStackPolicy(Consumer<GetStackPolicyRequest.Builder> getStackPolicyRequest) {
        return getStackPolicy(GetStackPolicyRequest.builder().applyMutation(getStackPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note>
     *
     * @param getTemplateRequest
     *        The input for a <a>GetTemplate</a> action.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(GetTemplateRequest getTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template body for a specified stack. You can get the template for running or deleted stacks.
     * </p>
     * <p>
     * For deleted stacks, GetTemplate returns the template for up to 90 days after the stack has been deleted.
     * </p>
     * <note>
     * <p>
     * If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateInput.Builder} to create a request. The
     *        input for a <a>GetTemplate</a> action.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChangeSetNotFoundException The specified change set name or ID doesn't exit. To view valid change
     *         sets for a stack, use the <code>ListChangeSets</code> action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest) {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(GetTemplateSummaryRequest getTemplateSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a new or existing template. The <code>GetTemplateSummary</code> action is useful for
     * viewing parameter information, such as default parameter values and parameter types, before you create or update
     * a stack or stack set.
     * </p>
     * <p>
     * You can use the <code>GetTemplateSummary</code> action when you submit a template, or you can get template
     * information for a stack set, or a running or deleted stack.
     * </p>
     * <p>
     * For deleted stacks, <code>GetTemplateSummary</code> returns the template information for up to 90 days after the
     * stack has been deleted. If the template does not exist, a <code>ValidationError</code> is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetTemplateSummaryRequest#builder()}
     * </p>
     *
     * @param getTemplateSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateSummaryInput.Builder} to create a request.
     *        The input for the <a>GetTemplateSummary</a> action.
     * @return A Java Future containing the result of the GetTemplateSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.GetTemplateSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTemplateSummaryResponse> getTemplateSummary(
            Consumer<GetTemplateSummaryRequest.Builder> getTemplateSummaryRequest) {
        return getTemplateSummary(GetTemplateSummaryRequest.builder().applyMutation(getTemplateSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(ListChangeSetsRequest listChangeSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListChangeSetsInput.Builder} to create a request. The
     *        input for the <a>ListChangeSets</a> action.
     * @return A Java Future containing the result of the ListChangeSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListChangeSetsResponse> listChangeSets(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSets(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listChangeSetsRequest
     *        The input for the <a>ListChangeSets</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsPublisher listChangeSetsPaginator(ListChangeSetsRequest listChangeSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ID and status of each active change set for a stack. For example, AWS CloudFormation lists change
     * sets that are in the <code>CREATE_IN_PROGRESS</code> or <code>CREATE_PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListChangeSetsPublisher publisher = client.listChangeSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChangeSets(software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChangeSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChangeSetsRequest#builder()}
     * </p>
     *
     * @param listChangeSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListChangeSetsInput.Builder} to create a request. The
     *        input for the <a>ListChangeSets</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListChangeSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChangeSetsPublisher listChangeSetsPaginator(Consumer<ListChangeSetsRequest.Builder> listChangeSetsRequest) {
        return listChangeSetsPaginator(ListChangeSetsRequest.builder().applyMutation(listChangeSetsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @param listExportsRequest
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports() {
        return listExports(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator() {
        return listExportsPaginator(ListExportsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all exported output values in the account and Region in which you call this action. Use this action to see
     * the exported output values that you can import into other stacks. To import values, use the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html"> AWS
     * CloudFormation Export Stack Output Values</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.cloudformation.model.ListExportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first
     * use this action to see which stacks are using it. To see the exported output values in your account, see
     * <a>ListExports</a>.
     * </p>
     * <p>
     * For more information about importing an exported output value, see the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html">
     * <code>Fn::ImportValue</code> </a> function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudformation.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or Region, or that have a
     * specific status.
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesResponse> listStackInstances(ListStackInstancesRequest listStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or Region, or that have a
     * specific status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     * </p>
     *
     * @param listStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackInstancesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackInstancesResponse> listStackInstances(
            Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest) {
        return listStackInstances(ListStackInstancesRequest.builder().applyMutation(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or Region, or that have a
     * specific status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesPublisher listStackInstancesPaginator(ListStackInstancesRequest listStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified stack set. You can
     * filter for stack instances that are associated with a specific AWS account name or Region, or that have a
     * specific status.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackInstancesPublisher publisher = client.listStackInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackInstances(software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackInstancesRequest#builder()}
     * </p>
     *
     * @param listStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackInstancesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackInstancesPublisher listStackInstancesPaginator(
            Consumer<ListStackInstancesRequest.Builder> listStackInstancesRequest) {
        return listStackInstancesPaginator(ListStackInstancesRequest.builder().applyMutation(listStackInstancesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackResourcesResponse> listStackResources(ListStackResourcesRequest listStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     * </p>
     *
     * @param listStackResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackResourcesInput.Builder} to create a request.
     *        The input for the <a>ListStackResource</a> action.
     * @return A Java Future containing the result of the ListStackResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackResourcesResponse> listStackResources(
            Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest) {
        return listStackResources(ListStackResourcesRequest.builder().applyMutation(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackResourcesRequest
     *        The input for the <a>ListStackResource</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesPublisher listStackResourcesPaginator(ListStackResourcesRequest listStackResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of all resources of the specified stack.
     * </p>
     * <p>
     * For deleted stacks, ListStackResources returns resource information for up to 90 days after the stack has been
     * deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackResourcesPublisher publisher = client.listStackResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackResources(software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackResourcesRequest#builder()}
     * </p>
     *
     * @param listStackResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListStackResourcesInput.Builder} to create a request.
     *        The input for the <a>ListStackResource</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackResourcesPublisher listStackResourcesPaginator(
            Consumer<ListStackResourcesRequest.Builder> listStackResourcesRequest) {
        return listStackResourcesPaginator(ListStackResourcesRequest.builder().applyMutation(listStackResourcesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationResultsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStackSetOperationResults operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationResultsResponse> listStackSetOperationResults(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest) {
        return listStackSetOperationResults(ListStackSetOperationResultsRequest.builder()
                .applyMutation(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsPublisher listStackSetOperationResultsPaginator(
            ListStackSetOperationResultsRequest listStackSetOperationResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the results of a stack set operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationResultsPublisher publisher = client.listStackSetOperationResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperationResults(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationResultsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationResultsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStackSetOperationResultsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationResultsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationResultsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperationResults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationResultsPublisher listStackSetOperationResultsPaginator(
            Consumer<ListStackSetOperationResultsRequest.Builder> listStackSetOperationResultsRequest) {
        return listStackSetOperationResultsPaginator(ListStackSetOperationResultsRequest.builder()
                .applyMutation(listStackSetOperationResultsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStackSetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStackSetOperationsResponse> listStackSetOperations(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) {
        return listStackSetOperations(ListStackSetOperationsRequest.builder().applyMutation(listStackSetOperationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStackSetOperationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsPublisher listStackSetOperationsPaginator(
            ListStackSetOperationsRequest listStackSetOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about operations performed on a stack set.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetOperationsPublisher publisher = client.listStackSetOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSetOperations(software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStackSetOperationsRequest#builder()}
     * </p>
     *
     * @param listStackSetOperationsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetOperationsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSetOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStackSetOperationsPublisher listStackSetOperationsPaginator(
            Consumer<ListStackSetOperationsRequest.Builder> listStackSetOperationsRequest) {
        return listStackSetOperationsPaginator(ListStackSetOperationsRequest.builder()
                .applyMutation(listStackSetOperationsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     *
     * @param listStackSetsRequest
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets(ListStackSetsRequest listStackSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     * </p>
     *
     * @param listStackSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest) {
        return listStackSets(ListStackSetsRequest.builder().applyMutation(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     *
     * @return A Java Future containing the result of the ListStackSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStackSetsResponse> listStackSets() {
        return listStackSets(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsPublisher listStackSetsPaginator() {
        return listStackSetsPaginator(ListStackSetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     *
     * @param listStackSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsPublisher listStackSetsPaginator(ListStackSetsRequest listStackSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about stack sets that are associated with the user.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStackSetsPublisher publisher = client.listStackSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStackSets(software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStackSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStackSetsRequest#builder()}
     * </p>
     *
     * @param listStackSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListStackSetsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStackSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStackSetsPublisher listStackSetsPaginator(Consumer<ListStackSetsRequest.Builder> listStackSetsRequest) {
        return listStackSetsPaginator(ListStackSetsRequest.builder().applyMutation(listStackSetsRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks(ListStacksRequest listStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     * </p>
     *
     * @param listStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListStacksInput.Builder} to create a request. The
     *        input for <a>ListStacks</a> action.
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks(Consumer<ListStacksRequest.Builder> listStacksRequest) {
        return listStacks(ListStacksRequest.builder().applyMutation(listStacksRequest).build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     *
     * @return A Java Future containing the result of the ListStacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStacksResponse> listStacks() {
        return listStacks(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksPublisher listStacksPaginator() {
        return listStacksPaginator(ListStacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     *
     * @param listStacksRequest
     *        The input for <a>ListStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksPublisher listStacksPaginator(ListStacksRequest listStacksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the summary information for stacks whose status matches the specified StackStatusFilter. Summary
     * information for stacks that have been deleted is kept for 90 days after the stack is deleted. If no
     * StackStatusFilter is specified, summary information for all stacks is returned (including existing stacks and
     * stacks that have been deleted).
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListStacksPublisher publisher = client.listStacksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListStacksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListStacksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStacks(software.amazon.awssdk.services.cloudformation.model.ListStacksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListStacksRequest#builder()}
     * </p>
     *
     * @param listStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListStacksInput.Builder} to create a request. The
     *        input for <a>ListStacks</a> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListStacks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStacksPublisher listStacksPaginator(Consumer<ListStacksRequest.Builder> listStacksRequest) {
        return listStacksPaginator(ListStacksRequest.builder().applyMutation(listStacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified type(s).
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A Java Future containing the result of the ListTypeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeRegistrationsResponse> listTypeRegistrations(
            ListTypeRegistrationsRequest listTypeRegistrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified type(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypeRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTypeRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeRegistrationsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTypeRegistrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeRegistrationsResponse> listTypeRegistrations(
            Consumer<ListTypeRegistrationsRequest.Builder> listTypeRegistrationsRequest) {
        return listTypeRegistrations(ListTypeRegistrationsRequest.builder().applyMutation(listTypeRegistrationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified type(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeRegistrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsPublisher listTypeRegistrationsPaginator(
            ListTypeRegistrationsRequest listTypeRegistrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of registration tokens for the specified type(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeRegistrationsPublisher publisher = client.listTypeRegistrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeRegistrations(software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypeRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTypeRegistrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeRegistrationsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeRegistrations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeRegistrationsPublisher listTypeRegistrationsPaginator(
            Consumer<ListTypeRegistrationsRequest.Builder> listTypeRegistrationsRequest) {
        return listTypeRegistrationsPaginator(ListTypeRegistrationsRequest.builder().applyMutation(listTypeRegistrationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns summary information about the versions of a type.
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A Java Future containing the result of the ListTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeVersionsResponse> listTypeVersions(ListTypeVersionsRequest listTypeVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the versions of a type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTypeVersionsRequest#builder()}
     * </p>
     *
     * @param listTypeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeVersionsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTypeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTypeVersionsResponse> listTypeVersions(
            Consumer<ListTypeVersionsRequest.Builder> listTypeVersionsRequest) {
        return listTypeVersions(ListTypeVersionsRequest.builder().applyMutation(listTypeVersionsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about the versions of a type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypeVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsPublisher listTypeVersionsPaginator(ListTypeVersionsRequest listTypeVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about the versions of a type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypeVersionsPublisher publisher = client.listTypeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypeVersions(software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypeVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTypeVersionsRequest#builder()}
     * </p>
     *
     * @param listTypeVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTypeVersionsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypeVersionsPublisher listTypeVersionsPaginator(Consumer<ListTypeVersionsRequest.Builder> listTypeVersionsRequest) {
        return listTypeVersionsPaginator(ListTypeVersionsRequest.builder().applyMutation(listTypeVersionsRequest).build());
    }

    /**
     * <p>
     * Returns summary information about types that have been registered with CloudFormation.
     * </p>
     *
     * @param listTypesRequest
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTypesResponse> listTypes(ListTypesRequest listTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about types that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTypesResponse> listTypes(Consumer<ListTypesRequest.Builder> listTypesRequest) {
        return listTypes(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Returns summary information about types that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     *
     * @param listTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesPublisher listTypesPaginator(ListTypesRequest listTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summary information about types that have been registered with CloudFormation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudformation.paginators.ListTypesPublisher publisher = client.listTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudformation.model.ListTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudformation.model.ListTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.cloudformation.model.ListTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListTypesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesPublisher listTypesPaginator(Consumer<ListTypesRequest.Builder> listTypesRequest) {
        return listTypesPaginator(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Do not use this API in your code.
     * </p>
     *
     * @param recordHandlerProgressRequest
     * @return A Java Future containing the result of the RecordHandlerProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidStateTransitionException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.</li>
     *         <li>OperationStatusCheckFailedException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RecordHandlerProgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecordHandlerProgressResponse> recordHandlerProgress(
            RecordHandlerProgressRequest recordHandlerProgressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reports progress of a resource handler to CloudFormation.
     * </p>
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>. Do not use this API in your code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RecordHandlerProgressRequest.Builder} avoiding the
     * need to create one manually via {@link RecordHandlerProgressRequest#builder()}
     * </p>
     *
     * @param recordHandlerProgressRequest
     *        A {@link Consumer} that will call methods on {@link RecordHandlerProgressInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RecordHandlerProgress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidStateTransitionException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.</li>
     *         <li>OperationStatusCheckFailedException Error reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>. CloudFormation does not return this error to users.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RecordHandlerProgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RecordHandlerProgress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RecordHandlerProgressResponse> recordHandlerProgress(
            Consumer<RecordHandlerProgressRequest.Builder> recordHandlerProgressRequest) {
        return recordHandlerProgress(RecordHandlerProgressRequest.builder().applyMutation(recordHandlerProgressRequest).build());
    }

    /**
     * <p>
     * Registers a type with the CloudFormation service. Registering a type makes it available for use in CloudFormation
     * templates in your AWS account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the resource schema
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers have been specified for the resource
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the resource type available for use in your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to develop types and ready them for registeration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource type versions registered at a time. This maximum is per account and per
     * region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to
     * deregister specific resource type versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <code> <a>RegisterType</a> </code>, you can use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of the registration request.
     * </p>
     *
     * @param registerTypeRequest
     * @return A Java Future containing the result of the RegisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTypeResponse> registerType(RegisterTypeRequest registerTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a type with the CloudFormation service. Registering a type makes it available for use in CloudFormation
     * templates in your AWS account, and includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Validating the resource schema
     * </p>
     * </li>
     * <li>
     * <p>
     * Determining which handlers have been specified for the resource
     * </p>
     * </li>
     * <li>
     * <p>
     * Making the resource type available for use in your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on how to develop types and ready them for registeration, see <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html">Creating Resource
     * Providers</a> in the <i>CloudFormation CLI User Guide</i>.
     * </p>
     * <p>
     * You can have a maximum of 50 resource type versions registered at a time. This maximum is per account and per
     * region. Use <a href="AWSCloudFormation/latest/APIReference/API_DeregisterType.html">DeregisterType</a> to
     * deregister specific resource type versions if necessary.
     * </p>
     * <p>
     * Once you have initiated a registration request using <code> <a>RegisterType</a> </code>, you can use
     * <code> <a>DescribeTypeRegistration</a> </code> to monitor the progress of the registration request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTypeRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterTypeRequest#builder()}
     * </p>
     *
     * @param registerTypeRequest
     *        A {@link Consumer} that will call methods on {@link RegisterTypeInput.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.RegisterType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/RegisterType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTypeResponse> registerType(Consumer<RegisterTypeRequest.Builder> registerTypeRequest) {
        return registerType(RegisterTypeRequest.builder().applyMutation(registerTypeRequest).build());
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     *
     * @param setStackPolicyRequest
     *        The input for the <a>SetStackPolicy</a> action.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetStackPolicyResponse> setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a stack policy for a specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetStackPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link SetStackPolicyRequest#builder()}
     * </p>
     *
     * @param setStackPolicyRequest
     *        A {@link Consumer} that will call methods on {@link SetStackPolicyInput.Builder} to create a request. The
     *        input for the <a>SetStackPolicy</a> action.
     * @return A Java Future containing the result of the SetStackPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetStackPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SetStackPolicyResponse> setStackPolicy(Consumer<SetStackPolicyRequest.Builder> setStackPolicyRequest) {
        return setStackPolicy(SetStackPolicyRequest.builder().applyMutation(setStackPolicyRequest).build());
    }

    /**
     * <p>
     * Specify the default version of a type. The default version of a type will be used in CloudFormation operations.
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     * @return A Java Future containing the result of the SetTypeDefaultVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTypeDefaultVersionResponse> setTypeDefaultVersion(
            SetTypeDefaultVersionRequest setTypeDefaultVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify the default version of a type. The default version of a type will be used in CloudFormation operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTypeDefaultVersionRequest.Builder} avoiding the
     * need to create one manually via {@link SetTypeDefaultVersionRequest#builder()}
     * </p>
     *
     * @param setTypeDefaultVersionRequest
     *        A {@link Consumer} that will call methods on {@link SetTypeDefaultVersionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetTypeDefaultVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CfnRegistryException An error occurred during a CloudFormation registry operation.</li>
     *         <li>TypeNotFoundException The specified type does not exist in the CloudFormation registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SetTypeDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetTypeDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTypeDefaultVersionResponse> setTypeDefaultVersion(
            Consumer<SetTypeDefaultVersionRequest.Builder> setTypeDefaultVersionRequest) {
        return setTypeDefaultVersion(SetTypeDefaultVersionRequest.builder().applyMutation(setTypeDefaultVersionRequest).build());
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. AWS CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     *
     * @param signalResourceRequest
     *        The input for the <a>SignalResource</a> action.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SignalResourceResponse> signalResource(SignalResourceRequest signalResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in
     * conjunction with a creation policy or update policy. AWS CloudFormation doesn't proceed with a stack creation or
     * update until resources receive the required number of signals or the timeout period is exceeded. The
     * SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignalResourceRequest.Builder} avoiding the need to
     * create one manually via {@link SignalResourceRequest#builder()}
     * </p>
     *
     * @param signalResourceRequest
     *        A {@link Consumer} that will call methods on {@link SignalResourceInput.Builder} to create a request. The
     *        input for the <a>SignalResource</a> action.
     * @return A Java Future containing the result of the SignalResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.SignalResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SignalResourceResponse> signalResource(Consumer<SignalResourceRequest.Builder> signalResourceRequest) {
        return signalResource(SignalResourceRequest.builder().applyMutation(signalResourceRequest).build());
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     *
     * @param stopStackSetOperationRequest
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            StopStackSetOperationRequest stopStackSetOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an in-progress operation on a stack set and its associated stack instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStackSetOperationRequest.Builder} avoiding the
     * need to create one manually via {@link StopStackSetOperationRequest#builder()}
     * </p>
     *
     * @param stopStackSetOperationRequest
     *        A {@link Consumer} that will call methods on {@link StopStackSetOperationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopStackSetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationNotFoundException The specified ID refers to an operation that doesn't exist.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.StopStackSetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StopStackSetOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopStackSetOperationResponse> stopStackSetOperation(
            Consumer<StopStackSetOperationRequest.Builder> stopStackSetOperationRequest) {
        return stopStackSetOperation(StopStackSetOperationRequest.builder().applyMutation(stopStackSetOperationRequest).build());
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     *
     * @param updateStackRequest
     *        The input for an <a>UpdateStack</a> action.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(UpdateStackRequest updateStackRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stack as specified in the template. After the call completes successfully, the stack update starts. You
     * can check the status of the stack via the <a>DescribeStacks</a> action.
     * </p>
     * <p>
     * To get a copy of the template for an existing stack, you can use the <a>GetTemplate</a> action.
     * </p>
     * <p>
     * For more information about creating an update template, updating a stack, and monitoring the progress of the
     * update, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">Updating a
     * Stack</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     * </p>
     *
     * @param updateStackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackInput.Builder} to create a request. The
     *        input for an <a>UpdateStack</a> action.
     * @return A Java Future containing the result of the UpdateStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InsufficientCapabilitiesException The template contains resources with capabilities that weren't
     *         specified in the Capabilities parameter.</li>
     *         <li>TokenAlreadyExistsException A client request token already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStackResponse> updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest) {
        return updateStack(UpdateStackRequest.builder().applyMutation(updateStackRequest).build());
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A
     * stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Regions and accounts where they already exist; to create additional stack
     * instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance are not updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     *
     * @param updateStackInstancesRequest
     * @return A Java Future containing the result of the UpdateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStackInstancesResponse> updateStackInstances(
            UpdateStackInstancesRequest updateStackInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A
     * stack instance refers to a stack in a specific account and Region.
     * </p>
     * <p>
     * You can only update stack instances in Regions and accounts where they already exist; to create additional stack
     * instances, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html"
     * >CreateStackInstances</a>.
     * </p>
     * <p>
     * During stack set updates, any parameters overridden for a stack instance are not updated, but retain their
     * overridden value.
     * </p>
     * <p>
     * You can only update the parameter <i>values</i> that are specified in the stack set; to add or delete a parameter
     * itself, use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html">UpdateStackSet
     * </a> to update the stack set template. If you add a parameter to a template, before you can override the
     * parameter value specified in the stack set you must first use <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html"
     * >UpdateStackSet</a> to update all stack instances with the updated template and parameter value specified in the
     * stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter
     * value using <code>UpdateStackInstances</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStackInstancesRequest#builder()}
     * </p>
     *
     * @param updateStackInstancesRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackInstancesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStackInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStackInstancesResponse> updateStackInstances(
            Consumer<UpdateStackInstancesRequest.Builder> updateStackInstancesRequest) {
        return updateStackInstances(UpdateStackInstancesRequest.builder().applyMutation(updateStackInstancesRequest).build());
    }

    /**
     * <p>
     * Updates the stack set, and associated stack instances in the specified accounts and Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     *
     * @param updateStackSetRequest
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackSetResponse> updateStackSet(UpdateStackSetRequest updateStackSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the stack set, and associated stack instances in the specified accounts and Regions.
     * </p>
     * <p>
     * Even if the stack set operation created by updating the stack set fails (completely or partially, below or above
     * a specified failure tolerance), the stack set is updated with your changes. Subsequent
     * <a>CreateStackInstances</a> calls on the specified stack set use the updated stack set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackSetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackSetRequest#builder()}
     * </p>
     *
     * @param updateStackSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackSetInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStackSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>StackSetNotFoundException The specified stack set doesn't exist.</li>
     *         <li>OperationInProgressException Another operation is currently in progress for this stack set. Only one
     *         operation can be performed for a stack set at a given time.</li>
     *         <li>OperationIdAlreadyExistsException The specified operation ID already exists.</li>
     *         <li>StaleRequestException Another operation has been performed on this stack set since the specified
     *         operation was performed.</li>
     *         <li>InvalidOperationException The specified operation isn't valid.</li>
     *         <li>StackInstanceNotFoundException The specified stack instance doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateStackSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStackSetResponse> updateStackSet(Consumer<UpdateStackSetRequest.Builder> updateStackSetRequest) {
        return updateStackSet(UpdateStackSetRequest.builder().applyMutation(updateStackSetRequest).build());
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     *
     * @param updateTerminationProtectionRequest
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            UpdateTerminationProtectionRequest updateTerminationProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates termination protection for the specified stack. If a user attempts to delete a stack with termination
     * protection enabled, the operation fails and the stack remains unchanged. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html">Protecting a
     * Stack From Being Deleted</a> in the <i>AWS CloudFormation User Guide</i>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">nested
     * stacks</a>, termination protection is set on the root stack and cannot be changed directly on the nested stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTerminationProtectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTerminationProtectionRequest#builder()}
     * </p>
     *
     * @param updateTerminationProtectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTerminationProtectionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.UpdateTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTerminationProtectionResponse> updateTerminationProtection(
            Consumer<UpdateTerminationProtectionRequest.Builder> updateTerminationProtectionRequest) {
        return updateTerminationProtection(UpdateTerminationProtectionRequest.builder()
                .applyMutation(updateTerminationProtectionRequest).build());
    }

    /**
     * <p>
     * Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn't, AWS
     * CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a
     * template validation error.
     * </p>
     *
     * @param validateTemplateRequest
     *        The input for <a>ValidateTemplate</a> action.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateTemplateResponse> validateTemplate(ValidateTemplateRequest validateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates a specified template. AWS CloudFormation first checks if the template is valid JSON. If it isn't, AWS
     * CloudFormation checks if the template is valid YAML. If both these checks fail, AWS CloudFormation returns a
     * template validation error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link ValidateTemplateRequest#builder()}
     * </p>
     *
     * @param validateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link ValidateTemplateInput.Builder} to create a request.
     *        The input for <a>ValidateTemplate</a> action.
     * @return A Java Future containing the result of the ValidateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFormationException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CloudFormationAsyncClient.ValidateTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateTemplateResponse> validateTemplate(
            Consumer<ValidateTemplateRequest.Builder> validateTemplateRequest) {
        return validateTemplate(ValidateTemplateRequest.builder().applyMutation(validateTemplateRequest).build());
    }
}
