/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceDetailedStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackInstanceComprehensiveStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackInstanceComprehensiveStatus> {
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackInstanceComprehensiveStatus.getter(StackInstanceComprehensiveStatus::detailedStatusAsString)).setter(StackInstanceComprehensiveStatus.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detailedStatus;

    private StackInstanceComprehensiveStatus(BuilderImpl builder) {
        this.detailedStatus = builder.detailedStatus;
    }

    public StackInstanceDetailedStatus detailedStatus() {
        return StackInstanceDetailedStatus.fromValue(this.detailedStatus);
    }

    public String detailedStatusAsString() {
        return this.detailedStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstanceComprehensiveStatus)) {
            return false;
        }
        StackInstanceComprehensiveStatus other = (StackInstanceComprehensiveStatus)obj;
        return Objects.equals(this.detailedStatusAsString(), other.detailedStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"StackInstanceComprehensiveStatus").add("DetailedStatus", (Object)this.detailedStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackInstanceComprehensiveStatus, T> g) {
        return obj -> g.apply((StackInstanceComprehensiveStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detailedStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StackInstanceComprehensiveStatus model) {
            this.detailedStatus(model.detailedStatus);
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        @Override
        public final Builder detailedStatus(StackInstanceDetailedStatus detailedStatus) {
            this.detailedStatus(detailedStatus == null ? null : detailedStatus.toString());
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public StackInstanceComprehensiveStatus build() {
            return new StackInstanceComprehensiveStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackInstanceComprehensiveStatus> {
        public Builder detailedStatus(String var1);

        public Builder detailedStatus(StackInstanceDetailedStatus var1);
    }
}

