/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordHandlerProgressRequest extends CloudFormationRequest implements
        ToCopyableBuilder<RecordHandlerProgressRequest.Builder, RecordHandlerProgressRequest> {
    private static final SdkField<String> BEARER_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BearerToken").getter(getter(RecordHandlerProgressRequest::bearerToken))
            .setter(setter(Builder::bearerToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BearerToken").build()).build();

    private static final SdkField<String> OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationStatus").getter(getter(RecordHandlerProgressRequest::operationStatusAsString))
            .setter(setter(Builder::operationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatus").build()).build();

    private static final SdkField<String> CURRENT_OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentOperationStatus").getter(getter(RecordHandlerProgressRequest::currentOperationStatusAsString))
            .setter(setter(Builder::currentOperationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentOperationStatus").build())
            .build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(RecordHandlerProgressRequest::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(RecordHandlerProgressRequest::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> RESOURCE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceModel").getter(getter(RecordHandlerProgressRequest::resourceModel))
            .setter(setter(Builder::resourceModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceModel").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(RecordHandlerProgressRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEARER_TOKEN_FIELD,
            OPERATION_STATUS_FIELD, CURRENT_OPERATION_STATUS_FIELD, STATUS_MESSAGE_FIELD, ERROR_CODE_FIELD, RESOURCE_MODEL_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String bearerToken;

    private final String operationStatus;

    private final String currentOperationStatus;

    private final String statusMessage;

    private final String errorCode;

    private final String resourceModel;

    private final String clientRequestToken;

    private RecordHandlerProgressRequest(BuilderImpl builder) {
        super(builder);
        this.bearerToken = builder.bearerToken;
        this.operationStatus = builder.operationStatus;
        this.currentOperationStatus = builder.currentOperationStatus;
        this.statusMessage = builder.statusMessage;
        this.errorCode = builder.errorCode;
        this.resourceModel = builder.resourceModel;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     */
    public String bearerToken() {
        return bearerToken;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     * @see OperationStatus
     */
    public OperationStatus operationStatus() {
        return OperationStatus.fromValue(operationStatus);
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationStatus}
     * will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operationStatusAsString}.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     * @see OperationStatus
     */
    public String operationStatusAsString() {
        return operationStatus;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentOperationStatus} will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentOperationStatusAsString}.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     * @see OperationStatus
     */
    public OperationStatus currentOperationStatus() {
        return OperationStatus.fromValue(currentOperationStatus);
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentOperationStatus} will return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentOperationStatusAsString}.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     * @see OperationStatus
     */
    public String currentOperationStatusAsString() {
        return currentOperationStatus;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link HandlerErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     * @see HandlerErrorCode
     */
    public HandlerErrorCode errorCode() {
        return HandlerErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link HandlerErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     * @see HandlerErrorCode
     */
    public String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     */
    public String resourceModel() {
        return resourceModel;
    }

    /**
     * <p>
     * Reserved for use by the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     * >CloudFormation CLI</a>.
     * </p>
     * 
     * @return Reserved for use by the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
     *         >CloudFormation CLI</a>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bearerToken());
        hashCode = 31 * hashCode + Objects.hashCode(operationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentOperationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceModel());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordHandlerProgressRequest)) {
            return false;
        }
        RecordHandlerProgressRequest other = (RecordHandlerProgressRequest) obj;
        return Objects.equals(bearerToken(), other.bearerToken())
                && Objects.equals(operationStatusAsString(), other.operationStatusAsString())
                && Objects.equals(currentOperationStatusAsString(), other.currentOperationStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(resourceModel(), other.resourceModel())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecordHandlerProgressRequest").add("BearerToken", bearerToken())
                .add("OperationStatus", operationStatusAsString())
                .add("CurrentOperationStatus", currentOperationStatusAsString()).add("StatusMessage", statusMessage())
                .add("ErrorCode", errorCodeAsString()).add("ResourceModel", resourceModel())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BearerToken":
            return Optional.ofNullable(clazz.cast(bearerToken()));
        case "OperationStatus":
            return Optional.ofNullable(clazz.cast(operationStatusAsString()));
        case "CurrentOperationStatus":
            return Optional.ofNullable(clazz.cast(currentOperationStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ResourceModel":
            return Optional.ofNullable(clazz.cast(resourceModel()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordHandlerProgressRequest, T> g) {
        return obj -> g.apply((RecordHandlerProgressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RecordHandlerProgressRequest> {
        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param bearerToken
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bearerToken(String bearerToken);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param operationStatus
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder operationStatus(String operationStatus);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param operationStatus
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder operationStatus(OperationStatus operationStatus);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param currentOperationStatus
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder currentOperationStatus(String currentOperationStatus);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param currentOperationStatus
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder currentOperationStatus(OperationStatus currentOperationStatus);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param statusMessage
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param errorCode
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @see HandlerErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandlerErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param errorCode
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @see HandlerErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HandlerErrorCode
         */
        Builder errorCode(HandlerErrorCode errorCode);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param resourceModel
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceModel(String resourceModel);

        /**
         * <p>
         * Reserved for use by the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         * >CloudFormation CLI</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        Reserved for use by the <a href=
         *        "https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html"
         *        >CloudFormation CLI</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String bearerToken;

        private String operationStatus;

        private String currentOperationStatus;

        private String statusMessage;

        private String errorCode;

        private String resourceModel;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordHandlerProgressRequest model) {
            super(model);
            bearerToken(model.bearerToken);
            operationStatus(model.operationStatus);
            currentOperationStatus(model.currentOperationStatus);
            statusMessage(model.statusMessage);
            errorCode(model.errorCode);
            resourceModel(model.resourceModel);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getBearerToken() {
            return bearerToken;
        }

        @Override
        public final Builder bearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public final void setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
        }

        public final String getOperationStatus() {
            return operationStatus;
        }

        @Override
        public final Builder operationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
            return this;
        }

        @Override
        public final Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus(operationStatus == null ? null : operationStatus.toString());
            return this;
        }

        public final void setOperationStatus(String operationStatus) {
            this.operationStatus = operationStatus;
        }

        public final String getCurrentOperationStatus() {
            return currentOperationStatus;
        }

        @Override
        public final Builder currentOperationStatus(String currentOperationStatus) {
            this.currentOperationStatus = currentOperationStatus;
            return this;
        }

        @Override
        public final Builder currentOperationStatus(OperationStatus currentOperationStatus) {
            this.currentOperationStatus(currentOperationStatus == null ? null : currentOperationStatus.toString());
            return this;
        }

        public final void setCurrentOperationStatus(String currentOperationStatus) {
            this.currentOperationStatus = currentOperationStatus;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(HandlerErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getResourceModel() {
            return resourceModel;
        }

        @Override
        public final Builder resourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        public final void setResourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecordHandlerProgressRequest build() {
            return new RecordHandlerProgressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
