/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackSetOperationResultsResponse extends CloudFormationResponse implements
        ToCopyableBuilder<ListStackSetOperationResultsResponse.Builder, ListStackSetOperationResultsResponse> {
    private static final SdkField<List<StackSetOperationResultSummary>> SUMMARIES_FIELD = SdkField
            .<List<StackSetOperationResultSummary>> builder(MarshallingType.LIST)
            .memberName("Summaries")
            .getter(getter(ListStackSetOperationResultsResponse::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackSetOperationResultSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackSetOperationResultSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackSetOperationResultsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StackSetOperationResultSummary> summaries;

    private final String nextToken;

    private ListStackSetOperationResultsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Summaries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSummaries() {
        return summaries != null && !(summaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
     * operation results, for accounts and Regions that are included in the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>StackSetOperationResultSummary</code> structures that contain information about the
     *         specified operation results, for accounts and Regions that are included in the operation.
     */
    public List<StackSetOperationResultSummary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next set of
     * results, call <code>ListOperationResults</code> again and assign that token to the request object's
     * <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next
     *         set of results, call <code>ListOperationResults</code> again and assign that token to the request
     *         object's <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is
     *         set to <code>null</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetOperationResultsResponse)) {
            return false;
        }
        ListStackSetOperationResultsResponse other = (ListStackSetOperationResultsResponse) obj;
        return Objects.equals(summaries(), other.summaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStackSetOperationResultsResponse").add("Summaries", summaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackSetOperationResultsResponse, T> g) {
        return obj -> g.apply((ListStackSetOperationResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackSetOperationResultsResponse> {
        /**
         * <p>
         * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
         * operation results, for accounts and Regions that are included in the operation.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetOperationResultSummary</code> structures that contain information about the
         *        specified operation results, for accounts and Regions that are included in the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<StackSetOperationResultSummary> summaries);

        /**
         * <p>
         * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
         * operation results, for accounts and Regions that are included in the operation.
         * </p>
         * 
         * @param summaries
         *        A list of <code>StackSetOperationResultSummary</code> structures that contain information about the
         *        specified operation results, for accounts and Regions that are included in the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(StackSetOperationResultSummary... summaries);

        /**
         * <p>
         * A list of <code>StackSetOperationResultSummary</code> structures that contain information about the specified
         * operation results, for accounts and Regions that are included in the operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackSetOperationResultSummary>.Builder}
         * avoiding the need to create one manually via {@link List<StackSetOperationResultSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackSetOperationResultSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #summaries(List<StackSetOperationResultSummary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on {@link List<StackSetOperationResultSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(List<StackSetOperationResultSummary>)
         */
        Builder summaries(Consumer<StackSetOperationResultSummary.Builder>... summaries);

        /**
         * <p>
         * If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the next set
         * of results, call <code>ListOperationResults</code> again and assign that token to the request object's
         * <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all results, <code>NextToken</code> is set to a token. To retrieve the
         *        next set of results, call <code>ListOperationResults</code> again and assign that token to the request
         *        object's <code>NextToken</code> parameter. If there are no remaining results, <code>NextToken</code>
         *        is set to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackSetOperationResultSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetOperationResultsResponse model) {
            super(model);
            summaries(model.summaries);
            nextToken(model.nextToken);
        }

        public final Collection<StackSetOperationResultSummary.Builder> getSummaries() {
            return summaries != null ? summaries.stream().map(StackSetOperationResultSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetOperationResultSummary> summaries) {
            this.summaries = StackSetOperationResultSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetOperationResultSummary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<StackSetOperationResultSummary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> StackSetOperationResultSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<StackSetOperationResultSummary.BuilderImpl> summaries) {
            this.summaries = StackSetOperationResultSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackSetOperationResultsResponse build() {
            return new ListStackSetOperationResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
