/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetOperationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetOperationSummary> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(StackSetOperationSummary.getter(StackSetOperationSummary::operationId)).setter(StackSetOperationSummary.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(StackSetOperationSummary.getter(StackSetOperationSummary::actionAsString)).setter(StackSetOperationSummary.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StackSetOperationSummary.getter(StackSetOperationSummary::statusAsString)).setter(StackSetOperationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(StackSetOperationSummary.getter(StackSetOperationSummary::creationTimestamp)).setter(StackSetOperationSummary.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(StackSetOperationSummary.getter(StackSetOperationSummary::endTimestamp)).setter(StackSetOperationSummary.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD, ACTION_FIELD, STATUS_FIELD, CREATION_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operationId;
    private final String action;
    private final String status;
    private final Instant creationTimestamp;
    private final Instant endTimestamp;

    private StackSetOperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.action = builder.action;
        this.status = builder.status;
        this.creationTimestamp = builder.creationTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    public String operationId() {
        return this.operationId;
    }

    public StackSetOperationAction action() {
        return StackSetOperationAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public StackSetOperationStatus status() {
        return StackSetOperationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Instant endTimestamp() {
        return this.endTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationSummary)) {
            return false;
        }
        StackSetOperationSummary other = (StackSetOperationSummary)obj;
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"StackSetOperationSummary").add("OperationId", (Object)this.operationId()).add("Action", (Object)this.actionAsString()).add("Status", (Object)this.statusAsString()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperationSummary, T> g) {
        return obj -> g.apply((StackSetOperationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private String action;
        private String status;
        private Instant creationTimestamp;
        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationSummary model) {
            this.operationId(model.operationId);
            this.action(model.action);
            this.status(model.status);
            this.creationTimestamp(model.creationTimestamp);
            this.endTimestamp(model.endTimestamp);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(StackSetOperationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public StackSetOperationSummary build() {
            return new StackSetOperationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetOperationSummary> {
        public Builder operationId(String var1);

        public Builder action(String var1);

        public Builder action(StackSetOperationAction var1);

        public Builder status(String var1);

        public Builder status(StackSetOperationStatus var1);

        public Builder creationTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);
    }
}

