/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for <a>DescribeStackResources</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackResourcesRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DescribeStackResourcesRequest.Builder, DescribeStackResourcesRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DescribeStackResourcesRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalResourceId").getter(getter(DescribeStackResourcesRequest::logicalResourceId))
            .setter(setter(Builder::logicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()).build();

    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalResourceId").getter(getter(DescribeStackResourcesRequest::physicalResourceId))
            .setter(setter(Builder::physicalResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD));

    private final String stackName;

    private final String logicalResourceId;

    private final String physicalResourceId;

    private DescribeStackResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
    }

    /**
     * <p>
     * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Running stacks: You can specify either the stack's name or its unique stack ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Deleted stacks: You must specify the unique stack ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: There is no default value.
     * </p>
     * <p>
     * Required: Conditional. If you do not specify <code>StackName</code>, you must specify
     * <code>PhysicalResourceId</code>.
     * </p>
     * 
     * @return The name or the unique stack ID that is associated with the stack, which are not always
     *         interchangeable:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Running stacks: You can specify either the stack's name or its unique stack ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deleted stacks: You must specify the unique stack ID.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: There is no default value.
     *         </p>
     *         <p>
     *         Required: Conditional. If you do not specify <code>StackName</code>, you must specify
     *         <code>PhysicalResourceId</code>.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The logical name of the resource as specified in the template.
     * </p>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The logical name of the resource as specified in the template.</p>
     *         <p>
     *         Default: There is no default value.
     */
    public String logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
     * CloudFormation.
     * </p>
     * <p>
     * For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code> corresponds to
     * the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to <code>DescribeStackResources</code>
     * to find which stack the instance belongs to and what other resources are part of the stack.
     * </p>
     * <p>
     * Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
     * <code>StackName</code>.
     * </p>
     * <p>
     * Default: There is no default value.
     * </p>
     * 
     * @return The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
     *         CloudFormation.</p>
     *         <p>
     *         For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code>
     *         corresponds to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to
     *         <code>DescribeStackResources</code> to find which stack the instance belongs to and what other resources
     *         are part of the stack.
     *         </p>
     *         <p>
     *         Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
     *         <code>StackName</code>.
     *         </p>
     *         <p>
     *         Default: There is no default value.
     */
    public String physicalResourceId() {
        return physicalResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesRequest)) {
            return false;
        }
        DescribeStackResourcesRequest other = (DescribeStackResourcesRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStackResourcesRequest").add("StackName", stackName())
                .add("LogicalResourceId", logicalResourceId()).add("PhysicalResourceId", physicalResourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "LogicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "PhysicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourcesRequest, T> g) {
        return obj -> g.apply((DescribeStackResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackResourcesRequest> {
        /**
         * <p>
         * The name or the unique stack ID that is associated with the stack, which are not always interchangeable:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Running stacks: You can specify either the stack's name or its unique stack ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * Deleted stacks: You must specify the unique stack ID.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: There is no default value.
         * </p>
         * <p>
         * Required: Conditional. If you do not specify <code>StackName</code>, you must specify
         * <code>PhysicalResourceId</code>.
         * </p>
         * 
         * @param stackName
         *        The name or the unique stack ID that is associated with the stack, which are not always
         *        interchangeable:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Running stacks: You can specify either the stack's name or its unique stack ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deleted stacks: You must specify the unique stack ID.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: There is no default value.
         *        </p>
         *        <p>
         *        Required: Conditional. If you do not specify <code>StackName</code>, you must specify
         *        <code>PhysicalResourceId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The logical name of the resource as specified in the template.
         * </p>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical name of the resource as specified in the template.</p>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(String logicalResourceId);

        /**
         * <p>
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by AWS
         * CloudFormation.
         * </p>
         * <p>
         * For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code> corresponds
         * to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to
         * <code>DescribeStackResources</code> to find which stack the instance belongs to and what other resources are
         * part of the stack.
         * </p>
         * <p>
         * Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
         * <code>StackName</code>.
         * </p>
         * <p>
         * Default: There is no default value.
         * </p>
         * 
         * @param physicalResourceId
         *        The name or unique identifier that corresponds to a physical instance ID of a resource supported by
         *        AWS CloudFormation.</p>
         *        <p>
         *        For example, for an Amazon Elastic Compute Cloud (EC2) instance, <code>PhysicalResourceId</code>
         *        corresponds to the <code>InstanceId</code>. You can pass the EC2 <code>InstanceId</code> to
         *        <code>DescribeStackResources</code> to find which stack the instance belongs to and what other
         *        resources are part of the stack.
         *        </p>
         *        <p>
         *        Required: Conditional. If you do not specify <code>PhysicalResourceId</code>, you must specify
         *        <code>StackName</code>.
         *        </p>
         *        <p>
         *        Default: There is no default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(String physicalResourceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackName;

        private String logicalResourceId;

        private String physicalResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesRequest model) {
            super(model);
            stackName(model.stackName);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getLogicalResourceId() {
            return logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStackResourcesRequest build() {
            return new DescribeStackResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
